/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud;

import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.encog.bot.BotUtil;
import org.encog.util.http.FormUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousCloudRequest
implements Runnable {
    private final URL url;
    private final Map<String, String> params;

    public AsynchronousCloudRequest(URL uRL) {
        this.url = uRL;
        this.params = new HashMap<String, String>();
    }

    public AsynchronousCloudRequest(URL uRL, Map<String, String> map) {
        this.url = uRL;
        this.params = map;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public void run() {
        try {
            if (this.params.size() > 0) {
                URLConnection uRLConnection = this.url.openConnection();
                uRLConnection.setDoOutput(true);
                OutputStream outputStream = uRLConnection.getOutputStream();
                FormUtility formUtility = new FormUtility(outputStream, null);
                for (String string : this.params.keySet()) {
                    formUtility.add(string, this.params.get(string));
                }
                formUtility.complete();
                BotUtil.loadPage(uRLConnection.getInputStream());
            } else {
                URLConnection uRLConnection = this.url.openConnection();
                BotUtil.loadPage(uRLConnection.getInputStream());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

