/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.utils.FlipUtils;
import net.java.balloontip.utils.ImageUtils;

public class TexturedBalloonStyle
extends BalloonTipStyle {
    private int arcWidth;
    private int arcHeight;
    private BufferedImage bg;
    private Rectangle bgBounds;
    private Color borderColor;

    public TexturedBalloonStyle(int n, int n2, Image image, Color color) {
        this.arcWidth = n;
        this.arcHeight = n2;
        this.bg = ImageUtils.toBufferedImage(image);
        this.bgBounds = new Rectangle(0, 0, this.bg.getWidth(), this.bg.getHeight());
        this.borderColor = color;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcHeight, this.arcWidth, this.arcHeight, this.arcWidth);
        }
        return new Insets(this.arcHeight, this.arcWidth, this.arcHeight + this.verticalOffset, this.arcWidth);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Point point;
        int n5;
        int n6;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n7 = n2;
        if (this.flipY) {
            n7 = n2 + this.verticalOffset;
        }
        graphics2D.setPaint(new TexturePaint(this.bg, this.bgBounds));
        graphics2D.fillRoundRect(n, n7, n3, n4 - this.verticalOffset, this.arcWidth * 2, this.arcHeight * 2);
        graphics2D.setColor(this.borderColor);
        graphics2D.drawRoundRect(n, n7, n3 - 1, n4 - this.verticalOffset - 1, this.arcWidth * 2, this.arcHeight * 2);
        int[] nArray = new int[]{n + this.horizontalOffset, n + this.horizontalOffset + this.verticalOffset, n + this.horizontalOffset};
        int[] nArray2 = new int[]{n2 + n4 - this.verticalOffset - 1, n2 + n4 - this.verticalOffset - 1, n2 + n4 - 1};
        if (this.flipY) {
            n6 = n4 - 1;
            for (n5 = 0; n5 < nArray.length; ++n5) {
                point = FlipUtils.flipHorizontally(nArray[n5], nArray2[n5], n6);
                nArray[n5] = point.x;
                nArray2[n5] = point.y;
            }
        }
        if (this.flipX) {
            n6 = n3 - 1;
            for (n5 = 0; n5 < nArray.length; ++n5) {
                point = FlipUtils.flipVertically(nArray[n5], nArray2[n5], n6);
                nArray[n5] = point.x;
                nArray2[n5] = point.y;
            }
        }
        graphics2D.setPaint(new TexturePaint(this.bg, this.bgBounds));
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setColor(this.borderColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics2D.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
        graphics2D.setPaint(new TexturePaint(this.bg, this.bgBounds));
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setColor(this.borderColor);
        graphics2D.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics2D.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
    }

    @Override
    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset;
    }
}

