/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.opengis.referencing.operation.TransformException;

public abstract class VerticalTransform
extends AbstractMathTransform {
    protected VerticalTransform() {
    }

    public final int getSourceDimensions() {
        return 3;
    }

    public final int getTargetDimensions() {
        return 3;
    }

    protected abstract double heightOffset(double var1, double var3, double var5) throws TransformException;

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int step;
        if (srcPts == dstPts && srcOff < dstOff) {
            srcOff += 3 * (numPts - 1);
            dstOff += 3 * (numPts - 1);
            step = -3;
        } else {
            step = 3;
        }
        while (--numPts >= 0) {
            float y;
            float x;
            dstPts[dstOff + 0] = x = srcPts[srcOff + 0];
            dstPts[dstOff + 1] = y = srcPts[srcOff + 1];
            float z = srcPts[srcOff + 2];
            dstPts[dstOff + 2] = (float)((double)z + this.heightOffset(x, y, z));
            srcOff += step;
            dstOff += step;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int step;
        if (srcPts == dstPts && srcOff < dstOff) {
            srcOff += 3 * (numPts - 1);
            dstOff += 3 * (numPts - 1);
            step = -3;
        } else {
            step = 3;
        }
        while (--numPts >= 0) {
            double y;
            double x;
            dstPts[dstOff + 0] = x = srcPts[srcOff + 0];
            dstPts[dstOff + 1] = y = srcPts[srcOff + 1];
            double z = srcPts[srcOff + 2];
            dstPts[dstOff + 2] = z + this.heightOffset(x, y, z);
            srcOff += step;
            dstOff += step;
        }
    }
}

