/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.J3dGraphicsConfig;
import javax.media.j3d.NativeScreenInfo;
import javax.media.j3d.VirtualUniverse;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;

class NativeConfigTemplate3D {
    static final int RED_SIZE = 0;
    static final int GREEN_SIZE = 1;
    static final int BLUE_SIZE = 2;
    static final int ALPHA_SIZE = 3;
    static final int ACCUM_BUFFER = 4;
    static final int DEPTH_SIZE = 5;
    static final int DOUBLEBUFFER = 6;
    static final int STEREO = 7;
    static final int ANTIALIASING = 8;
    static final int NUM_ITEMS = 9;

    NativeConfigTemplate3D() {
        VirtualUniverse.createMC();
    }

    native int choosePixelFormat(long var1, int var3, int[] var4);

    native boolean isStereoAvailable(long var1, long var3, int var5, int var6);

    native boolean isDoubleBufferAvailable(long var1, long var3, int var5, int var6);

    native boolean isSceneAntialiasingAccumAvailable(long var1, long var3, int var5, int var6);

    native boolean isSceneAntialiasingMultiSamplesAvailable(long var1, long var3, int var5, int var6);

    GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration[] graphicsConfigurationArray) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfigurationArray[0]).getDevice();
        VirtualUniverse.loadLibraries();
        int[] nArray = new int[9];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getScreen();
        int n2 = this.choosePixelFormat(0L, n, nArray);
        if (n2 == -1) {
            return null;
        }
        return new J3dGraphicsConfig((GraphicsDevice)win32GraphicsDevice, n2);
    }

    boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D graphicsConfigTemplate3D, GraphicsConfiguration graphicsConfiguration) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        int[] nArray = new int[9];
        nArray[0] = graphicsConfigTemplate3D.getRedSize();
        nArray[1] = graphicsConfigTemplate3D.getGreenSize();
        nArray[2] = graphicsConfigTemplate3D.getBlueSize();
        nArray[5] = graphicsConfigTemplate3D.getDepthSize();
        nArray[6] = graphicsConfigTemplate3D.getDoubleBuffer();
        nArray[7] = graphicsConfigTemplate3D.getStereo();
        nArray[8] = graphicsConfigTemplate3D.getSceneAntialiasing();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getScreen();
        int n2 = this.choosePixelFormat(0L, n, nArray);
        return n2 != -1;
    }

    boolean hasStereo(GraphicsConfiguration graphicsConfiguration) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((J3dGraphicsConfig)((Object)graphicsConfiguration)).getPixelFormat();
        return this.isStereoAvailable(0L, n, n2, n3);
    }

    boolean hasDoubleBuffer(GraphicsConfiguration graphicsConfiguration) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((J3dGraphicsConfig)((Object)graphicsConfiguration)).getPixelFormat();
        return this.isDoubleBufferAvailable(0L, n, n2, n3);
    }

    boolean hasSceneAntialiasingAccum(GraphicsConfiguration graphicsConfiguration) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((J3dGraphicsConfig)((Object)graphicsConfiguration)).getPixelFormat();
        return this.isSceneAntialiasingAccumAvailable(0L, n, n2, n3);
    }

    boolean hasSceneAntialiasingMultiSamples(GraphicsConfiguration graphicsConfiguration) {
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((Win32GraphicsConfig)graphicsConfiguration).getDevice();
        NativeScreenInfo nativeScreenInfo = new NativeScreenInfo((GraphicsDevice)win32GraphicsDevice);
        int n = nativeScreenInfo.getDisplay();
        int n2 = nativeScreenInfo.getScreen();
        int n3 = ((J3dGraphicsConfig)((Object)graphicsConfiguration)).getPixelFormat();
        return this.isSceneAntialiasingMultiSamplesAvailable(0L, n, n2, n3);
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

