/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.units.AddConverter;
import javax.units.AlternateUnit;
import javax.units.ConversionException;
import javax.units.Converter;
import javax.units.MultiplyConverter;
import javax.units.ProductUnit;
import javax.units.TransformedUnit;
import javax.units.UnitFormat;

public abstract class Unit
implements Serializable {
    private static final Unit[] NONE = new Unit[0];
    transient int _id;
    private transient Unit[] _multiplyLookUp = NONE;
    private transient Unit[] _divideLookUp = NONE;
    private transient Unit[] _rootLookUp = NONE;
    private transient Unit[] _powLookUp = NONE;
    private static final Map UNITS = new HashMap();
    private static final Map SYMBOLS = new HashMap();
    static final Map DIMENSIONS = Collections.synchronizedMap(new HashMap());
    static final Map TO_DIMENSIONS = Collections.synchronizedMap(new HashMap());
    public static final Unit ONE = new ProductUnit();
    final String _symbol;
    private transient int _hashCode;

    Unit(String string) {
        this._symbol = string;
    }

    public final boolean isCompatible(Unit unit) {
        return this == unit || this.getDimension() == unit.getDimension();
    }

    public final Unit getDimension() {
        Unit unit = (Unit)DIMENSIONS.get(this);
        if (unit == null) {
            unit = this.getCtxDimension();
            DIMENSIONS.put(this, unit);
        }
        return unit;
    }

    public final Converter getConverterTo(Unit unit) throws ConversionException {
        if (this == unit) {
            return Converter.IDENTITY;
        }
        if (this.isCompatible(unit)) {
            Converter converter;
            Converter converter2 = (Converter)TO_DIMENSIONS.get(this);
            if (converter2 == null) {
                converter2 = this.getCtxToDimension();
                TO_DIMENSIONS.put(this, converter2);
            }
            if ((converter = (Converter)TO_DIMENSIONS.get(unit)) == null) {
                converter = unit.getCtxToDimension();
                TO_DIMENSIONS.put(unit, converter);
            }
            return converter.inverse().concatenate(converter2);
        }
        throw new ConversionException(this + " is not compatible with " + unit + " in current context");
    }

    public final boolean isSystemUnit() {
        return this.getSystemUnit() == this;
    }

    public abstract Unit getSystemUnit();

    public final Unit alternate(String string) {
        return AlternateUnit.getInstance(string, this);
    }

    public final Unit add(double d) {
        return TransformedUnit.getInstance(this, new AddConverter(d));
    }

    public final Unit multiply(double d) {
        return TransformedUnit.getInstance(this, new MultiplyConverter(d));
    }

    public final Unit multiply(Unit unit) {
        Object object;
        if (unit._id >= this._multiplyLookUp.length) {
            object = new Unit[unit._id + 1];
            System.arraycopy(this._multiplyLookUp, 0, object, 0, this._multiplyLookUp.length);
            this._multiplyLookUp = object;
        }
        if ((object = this._multiplyLookUp[unit._id]) != null) {
            return object;
        }
        this._multiplyLookUp[unit._id] = object = ProductUnit.getProductInstance(this, unit);
        return object;
    }

    public final Unit divide(Unit unit) {
        Object object;
        if (unit._id >= this._divideLookUp.length) {
            object = new Unit[unit._id + 1];
            System.arraycopy(this._divideLookUp, 0, object, 0, this._divideLookUp.length);
            this._divideLookUp = object;
        }
        if ((object = this._divideLookUp[unit._id]) != null) {
            return object;
        }
        this._divideLookUp[unit._id] = object = ProductUnit.getQuotientInstance(this, unit);
        return object;
    }

    public final Unit root(int n) {
        if (n > 1) {
            if (this._rootLookUp.length < n - 1) {
                this._rootLookUp = new Unit[n - 1];
            }
            if (this._rootLookUp[n - 2] == null) {
                this._rootLookUp[n - 2] = ProductUnit.getRootInstance(this, n);
            }
            return this._rootLookUp[n - 2];
        }
        if (n == 1) {
            return this;
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return ONE.divide(this.root(-n));
    }

    public final Unit pow(int n) {
        if (n > 1) {
            if (this._powLookUp.length < n - 1) {
                this._powLookUp = new Unit[n - 1];
            }
            if (this._powLookUp[n - 2] == null) {
                this._powLookUp[n - 2] = ProductUnit.getPowInstance(this, n);
            }
            return this._powLookUp[n - 2];
        }
        if (n == 1) {
            return this;
        }
        if (n == 0) {
            return ONE;
        }
        return ONE.divide(this.pow(-n));
    }

    public static Unit valueOf(CharSequence charSequence) {
        try {
            return UnitFormat.getStandardInstance().parseUnit(charSequence);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public static Collection getInstances() {
        return Collections.unmodifiableCollection(UNITS.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unit searchSymbol(CharSequence charSequence) {
        Class clazz = Unit.class;
        synchronized (clazz) {
            return (Unit)SYMBOLS.get(charSequence);
        }
    }

    abstract Unit getCtxDimension();

    abstract Converter getCtxToDimension();

    public final String toString() {
        return this.appendTo(new StringBuffer()).toString();
    }

    public final StringBuffer appendTo(StringBuffer stringBuffer) {
        return UnitFormat.getStandardInstance().format(this, stringBuffer, null);
    }

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Unit getInstance(Unit unit) {
        Class clazz = Unit.class;
        synchronized (clazz) {
            unit._hashCode = unit.calculateHashCode();
            Object v = UNITS.get(unit);
            if (v != null) {
                return (Unit)v;
            }
            if (unit._symbol != null) {
                v = SYMBOLS.get(unit._symbol);
                if (v != null) {
                    throw new UnsupportedOperationException("The symbol: " + unit._symbol + " is currently associated to an instance of " + v.getClass());
                }
                SYMBOLS.put(unit._symbol, unit);
            }
            UNITS.put(unit, unit);
            unit._id = UNITS.size();
            return unit;
        }
    }

    abstract int calculateHashCode();

    protected Object readResolve() {
        return Unit.getInstance(this);
    }

    static {
        UNITS.put(ONE, ONE);
    }
}

