/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.internal.cfg.DefaultConstraintMapping;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProviderKeyedByClassName;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.spi.group.DefaultGroupSequenceProvider;

public class ProgrammaticMetaDataProvider
extends MetaDataProviderKeyedByClassName {
    private static final Log log = LoggerFactory.make();
    private final AnnotationProcessingOptions annotationProcessingOptions;
    private final ParameterNameProvider parameterNameProvider;

    public ProgrammaticMetaDataProvider(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider, Set<ConstraintMapping> programmaticMappings) {
        super(constraintHelper);
        Contracts.assertNotNull(programmaticMappings);
        this.parameterNameProvider = parameterNameProvider;
        ConstraintMappingContext mergedContext = this.createMergedMappingContext(programmaticMappings);
        this.initProgrammaticConfiguration(mergedContext);
        this.annotationProcessingOptions = mergedContext.getAnnotationProcessingOptions();
    }

    @Override
    public AnnotationProcessingOptions getAnnotationProcessingOptions() {
        return this.annotationProcessingOptions;
    }

    private void initProgrammaticConfiguration(ConstraintMappingContext context) {
        for (Class<?> clazz : context.getConfiguredClasses()) {
            this.initClass(clazz, context);
        }
    }

    private <T> void initClass(Class<T> clazz, ConstraintMappingContext context) {
        Set<ConstrainedElement> constrainedElements = this.retrievePropertyMetaData(context.getConstraintConfig().get(clazz), context.getCascadeConfig().get(clazz));
        Set<ConstrainedElement> methodMetaData = this.retrieveMethodMetaData(context.getMethodCascadeConfig().get(clazz), context.getMethodConstraintConfig().get(clazz));
        constrainedElements.addAll(methodMetaData);
        DefaultGroupSequenceProvider<T> sequenceProvider = this.getDefaultGroupSequenceProvider(clazz, context);
        this.addBeanConfiguration(clazz, this.createBeanConfiguration(ConfigurationSource.API, clazz, constrainedElements, context.getDefaultSequence(clazz), sequenceProvider));
    }

    private <T> DefaultGroupSequenceProvider<? super T> getDefaultGroupSequenceProvider(Class<T> beanType, ConstraintMappingContext context) {
        Class<DefaultGroupSequenceProvider<T>> providerClass = context.getDefaultGroupSequenceProvider(beanType);
        if (providerClass != null) {
            return ReflectionHelper.newInstance(providerClass, "default group sequence provider");
        }
        return null;
    }

    private Set<ConstrainedElement> retrievePropertyMetaData(Set<ConfiguredConstraint<?, BeanConstraintLocation>> constraints, Set<BeanConstraintLocation> cascades) {
        Map<BeanConstraintLocation, Set<ConfiguredConstraint<?, BeanConstraintLocation>>> constraintsByLocation = CollectionHelper.partition(constraints, this.constraintsByLocation());
        if (cascades == null) {
            cascades = Collections.emptySet();
        }
        HashSet<BeanConstraintLocation> allConfiguredProperties = new HashSet<BeanConstraintLocation>(cascades);
        allConfiguredProperties.addAll(constraintsByLocation.keySet());
        HashSet<ConstrainedElement> allPropertyMetaData = CollectionHelper.newHashSet();
        for (BeanConstraintLocation oneConfiguredProperty : allConfiguredProperties) {
            if (oneConfiguredProperty.getElementType() == ElementType.FIELD) {
                allPropertyMetaData.add(new ConstrainedField(ConfigurationSource.API, oneConfiguredProperty, this.asMetaConstraints(constraintsByLocation.get(oneConfiguredProperty)), Collections.<Class<?>, Class<?>>emptyMap(), cascades.contains(oneConfiguredProperty)));
                continue;
            }
            allPropertyMetaData.add(new ConstrainedType(ConfigurationSource.API, oneConfiguredProperty, this.asMetaConstraints(constraintsByLocation.get(oneConfiguredProperty))));
        }
        return allPropertyMetaData;
    }

    private Set<ConstrainedElement> retrieveMethodMetaData(Set<ExecutableConstraintLocation> methodCascades, Set<ConfiguredConstraint<?, ExecutableConstraintLocation>> methodConstraints) {
        Map<Method, Set<ExecutableConstraintLocation>> cascadesByMethod = CollectionHelper.partition(methodCascades, this.cascadesByMethod());
        Map<Method, Set<ConfiguredConstraint<?, ExecutableConstraintLocation>>> constraintsByMethod = CollectionHelper.partition(methodConstraints, this.constraintsByMethod());
        HashSet<Method> allConfiguredMethods = new HashSet<Method>(cascadesByMethod.keySet());
        allConfiguredMethods.addAll(constraintsByMethod.keySet());
        HashSet<ConstrainedElement> allMethodMetaData = CollectionHelper.newHashSet();
        for (Method method : allConfiguredMethods) {
            List<String> parameterNames = this.parameterNameProvider.getParameterNames(method);
            Map<Integer, Set<ExecutableConstraintLocation>> cascadesByParameter = CollectionHelper.partition(cascadesByMethod.get(method), this.cascadesByParameterIndex());
            Map<Integer, Set<ConfiguredConstraint<?, ExecutableConstraintLocation>>> constraintsByParameter = CollectionHelper.partition(constraintsByMethod.get(method), this.constraintsByParameterIndex());
            ArrayList<ConstrainedParameter> parameterMetaDataList = CollectionHelper.newArrayList();
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                parameterMetaDataList.add(new ConstrainedParameter(ConfigurationSource.API, new ExecutableConstraintLocation(method, (Integer)i), parameterNames.get(i), this.asMetaConstraints(constraintsByParameter.get(i)), Collections.<Class<?>, Class<?>>emptyMap(), cascadesByParameter.containsKey(i)));
            }
            ConstrainedExecutable methodMetaData = new ConstrainedExecutable(ConfigurationSource.API, new ExecutableConstraintLocation(method), parameterMetaDataList, Collections.<MetaConstraint<?>>emptySet(), this.asMetaConstraints(constraintsByParameter.get(null)), Collections.<Class<?>, Class<?>>emptyMap(), cascadesByParameter.containsKey(null));
            allMethodMetaData.add(methodMetaData);
        }
        return allMethodMetaData;
    }

    private Set<MetaConstraint<?>> asMetaConstraints(Set<? extends ConfiguredConstraint<?, ?>> constraints) {
        if (constraints == null) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> theValue = CollectionHelper.newHashSet();
        for (ConfiguredConstraint<?, ?> oneConfiguredConstraint : constraints) {
            theValue.add(this.asMetaConstraint(oneConfiguredConstraint));
        }
        return theValue;
    }

    private <A extends Annotation> MetaConstraint<A> asMetaConstraint(ConfiguredConstraint<A, ? extends ConstraintLocation> config) {
        ConstraintDescriptorImpl<A> constraintDescriptor = new ConstraintDescriptorImpl<A>(config.getLocation().getMember(), config.createAnnotationProxy(), this.constraintHelper, config.getLocation().getElementType(), ConstraintOrigin.DEFINED_LOCALLY);
        return new MetaConstraint<A>(constraintDescriptor, config.getLocation());
    }

    private CollectionHelper.Partitioner<Method, ExecutableConstraintLocation> cascadesByMethod() {
        return new CollectionHelper.Partitioner<Method, ExecutableConstraintLocation>(){

            @Override
            public Method getPartition(ExecutableConstraintLocation location) {
                return (Method)location.getMember();
            }
        };
    }

    private CollectionHelper.Partitioner<Integer, ExecutableConstraintLocation> cascadesByParameterIndex() {
        return new CollectionHelper.Partitioner<Integer, ExecutableConstraintLocation>(){

            @Override
            public Integer getPartition(ExecutableConstraintLocation location) {
                return location.getParameterIndex();
            }
        };
    }

    private CollectionHelper.Partitioner<Method, ConfiguredConstraint<?, ExecutableConstraintLocation>> constraintsByMethod() {
        return new CollectionHelper.Partitioner<Method, ConfiguredConstraint<?, ExecutableConstraintLocation>>(){

            @Override
            public Method getPartition(ConfiguredConstraint<?, ExecutableConstraintLocation> constraint) {
                return (Method)constraint.getLocation().getMember();
            }
        };
    }

    private CollectionHelper.Partitioner<Integer, ConfiguredConstraint<?, ExecutableConstraintLocation>> constraintsByParameterIndex() {
        return new CollectionHelper.Partitioner<Integer, ConfiguredConstraint<?, ExecutableConstraintLocation>>(){

            @Override
            public Integer getPartition(ConfiguredConstraint<?, ExecutableConstraintLocation> v) {
                return v.getLocation().getParameterIndex();
            }
        };
    }

    private ConstraintMappingContext createMergedMappingContext(Set<ConstraintMapping> programmaticMappings) {
        if (programmaticMappings.size() == 1) {
            return ((DefaultConstraintMapping)programmaticMappings.iterator().next()).getContext();
        }
        ConstraintMappingContext mergedContext = new ConstraintMappingContext();
        for (ConstraintMapping mapping : programmaticMappings) {
            ConstraintMappingContext context = ((DefaultConstraintMapping)mapping).getContext();
            mergedContext.getAnnotationProcessingOptions().merge(context.getAnnotationProcessingOptions());
            for (Set<ConfiguredConstraint<?, BeanConstraintLocation>> set : context.getConstraintConfig().values()) {
                for (ConfiguredConstraint<?, BeanConstraintLocation> configuredConstraint : set) {
                    mergedContext.addConstraintConfig(configuredConstraint);
                }
            }
            for (Set<Object> set : context.getCascadeConfig().values()) {
                for (BeanConstraintLocation beanConstraintLocation : set) {
                    mergedContext.addCascadeConfig(beanConstraintLocation);
                }
            }
            for (Set<Object> set : context.getMethodConstraintConfig().values()) {
                for (ConfiguredConstraint configuredConstraint : set) {
                    mergedContext.addMethodConstraintConfig(configuredConstraint);
                }
            }
            for (Set<Object> set : context.getMethodCascadeConfig().values()) {
                for (ExecutableConstraintLocation executableConstraintLocation : set) {
                    mergedContext.addMethodCascadeConfig(executableConstraintLocation);
                }
            }
            this.mergeGroupSequenceAndGroupSequenceProvider(mergedContext, context);
        }
        return mergedContext;
    }

    private void mergeGroupSequenceAndGroupSequenceProvider(ConstraintMappingContext mergedContext, ConstraintMappingContext context) {
        for (Class<?> clazz : context.getConfiguredClasses()) {
            this.mergeSequenceAndProviderForClass(mergedContext, context, clazz);
        }
    }

    private <T> void mergeSequenceAndProviderForClass(ConstraintMappingContext mergedContext, ConstraintMappingContext context, Class<T> clazz) {
        if (context.getDefaultGroupSequenceProvider(clazz) != null) {
            if (mergedContext.getDefaultGroupSequenceProvider(clazz) != null) {
                throw log.getMultipleDefinitionOfDefaultGroupSequenceProviderException();
            }
            mergedContext.addDefaultGroupSequenceProvider(clazz, context.getDefaultGroupSequenceProvider(clazz));
        }
        if (context.getDefaultSequence(clazz) != null) {
            if (mergedContext.getDefaultSequence(clazz) != null) {
                throw log.getMultipleDefinitionOfDefaultGroupSequenceException();
            }
            mergedContext.addDefaultGroupSequence(clazz, context.getDefaultSequence(clazz));
        }
    }

    private CollectionHelper.Partitioner<BeanConstraintLocation, ConfiguredConstraint<?, BeanConstraintLocation>> constraintsByLocation() {
        return new CollectionHelper.Partitioner<BeanConstraintLocation, ConfiguredConstraint<?, BeanConstraintLocation>>(){

            @Override
            public BeanConstraintLocation getPartition(ConfiguredConstraint<?, BeanConstraintLocation> constraint) {
                return constraint.getLocation();
            }
        };
    }
}

