/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.matrixes;

import org.jgrasstools.gears.utils.math.matrixes.Matrix;
import org.jgrasstools.gears.utils.math.matrixes.MatrixException;

public class ColumnVector
extends Matrix {
    public ColumnVector(int n) {
        super(n, 1);
    }

    public ColumnVector(double[] values) {
        this.set(values);
    }

    private ColumnVector(Matrix m) {
        this.set(m);
    }

    public int size() {
        return this.nRows;
    }

    public double at(int i) {
        return this.values[i][0];
    }

    public double[] copyValues1D() {
        double[] v = new double[this.nRows];
        for (int r = 0; r < this.nRows; ++r) {
            v[r] = this.values[r][0];
        }
        return v;
    }

    private void set(Matrix m) {
        this.nRows = m.nRows;
        this.nCols = 1;
        this.values = m.values;
    }

    protected void set(double[] values) {
        this.nRows = values.length;
        this.nCols = 1;
        this.values = new double[this.nRows][1];
        for (int r = 0; r < this.nRows; ++r) {
            this.values[r][0] = values[r];
        }
    }

    public void set(int i, double value) {
        this.values[i][0] = value;
    }

    public ColumnVector add(ColumnVector cv) throws MatrixException {
        return new ColumnVector(super.add(cv));
    }

    public ColumnVector subtract(ColumnVector cv) throws MatrixException {
        return new ColumnVector(super.subtract(cv));
    }

    public double norm() {
        double t = 0.0;
        for (int r = 0; r < this.nRows; ++r) {
            double v = this.values[r][0];
            t += v * v;
        }
        return Math.sqrt(t);
    }

    public void print() {
        for (int r = 0; r < this.nRows; ++r) {
            System.out.print("  " + this.values[r][0]);
        }
        System.out.println();
    }
}

