/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.math.interpolation;

import java.util.List;
import org.jgrasstools.gears.utils.math.interpolation.Interpolator;

public class LinearListInterpolator
implements Interpolator {
    private final List<Double> xList;
    private final List<Double> yList;
    private boolean isInverse = false;

    public LinearListInterpolator(List<Double> xList, List<Double> yList) {
        if (xList.size() != yList.size()) {
            throw new IllegalArgumentException("The lists have to be of the same length.");
        }
        this.xList = xList;
        this.yList = yList;
    }

    public Double linearInterpolateY(Double xValue) {
        Double first = this.xList.get(0);
        Double last = this.xList.get(this.xList.size() - 1);
        if (first <= last) {
            if (xValue < this.xList.get(0) || xValue > this.xList.get(this.xList.size() - 1)) {
                return new Double(Double.NaN);
            }
            this.isInverse = false;
        } else {
            if (xValue > this.xList.get(0) || xValue < this.xList.get(this.xList.size() - 1)) {
                return new Double(Double.NaN);
            }
            this.isInverse = true;
        }
        for (int i = 0; i < this.xList.size(); ++i) {
            Double x2 = this.xList.get(i);
            if (x2.equals(xValue)) {
                return this.yList.get(i);
            }
            if (!(!this.isInverse && x2 > xValue) && (!this.isInverse || !(x2 < xValue))) continue;
            double x1 = this.xList.get(i - 1);
            double y1 = this.yList.get(i - 1);
            double y2 = this.yList.get(i);
            double y = (y2 - y1) * (xValue - x1) / (x2 - x1) + y1;
            return y;
        }
        return new Double(Double.NaN);
    }

    public Double linearInterpolateX(Double yValue) {
        Double first = this.yList.get(0);
        Double last = this.yList.get(this.yList.size() - 1);
        if (first <= last) {
            if (yValue < this.yList.get(0) || yValue > this.yList.get(this.yList.size() - 1)) {
                return new Double(Double.NaN);
            }
            this.isInverse = false;
        } else {
            if (yValue > this.yList.get(0) || yValue < this.yList.get(this.yList.size() - 1)) {
                return new Double(Double.NaN);
            }
            this.isInverse = true;
        }
        for (int i = 0; i < this.yList.size(); ++i) {
            Double y2 = this.yList.get(i);
            if (y2.equals(yValue)) {
                return this.xList.get(i);
            }
            if (!(!this.isInverse && y2 > yValue) && (!this.isInverse || !(y2 < yValue))) continue;
            double y1 = this.yList.get(i - 1);
            double x1 = this.xList.get(i - 1);
            double x2 = this.xList.get(i);
            double x = (x2 - x1) * (yValue - y1) / (y2 - y1) + x1;
            return x;
        }
        return new Double(Double.NaN);
    }

    @Override
    public double getInterpolated(double x) {
        return this.linearInterpolateY(x);
    }
}

