/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.files;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class FileUtilities {
    public static void copyFile(String fromFile, String toFile) throws IOException {
        Files.copy(Paths.get(fromFile, new String[0]), Paths.get(toFile, new String[0]), new CopyOption[0]);
    }

    public static void copyFile(File in, File out) throws IOException {
        FileUtilities.copyFile(in.getAbsolutePath(), out.getAbsolutePath());
    }

    public static boolean deleteFileOrDir(File filehandle) {
        boolean isdel;
        if (filehandle.isDirectory()) {
            String[] children;
            for (String aChildren : children = filehandle.list()) {
                boolean success = FileUtilities.deleteFileOrDir(new File(filehandle, aChildren));
                if (success) continue;
                return false;
            }
        }
        if (!(isdel = filehandle.delete())) {
            filehandle.deleteOnExit();
        }
        return isdel;
    }

    public static boolean deleteFileOrDirOnExit(File filehandle) {
        if (filehandle.isDirectory()) {
            String[] children;
            for (String aChildren : children = filehandle.list()) {
                boolean success = FileUtilities.deleteFileOrDir(new File(filehandle, aChildren));
                if (success) continue;
                return false;
            }
        }
        filehandle.deleteOnExit();
        return true;
    }

    public static byte[] readFileToBytes(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        return bytes;
    }

    public static String readInputStreamToString(InputStream inputStream) throws IOException {
        ArrayList<Byte> bytesList = new ArrayList<Byte>();
        byte b = 0;
        while ((b = (byte)inputStream.read()) != -1) {
            bytesList.add(b);
        }
        inputStream.close();
        byte[] bArray = new byte[bytesList.size()];
        for (int i = 0; i < bArray.length; ++i) {
            bArray[i] = (Byte)bytesList.get(i);
        }
        String file = new String(bArray);
        return file;
    }

    public static String readFile(String filePath) throws IOException {
        return FileUtilities.readFile(new File(filePath));
    }

    public static String readFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("The required projection file is not available: " + file.getAbsolutePath());
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder sb = new StringBuilder(200);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static List<String> readFileToLinesList(String filePath) throws IOException {
        return FileUtilities.readFileToLinesList(new File(filePath));
    }

    public static List<String> readFileToLinesList(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static void writeFile(String text, File file) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(text);
        }
    }

    public static void writeFile(List<String> lines, String filePath) throws IOException {
        FileUtilities.writeFile(lines, new File(filePath));
    }

    public static void writeFile(List<String> lines, File file) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                bw.write(line);
                bw.write("\n");
            }
        }
    }

    public static String replaceBackSlashes(String path) {
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    public static String getNameWithoutExtention(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot == -1) {
            return name;
        }
        name = name.substring(0, lastDot);
        return name;
    }

    public static File substituteExtention(File file, String newExtention) {
        String path = file.getAbsolutePath();
        int lastDot = path.lastIndexOf(".");
        path = lastDot == -1 ? path + "." + newExtention : path.substring(0, lastDot) + "." + newExtention;
        return new File(path);
    }

    public static String getSafeFileName(String fileName) {
        char fileSep = '/';
        char escape = '%';
        int len = fileName.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = fileName.charAt(i);
            if (ch < ' ' || ch >= '\u007f' || ch == fileSep || ch == '.' && i == 0 || ch == '?' || ch == escape) {
                sb.append(escape);
                if (ch < '\u0010') {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static LinkedHashMap<String, String> readFileToHashMap(String filePath, String separator, boolean valueFirst) throws IOException {
        if (separator == null) {
            separator = "=";
        }
        List<String> lines = FileUtilities.readFileToLinesList(filePath);
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        for (String line : lines) {
            String value;
            String key;
            if ((line = line.trim()).length() == 0 || !line.contains(separator)) continue;
            String[] lineSplit = line.split(separator);
            if (!valueFirst) {
                key = lineSplit[0].trim();
                value = "";
                if (lineSplit.length > 1) {
                    value = lineSplit[1].trim();
                }
                propertiesMap.put(key, value);
                continue;
            }
            if (lineSplit.length <= 1) continue;
            key = lineSplit[0].trim();
            value = lineSplit[1].trim();
            propertiesMap.put(value, key);
        }
        return propertiesMap;
    }

    public static File stringAsTmpFile(String string) throws Exception {
        File tempFile = File.createTempFile("jgt-", "txt");
        FileUtilities.writeFile(string, tempFile);
        return tempFile;
    }

    public static File stringListAsTmpFile(List<String> list) throws Exception {
        File tempFile = File.createTempFile("jgt-", "txt");
        FileUtilities.writeFile(list, tempFile);
        return tempFile;
    }

    public static File[] getFilesListByExtention(String folderPath, final String ext) {
        File[] shpFiles = new File(folderPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(ext);
            }
        });
        return shpFiles;
    }
}

