/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.spatialite;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.spatialite.SpatialiteDb;
import org.jgrasstools.gears.spatialite.SpatialiteGeometryColumns;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialiteImportUtils {
    public static void createTableFromShp(SpatialiteDb db, File shapeFile) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
        String shpName = FileUtilities.getNameWithoutExtention(shapeFile);
        ArrayList<String> attrSql = new ArrayList<String>();
        List attributeDescriptors = schema.getAttributeDescriptors();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            if (attributeDescriptor instanceof GeometryDescriptor) continue;
            String attrName = attributeDescriptor.getLocalName();
            Class binding = attributeDescriptor.getType().getBinding();
            if (binding.isAssignableFrom(Double.class) || binding.isAssignableFrom(Float.class)) {
                attrSql.add(attrName + " REAL");
                continue;
            }
            if (binding.isAssignableFrom(Long.class) || binding.isAssignableFrom(Integer.class)) {
                attrSql.add(attrName + " INTEGER");
                continue;
            }
            if (binding.isAssignableFrom(String.class)) {
                attrSql.add(attrName + " TEXT");
                continue;
            }
            attrSql.add(attrName + " TEXT");
        }
        db.createTable(shpName, attrSql.toArray(new String[0]));
        String typeString = null;
        GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        if (binding.isAssignableFrom(MultiPolygon.class)) {
            typeString = "MULTIPOLYGON";
        } else if (binding.isAssignableFrom(Polygon.class)) {
            typeString = "POLYGON";
        } else if (binding.isAssignableFrom(MultiLineString.class)) {
            typeString = "MULTILINESTRING";
        } else if (binding.isAssignableFrom(LineString.class)) {
            typeString = "LINESTRING";
        } else if (binding.isAssignableFrom(MultiPoint.class)) {
            typeString = "MULTIPOINT";
        } else if (binding.isAssignableFrom(Point.class)) {
            typeString = "POINT";
        }
        if (typeString != null) {
            String codeFromCrs = CrsUtilities.getCodeFromCrs(schema.getCoordinateReferenceSystem());
            if (codeFromCrs == null || codeFromCrs.toLowerCase().contains("null")) {
                codeFromCrs = "4326";
            }
            codeFromCrs = codeFromCrs.replaceFirst("EPSG:", "");
            db.addGeometryXYColumnAndIndex(shpName, typeString, codeFromCrs);
        }
    }

    public static void importShapefile(SpatialiteDb db, File shapeFile, String tableName, int limit) throws Exception {
        FileDataStore store = FileDataStoreFinder.getDataStore((File)shapeFile);
        SimpleFeatureSource featureSource = store.getFeatureSource();
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        List attributeDescriptors = schema.getAttributeDescriptors();
        SimpleFeatureCollection features = featureSource.getFeatures();
        List<String[]> tableInfo = db.getTableColumns(tableName);
        ArrayList<String> tableColumns = new ArrayList<String>();
        for (String[] item : tableInfo) {
            tableColumns.add(item[0]);
        }
        SpatialiteGeometryColumns geometryColumns = db.getGeometryColumnsForTable(tableName);
        String gCol = geometryColumns.f_geometry_column;
        int epsg = geometryColumns.srid;
        CoordinateReferenceSystem crs = CRS.decode((String)("EPSG:" + epsg));
        ReprojectingFeatureCollection repFeatures = new ReprojectingFeatureCollection(features, crs);
        SimpleFeatureIterator featureIterator = repFeatures.features();
        String valueNames = "";
        String qMarks = "";
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String attrName = attributeDescriptor.getLocalName();
            if (attrName.equals("PK_UID")) continue;
            if (attributeDescriptor instanceof GeometryDescriptor) {
                valueNames = valueNames + "," + gCol;
                qMarks = qMarks + ",GeomFromText(?, " + epsg + ")";
                continue;
            }
            if (!tableColumns.contains(attrName)) {
                throw new IllegalArgumentException("The imported shapefile doesn't seem to match the table's schema.");
            }
            valueNames = valueNames + "," + attrName;
            qMarks = qMarks + ",?";
        }
        valueNames = valueNames.substring(1);
        qMarks = qMarks.substring(1);
        String sql = "INSERT INTO " + tableName + " (" + valueNames + ") VALUES (" + qMarks + ")";
        Connection conn = db.getConnection();
        try (PreparedStatement pStmt = conn.prepareStatement(sql);){
            int count = 0;
            while (featureIterator.hasNext()) {
                SimpleFeature f = (SimpleFeature)featureIterator.next();
                List attributes = f.getAttributes();
                for (int i = 0; i < attributes.size(); ++i) {
                    Object object = attributes.get(i);
                    if (object == null) continue;
                    int iPlus = i + 1;
                    if (object instanceof Double) {
                        pStmt.setDouble(iPlus, (Double)object);
                        continue;
                    }
                    if (object instanceof Float) {
                        pStmt.setFloat(iPlus, ((Float)object).floatValue());
                        continue;
                    }
                    if (object instanceof Integer) {
                        pStmt.setInt(iPlus, (Integer)object);
                        continue;
                    }
                    if (object instanceof String) {
                        pStmt.setString(iPlus, (String)object);
                        continue;
                    }
                    if (object instanceof Geometry) {
                        pStmt.setString(iPlus, ((Geometry)object).toText());
                        continue;
                    }
                    pStmt.setString(iPlus, object.toString());
                }
                pStmt.executeUpdate();
                if (limit <= 0 || ++count <= limit) continue;
                break;
            }
            featureIterator.close();
        }
    }
}

