/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.smoothing;

import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.jgrasstools.gears.io.shapefile.OmsShapefileFeatureReader;
import org.jgrasstools.gears.io.shapefile.OmsShapefileFeatureWriter;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.libs.monitor.PrintStreamProgressMonitor;
import org.jgrasstools.gears.modules.v.smoothing.FeatureSlidingAverage;
import org.jgrasstools.gears.utils.features.FeatureGeometrySubstitutor;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="The McMasters Sliding Averaging smoothing algorithm.")
@Documentation(value="OmsLineSmootherMcMaster.html")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Smoothing, Vector, OmsLineSmootherJaitools")
@Label(value="Vector Processing")
@Name(value="linesmoother")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsLineSmootherMcMaster
extends JGTModel {
    @Description(value="The vector containing the lines to be smoothed.")
    @In
    public SimpleFeatureCollection inVector;
    @Description(value="The number of points to consider in every smoothing step (default = 7).")
    @In
    public int pLookahead = 7;
    @Description(value="Minimum length for a line to be smoothed.")
    @In
    public int pLimit = 0;
    @Description(value="Slide parameter.")
    @In
    public double pSlide = 0.9;
    @Description(value="Densifier interval.")
    @In
    public Double pDensify = null;
    @Description(value="Simplifier tollerance.")
    @In
    public Double pSimplify = null;
    @Description(value="The vector with smoothed features.")
    @Out
    public SimpleFeatureCollection outVector;
    private static final double SAMEPOINTTHRESHOLD = 0.1;
    private GeometryFactory gF = GeometryUtilities.gf();
    private double densify = -1.0;
    private double simplify = -1.0;
    private List<SimpleFeature> linesList;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outVector == null, this.doReset)) {
            return;
        }
        if (this.pDensify != null) {
            this.densify = this.pDensify;
        }
        if (this.pSimplify != null) {
            this.simplify = this.pSimplify;
        }
        this.outVector = new DefaultFeatureCollection();
        this.pm.message("Collecting geometries...");
        this.linesList = FeatureUtilities.featureCollectionToList(this.inVector);
        int size = this.inVector.size();
        FeatureGeometrySubstitutor fGS = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inVector.getSchema());
        this.pm.beginTask("Smoothing features...", size);
        for (SimpleFeature line : this.linesList) {
            Geometry geometry = (Geometry)line.getDefaultGeometry();
            List<LineString> lsList = this.smoothGeometries(geometry);
            if (lsList.size() != 0) {
                LineString[] lsArray = lsList.toArray(new LineString[lsList.size()]);
                MultiLineString multiLineString = this.gF.createMultiLineString(lsArray);
                SimpleFeature newFeature = fGS.substituteGeometry(line, (Geometry)multiLineString);
                ((DefaultFeatureCollection)this.outVector).add(newFeature);
            }
            this.pm.worked(1);
        }
        this.pm.done();
    }

    private List<LineString> smoothGeometries(Geometry geometry) {
        ArrayList<LineString> lsList = new ArrayList<LineString>();
        int numGeometries = geometry.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geometryN = geometry.getGeometryN(i);
            double length = geometryN.getLength();
            Coordinate[] smoothedArray = geometryN.getCoordinates();
            Coordinate first = smoothedArray[0];
            Coordinate last = smoothedArray[smoothedArray.length - 1];
            if (length <= (double)this.pLimit) {
                if (first.distance(last) < 0.1 || this.isAlone(geometryN)) {
                    continue;
                }
            } else {
                if (this.densify != -1.0) {
                    geometryN = Densifier.densify((Geometry)geometryN, (double)this.pDensify);
                }
                List<Object> smoothedCoords = Collections.emptyList();
                FeatureSlidingAverage fSA = new FeatureSlidingAverage(geometryN);
                smoothedCoords = fSA.smooth(this.pLookahead, false, this.pSlide);
                smoothedArray = smoothedCoords != null ? smoothedCoords.toArray(new Coordinate[smoothedCoords.size()]) : geometryN.getCoordinates();
            }
            LineString lineString = this.gF.createLineString(smoothedArray);
            if (this.simplify != -1.0) {
                TopologyPreservingSimplifier tpSimplifier = new TopologyPreservingSimplifier((Geometry)lineString);
                tpSimplifier.setDistanceTolerance(this.pSimplify.doubleValue());
                lineString = (LineString)tpSimplifier.getResultGeometry();
            }
            lsList.add(lineString);
        }
        return lsList;
    }

    private boolean isAlone(Geometry geometryN) {
        Coordinate[] coordinates = geometryN.getCoordinates();
        if (coordinates.length > 1) {
            Coordinate first = coordinates[0];
            Coordinate last = coordinates[coordinates.length - 1];
            for (SimpleFeature line : this.linesList) {
                Geometry lineGeom = (Geometry)line.getDefaultGeometry();
                int numGeometries = lineGeom.getNumGeometries();
                for (int i = 0; i < numGeometries; ++i) {
                    Geometry subGeom = lineGeom.getGeometryN(i);
                    Coordinate[] lineCoordinates = subGeom.getCoordinates();
                    if (lineCoordinates.length < 2) continue;
                    Coordinate tmpFirst = lineCoordinates[0];
                    Coordinate tmpLast = lineCoordinates[lineCoordinates.length - 1];
                    if (!(tmpFirst.distance(first) < 0.1 || tmpFirst.distance(last) < 0.1 || tmpLast.distance(first) < 0.1) && !(tmpLast.distance(last) < 0.1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void defaultSmoothShapefile(String shapePath, String outPath) throws Exception {
        PrintStreamProgressMonitor pm = new PrintStreamProgressMonitor(System.out, System.err);
        SimpleFeatureCollection initialFC = OmsShapefileFeatureReader.readShapefile(shapePath);
        OmsLineSmootherMcMaster smoother = new OmsLineSmootherMcMaster();
        smoother.pm = pm;
        smoother.pLimit = 10;
        smoother.inVector = initialFC;
        smoother.pLookahead = 13;
        smoother.pDensify = 0.2;
        smoother.pSimplify = 0.01;
        smoother.process();
        SimpleFeatureCollection smoothedFeatures = smoother.outVector;
        OmsShapefileFeatureWriter.writeShapefile(outPath, smoothedFeatures, pm);
    }
}

