/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.rasterreprojector;

import javax.media.jai.Interpolation;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.referencing.CRS;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="Module for raster reprojection.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="http://www.hydrologis.com")
@Keywords(value="Crs, Reprojection, Raster, OmsRasterConverter, OmsRasterReader")
@Label(value="Raster Processing")
@Name(value="rreproject")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterReprojector
extends JGTModel {
    @Description(value="The raster that has to be reprojected.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The north bound of the region to consider")
    @UI(value="process_north")
    @In
    public Double pNorth = null;
    @Description(value="The south bound of the region to consider")
    @UI(value="process_south")
    @In
    public Double pSouth = null;
    @Description(value="The west bound of the region to consider")
    @UI(value="process_west")
    @In
    public Double pWest = null;
    @Description(value="The east bound of the region to consider")
    @UI(value="process_east")
    @In
    public Double pEast = null;
    @Description(value="The rows of the region to consider")
    @UI(value="process_rows")
    @In
    public Integer pRows = null;
    @Description(value="The cols of the region to consider")
    @UI(value="process_cols")
    @In
    public Integer pCols = null;
    @Description(value="The code defining the target coordinate reference system, composed by authority and code number (ex. EPSG:4328).")
    @UI(value="crs")
    @In
    public String pCode;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The reprojected output raster.")
    @Out
    public GridCoverage2D outRaster = null;

    @Execute
    public void process() throws Exception {
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        CoordinateReferenceSystem targetCrs = CRS.decode((String)this.pCode);
        Interpolation interpolation = Interpolation.getInstance((int)0);
        if (this.pInterpolation.equals("bilinear")) {
            interpolation = Interpolation.getInstance((int)1);
        } else if (this.pInterpolation.equals("bicubic")) {
            interpolation = Interpolation.getInstance((int)2);
        }
        GridGeometry2D gridGeometry = null;
        if (this.pNorth != null && this.pSouth != null && this.pWest != null && this.pEast != null && this.pRows != null && this.pCols != null) {
            gridGeometry = CoverageUtilities.gridGeometryFromRegionValues(this.pNorth, this.pSouth, this.pEast, this.pWest, this.pCols, this.pRows, targetCrs);
            this.pm.message("Using supplied gridgeometry: " + gridGeometry);
        }
        this.pm.beginTask("Reprojecting...", -1);
        this.outRaster = gridGeometry == null ? (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.inRaster, targetCrs, null, interpolation) : (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)this.inRaster, targetCrs, gridGeometry, interpolation);
        this.pm.done();
    }
}

