/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.normalizer;

import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.modules.r.summary.OmsRasterSummary;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.math.NumericsUtilities;

@Description(value="Normalizes a raster.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="normalize, raster")
@Label(value="Raster Processing")
@Name(value="rnormalizer")
@Status(value=5)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterNormalizer
extends JGTModel {
    @Description(value="The raster to be normalized.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The value to normalize to (default is 256).")
    @In
    public double pNValue = 256.0;
    @Description(value="If true, then novalues are set to 0.")
    @In
    public boolean doSetnovalues = true;
    @Description(value="The normalized raster")
    @Out
    public GridCoverage2D outRaster = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inRaster);
        double[] minMax = OmsRasterSummary.getMinMax(this.inRaster);
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.inRaster);
        int nCols = regionMap.getCols();
        int nRows = regionMap.getRows();
        RandomIter rasterIter = CoverageUtilities.getRandomIterator(this.inRaster);
        WritableRaster outWR = CoverageUtilities.createDoubleWritableRaster(nCols, nRows, null, null, Double.NaN);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        this.pm.beginTask("Normalizing...", nRows);
        for (int r = 0; r < nRows; ++r) {
            if (this.isCanceled(this.pm)) {
                return;
            }
            for (int c = 0; c < nCols; ++c) {
                double value = rasterIter.getSampleDouble(c, r, 0);
                if (JGTConstants.isNovalue(value)) {
                    if (!this.doSetnovalues) continue;
                    outIter.setSample(c, r, 0, 0.0);
                    continue;
                }
                double normalizedValue = NumericsUtilities.normalize(minMax[1], minMax[0], value, this.pNValue);
                outIter.setSample(c, r, 0, normalizedValue);
            }
            this.pm.worked(1);
        }
        this.pm.done();
        this.outRaster = CoverageUtilities.buildCoverage("normalized", outWR, (HashMap<String, Double>)regionMap, this.inRaster.getCoordinateReferenceSystem());
    }
}

