/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.monitor;

import java.io.PrintStream;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;

public class PrintStreamProgressMonitor
implements IJGTProgressMonitor {
    protected boolean cancelled = false;
    protected final PrintStream outStream;
    protected final PrintStream errStream;
    protected String taskName;
    protected int totalWork;
    protected int runningWork;
    protected int lastPercentage = -1;
    private String prefix = null;

    public PrintStreamProgressMonitor() {
        this(System.out, System.err);
    }

    public PrintStreamProgressMonitor(PrintStream outStream, PrintStream errorStream) {
        this.outStream = outStream;
        this.errStream = errorStream;
    }

    public PrintStreamProgressMonitor(String prefix, PrintStream outStream, PrintStream errorStream) {
        this.prefix = prefix;
        this.outStream = outStream;
        this.errStream = errorStream;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.totalWork = totalWork;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.outStream.print(this.prefix);
        }
        this.outStream.println(this.taskName);
    }

    public void beginTask(String name) {
        this.taskName = name;
        this.totalWork = -1;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.outStream.print(this.prefix);
        }
        this.outStream.println(this.taskName);
    }

    @Override
    public void done() {
        if (this.prefix != null) {
            this.outStream.print(this.prefix);
        }
        this.outStream.println("Finished.");
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public void setCanceled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int work) {
        if (this.totalWork == -1) {
            if (this.prefix != null) {
                this.outStream.print(this.prefix);
            }
            this.outStream.print("...");
        } else {
            this.runningWork += work;
            int percentage = 100 * this.runningWork / this.totalWork;
            if (percentage % 10 == 0 && percentage != this.lastPercentage) {
                if (this.prefix != null) {
                    this.outStream.print(this.prefix);
                }
                this.outStream.print(percentage + "%... ");
                if (this.prefix != null) {
                    this.outStream.println();
                }
                this.lastPercentage = percentage;
            }
        }
    }

    public PrintStream getPrintStream() {
        return this.outStream;
    }

    @Override
    public <T> T adapt(Class<T> adaptee) {
        if (adaptee.isAssignableFrom(PrintStream.class)) {
            return adaptee.cast(this.outStream);
        }
        return null;
    }

    @Override
    public void errorMessage(String message) {
        this.errStream.println(message);
    }

    @Override
    public void message(String message) {
        this.outStream.println(message);
    }

    @Override
    public void exceptionThrown(String message) {
    }

    @Override
    public void onModuleExit() {
    }
}

