/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.libs.monitor;

import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;

public class LogProgressMonitor
implements IJGTProgressMonitor {
    private static final String PERC = "%...";
    protected boolean cancelled = false;
    protected String taskName;
    protected int totalWork;
    protected int runningWork;
    protected int lastPercentage = -1;
    private String prefix = null;

    public LogProgressMonitor() {
        this("");
    }

    public LogProgressMonitor(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.totalWork = totalWork;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.taskName = this.prefix + this.taskName;
        }
        System.out.println(this.taskName);
    }

    public void beginTask(String name) {
        this.taskName = name;
        this.totalWork = -1;
        this.runningWork = 0;
        if (this.prefix != null) {
            this.taskName = this.prefix + this.taskName;
        }
        System.out.println(this.taskName);
    }

    @Override
    public void done() {
        String msg = "Finished.";
        if (this.prefix != null) {
            msg = this.prefix + msg;
        }
        System.out.println(msg);
    }

    @Override
    public void internalWorked(double work) {
    }

    @Override
    public boolean isCanceled() {
        return this.cancelled;
    }

    @Override
    public void setCanceled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public void setTaskName(String name) {
        this.taskName = name;
    }

    @Override
    public void subTask(String name) {
    }

    @Override
    public void worked(int work) {
        if (this.totalWork == -1) {
            String msg = "...";
            if (this.prefix != null) {
                msg = this.prefix + msg;
            }
            System.out.println(msg);
        } else {
            this.runningWork += work;
            int percentage = (int)(100.0 * ((double)this.runningWork / (double)this.totalWork));
            if (percentage != this.lastPercentage && percentage % 10 == 0) {
                String msg = percentage + PERC;
                if (this.prefix != null) {
                    msg = this.prefix + msg;
                }
                System.out.println(msg);
                this.lastPercentage = percentage;
            }
        }
    }

    @Override
    public <T> T adapt(Class<T> adaptee) {
        return null;
    }

    @Override
    public void errorMessage(String message) {
        if (this.prefix != null) {
            System.err.println(this.prefix + message);
        } else {
            System.err.println(message);
        }
    }

    @Override
    public void message(String message) {
        if (this.prefix != null) {
            System.out.println(this.prefix + message);
        } else {
            System.out.println(message);
        }
    }

    @Override
    public void exceptionThrown(String message) {
    }

    @Override
    public void onModuleExit() {
    }
}

