/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.timeseries;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.Finalize;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.io.CSTable;
import oms3.io.DataIO;
import oms3.io.TableIterator;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Utility class for reading data from a OMS formatted csv file. The data is assumed to be first col a date and then al numbers.")
@Documentation(value="OmsTimeSeriesReader.html")
@Author(name="Andrea Antonello and Silvia Franceschi", contact="http://www.hydrologis.com")
@Keywords(value="IO, Reading")
@Label(value="HashMap Data Reader")
@Name(value="tsreader")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsTimeSeriesReader
extends JGTModel {
    @Description(value="The csv file to read from.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The file novalue to be translated into the internal novalue (defaults to -9999.0). Can be also a string.")
    @In
    public String fileNovalue = "-9999.0";
    @Description(value="The internal novalue to use (defaults to NaN).")
    @In
    public double novalue = Double.NaN;
    @Description(value="The sorted hashmap of read data.")
    @Out
    public HashMap<DateTime, double[]> outData;
    private TableIterator<String[]> rowsIterator;
    private CSTable table;
    private DateTimeFormatter formatter = JGTConstants.utcDateFormatterYYYYMMDDHHMM;

    private void ensureOpen() throws IOException {
        if (this.table == null) {
            this.table = DataIO.table((File)new File(this.file), null);
            this.rowsIterator = (TableIterator)this.table.rows().iterator();
            this.outData = new LinkedHashMap<DateTime, double[]>();
        }
    }

    @Execute
    public void read() throws IOException {
        this.ensureOpen();
        while (this.rowsIterator.hasNext()) {
            String[] row = (String[])this.rowsIterator.next();
            double[] record = new double[row.length - 2];
            for (int i = 2; i < row.length; ++i) {
                String valueStr;
                double value = -1.0;
                value = row[i] == null || row[i].length() == 0 ? this.novalue : ((valueStr = row[i]).trim().equals(this.fileNovalue) ? this.novalue : Double.parseDouble(valueStr));
                record[i - 2] = value;
            }
            this.outData.put(this.formatter.parseDateTime(row[1]), record);
        }
    }

    @Finalize
    public void close() throws IOException {
        this.rowsIterator.close();
    }
}

