/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.nmea;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.jgrasstools.gears.io.nmea.NmeaGpsPoint;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.jgrasstools.gears.utils.time.UtcTimeUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description(value="A reader for NMEA gps sentences.")
@Author(name="Andrea Antonello, Silvia Franceschi", contact="www.hydrologis.com")
@Keywords(value="NMEA, gps, vector")
@Label(value="Vector Reader")
@Name(value="nmeafeaturereader")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsNmeaFeatureReader
extends JGTModel {
    public static final String geodata_DESCRIPTION = "The read feature collection.";
    public static final String file_DESCRIPTION = "The NMEA input file.";
    public static final String NAME = "nmeafeaturereader";
    public static final String KEYWORDS = "NMEA, gps, vector";
    public static final String DESCRIPTION = "A reader for NMEA gps sentences.";
    @Description(value="The NMEA input file.")
    @UI(value="infile")
    @In
    public String file = null;
    @Description(value="The read feature collection.")
    @Out
    public SimpleFeatureCollection geodata = null;

    @Execute
    public void readFeatureCollection() throws IOException {
        this.checkNull(this.file);
        this.checkFileExists(this.file);
        List<String> linesList = FileUtilities.readFileToLinesList(new File(this.file));
        Iterator<String> linesIterator = linesList.iterator();
        while (linesIterator.hasNext()) {
            String line = linesIterator.next();
            if (line.startsWith("$GPGGA") || line.startsWith("$GPRMC")) continue;
            linesIterator.remove();
        }
        DefaultFeatureCollection newFC = new DefaultFeatureCollection();
        SimpleFeatureBuilder builder = OmsNmeaFeatureReader.getNmeaFeatureBuilder();
        String gpgga = null;
        String gprmc = null;
        for (String line : linesList) {
            if (line.startsWith("$GPGGA") && gpgga == null) {
                gpgga = line;
            }
            if (line.startsWith("$GPRMC") && gprmc == null) {
                gprmc = line;
            }
            if (gpgga == null || gprmc == null) continue;
            NmeaGpsPoint point = new NmeaGpsPoint(gpgga, gprmc);
            if (point.isValid) {
                Point p = this.gf.createPoint(new Coordinate(point.longitude, point.latitude));
                Object[] attributes = new Object[]{p, point.speed, point.altitude, point.quality, (int)point.sat, point.hdop, point.ellipsoidVsMsl, UtcTimeUtilities.toStringWithSeconds(point.utcDateTime), point.mag_var, point.angle};
                builder.addAll(attributes);
                SimpleFeature nmeaFeature = builder.buildFeature(null);
                newFC.add(nmeaFeature);
            }
            gpgga = null;
            gprmc = null;
        }
        this.geodata = newFC;
    }

    public static SimpleFeatureBuilder getNmeaFeatureBuilder() {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("nmea");
        b.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        b.add("the_geom", Point.class);
        b.add("speed", Double.class);
        b.add("elev", Double.class);
        b.add("quality", Double.class);
        b.add("satnum", Integer.class);
        b.add("hdop", Double.class);
        b.add("dif_ell_msl", Double.class);
        b.add("utctime", String.class);
        b.add("mag_var", Double.class);
        b.add("angle", Double.class);
        SimpleFeatureType featureType = b.buildFeatureType();
        SimpleFeatureBuilder nmeaSimpleFeatureBuilder = new SimpleFeatureBuilder(featureType);
        return nmeaSimpleFeatureBuilder;
    }

    public static SimpleFeatureCollection readNMEAfile(String path) throws IOException {
        OmsNmeaFeatureReader reader = new OmsNmeaFeatureReader();
        reader.file = path;
        reader.readFeatureCollection();
        return reader.geodata;
    }
}

