/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core.v_1_0;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.jgrasstools.gears.io.las.core.ALasWriter;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.utils.ByteUtilities;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.jgrasstools.gears.utils.JGTVersion;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LasWriter
extends ALasWriter {
    private static final String OPEN_METHOD_MSG = "This needs to be called before the open method.";
    private final byte[] doubleDataArray = new byte[8];
    private final ByteBuffer doubleBb = ByteBuffer.wrap(this.doubleDataArray);
    private final byte[] longDataArray = new byte[4];
    private final ByteBuffer longBb = ByteBuffer.wrap(this.longDataArray);
    private final byte[] shortDataArray = new byte[2];
    private final ByteBuffer shortBb = ByteBuffer.wrap(this.shortDataArray);
    private File outFile;
    private CoordinateReferenceSystem crs;
    private FileOutputStream fos;
    private File prjFile;
    private double xScale = 0.01;
    private double yScale = 0.01;
    private double zScale = 0.001;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double zOffset = 0.0;
    private double xMin = 0.0;
    private double yMin = 0.0;
    private double zMin = 0.0;
    private double xMax = 0.0;
    private double yMax = 0.0;
    private double zMax = 0.0;
    private int recordsNum = 0;
    private short recordLength = (short)28;
    private FileChannel fileChannel;
    private int recordsNumPosition;
    private int pointFormatPosition;
    private int pointFormat = 0;
    private boolean doWriteGroundElevation;
    private boolean openCalled;
    private int previousReturnNumber = -999;
    private int previousNumberOfReturns = -999;
    private byte[] previousReturnBytes = null;
    private long offsetToData = 227L;
    private int recordLengthPosition;
    private boolean pointFormatHasBeenSet = false;

    public LasWriter(File outFile, CoordinateReferenceSystem crs) {
        this.outFile = outFile;
        this.crs = crs;
        if (crs != null) {
            String nameWithoutExtention = FileUtilities.getNameWithoutExtention(outFile);
            this.prjFile = new File(outFile.getParent(), nameWithoutExtention + ".prj");
        }
        this.doubleBb.order(ByteOrder.LITTLE_ENDIAN);
        this.longBb.order(ByteOrder.LITTLE_ENDIAN);
        this.shortBb.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void setScales(double xScale, double yScale, double zScale) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this);
        }
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    @Override
    public void setOffset(double xOffset, double yOffset, double zOffset) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this);
        }
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    @Override
    public void setPointFormat(int pointFormat) {
        this.pointFormat = pointFormat;
        this.pointFormatHasBeenSet = true;
    }

    @Override
    public void setBounds(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this);
        }
        this.xMin = xMin;
        this.yMin = yMin;
        this.zMin = zMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.zMax = zMax;
    }

    @Override
    public void setBounds(ILasHeader header) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
        ReferencedEnvelope3D env = header.getDataEnvelope();
        this.xMin = env.getMinX();
        this.yMin = env.getMinY();
        this.zMin = env.getMinZ();
        this.xMax = env.getMaxX();
        this.yMax = env.getMaxY();
        this.zMax = env.getMaxZ();
        double[] xyzOffset = header.getXYZOffset();
        double[] xyzScale = header.getXYZScale();
        this.xOffset = xyzOffset[0];
        this.yOffset = xyzOffset[1];
        this.zOffset = xyzOffset[2];
        this.xScale = xyzScale[0];
        this.yScale = xyzScale[1];
        this.zScale = xyzScale[2];
        this.offsetToData = header.getOffset();
    }

    @Override
    public void open() throws Exception {
        this.openFile();
        this.writeHeader();
        this.openCalled = true;
    }

    private void writeHeader() throws IOException {
        int hLength = 0;
        byte[] signature = "LASF".getBytes();
        this.fos.write(signature);
        hLength += 4;
        byte[] reserved = new byte[4];
        this.fos.write(reserved);
        hLength += 4;
        byte[] guid1 = new byte[4];
        this.fos.write(guid1);
        hLength += 4;
        byte[] guid2 = new byte[2];
        this.fos.write(guid2);
        hLength += 2;
        byte[] guid3 = new byte[2];
        this.fos.write(guid3);
        hLength += 2;
        byte[] guid4 = new byte[8];
        this.fos.write(guid4);
        hLength += 8;
        this.fos.write(1);
        this.fos.write(0);
        hLength += 2;
        byte[] systemIdentifier = new byte[32];
        this.fos.write(systemIdentifier);
        hLength += 32;
        String jgtVersion = "jgrasstools_" + JGTVersion.CURRENT_VERSION.toString();
        if (jgtVersion.length() > 32) {
            jgtVersion = jgtVersion.substring(0, 31);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(jgtVersion);
            for (int i = jgtVersion.length(); i < 32; ++i) {
                sb.append(" ");
            }
            jgtVersion = sb.toString();
        }
        byte[] software = jgtVersion.getBytes();
        this.fos.write(software);
        hLength += 32;
        byte[] flightDateJulian = new byte[2];
        this.fos.write(flightDateJulian);
        hLength += 2;
        byte[] year = new byte[2];
        this.fos.write(year);
        hLength += 2;
        short headersize = 226;
        this.fos.write(this.getShort(headersize));
        hLength += 2;
        this.fos.write(this.getLong((int)this.offsetToData));
        hLength += 4;
        int numVarRecords = 0;
        this.fos.write(this.getLong(numVarRecords));
        hLength += 4;
        this.pointFormatPosition = hLength++;
        this.fos.write(1);
        this.recordLengthPosition = hLength;
        this.fos.write(this.getShort(this.recordLength));
        this.recordsNumPosition = hLength += 2;
        this.fos.write(this.getLong(this.recordsNum));
        hLength += 4;
        this.fos.write(new byte[20]);
        hLength += 20;
        this.fos.write(this.getDouble(this.xScale));
        this.fos.write(this.getDouble(this.yScale));
        this.fos.write(this.getDouble(this.zScale));
        hLength += 24;
        this.fos.write(this.getDouble(this.xOffset));
        this.fos.write(this.getDouble(this.yOffset));
        this.fos.write(this.getDouble(this.zOffset));
        hLength += 24;
        this.fos.write(this.getDouble(this.xMax));
        this.fos.write(this.getDouble(this.xMin));
        this.fos.write(this.getDouble(this.yMax));
        this.fos.write(this.getDouble(this.yMin));
        this.fos.write(this.getDouble(this.zMax));
        this.fos.write(this.getDouble(this.zMin));
        hLength += 48;
        this.fileChannel.position(this.offsetToData);
    }

    @Override
    public synchronized void addPoint(LasRecord record) throws IOException {
        int length = 0;
        int x = (int)Math.round((record.x - this.xOffset) / this.xScale);
        int y = (int)Math.round((record.y - this.yOffset) / this.yScale);
        int z = !this.doWriteGroundElevation ? (int)Math.round((record.z - this.zOffset) / this.zScale) : (int)Math.round((record.groundElevation - this.zOffset) / this.zScale);
        this.fos.write(this.getLong(x));
        this.fos.write(this.getLong(y));
        this.fos.write(this.getLong(z));
        length += 12;
        this.fos.write(this.getShort(record.intensity));
        length += 2;
        short returnNumber = record.returnNumber;
        short numberOfReturns = record.numberOfReturns;
        if (returnNumber != this.previousReturnNumber || numberOfReturns != this.previousNumberOfReturns) {
            BitSet bitsetRN = ByteUtilities.bitsetFromByte((byte)returnNumber);
            BitSet bitsetNOR = ByteUtilities.bitsetFromByte((byte)numberOfReturns);
            BitSet b = new BitSet(7);
            b.set(0, bitsetRN.get(0));
            b.set(1, bitsetRN.get(1));
            b.set(2, bitsetRN.get(2));
            b.set(3, bitsetNOR.get(0));
            b.set(4, bitsetNOR.get(1));
            b.set(5, bitsetNOR.get(2));
            b.set(6, false);
            b.set(7, false);
            byte[] bb = ByteUtilities.bitSetToByteArray(b);
            this.fos.write(bb[0]);
            this.previousReturnBytes = bb;
            this.previousReturnNumber = returnNumber;
            this.previousNumberOfReturns = numberOfReturns;
        } else {
            this.fos.write(this.previousReturnBytes[0]);
        }
        ++length;
        byte c = record.classification;
        this.fos.write(c);
        ++length;
        this.fos.write(1);
        ++length;
        this.fos.write(0);
        ++length;
        this.fos.write(new byte[2]);
        length += 2;
        if (record.gpsTime > 0.0) {
            this.fos.write(this.getDouble(record.gpsTime));
            length += 8;
            if (!this.pointFormatHasBeenSet) {
                this.pointFormat = 1;
            }
        }
        if (this.pointFormat == 3 || this.pointFormat == 2) {
            this.fos.write(this.getShort(record.color[0]));
            this.fos.write(this.getShort(record.color[1]));
            this.fos.write(this.getShort(record.color[2]));
            length += 6;
        }
        this.recordLength = (short)length;
        ++this.recordsNum;
    }

    @Override
    public void close() throws Exception {
        this.fileChannel.position(this.recordsNumPosition);
        this.fos.write(this.getLong(this.recordsNum));
        this.fileChannel.position(this.pointFormatPosition);
        this.fos.write(this.pointFormat);
        this.fileChannel.position(this.recordLengthPosition);
        this.fos.write(this.getShort(this.recordLength));
        this.closeFile();
        if (this.crs != null) {
            CrsUtilities.writeProjectionFile(this.prjFile.getAbsolutePath(), null, this.crs);
        }
    }

    private byte[] getLong(int num) {
        this.longBb.clear();
        this.longBb.putInt(num);
        byte[] array = this.longBb.array();
        return array;
    }

    private byte[] getDouble(double num) {
        this.doubleBb.clear();
        this.doubleBb.putDouble(num);
        byte[] array = this.doubleBb.array();
        return array;
    }

    private byte[] getShort(short num) {
        this.shortBb.clear();
        this.shortBb.putShort(num);
        return this.shortBb.array();
    }

    private void openFile() throws Exception {
        this.fos = new FileOutputStream(this.outFile);
        this.fileChannel = this.fos.getChannel();
    }

    private void closeFile() throws Exception {
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            this.fileChannel.close();
        }
        if (this.fos != null) {
            this.fos.close();
        }
    }

    @Override
    public void setWriteGroundElevation(boolean doWriteGroundElevation) {
        this.doWriteGroundElevation = doWriteGroundElevation;
    }
}

