/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core.v_1_0;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.jgrasstools.gears.io.las.core.ALasReader;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.core.v_1_0.LasHeader;
import org.jgrasstools.gears.utils.ByteUtilities;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LasReader
extends ALasReader {
    private final byte[] doubleDataArray = new byte[8];
    private final ByteBuffer doubleBb = ByteBuffer.wrap(this.doubleDataArray);
    private final byte[] longDataArray = new byte[4];
    private final ByteBuffer longBb = ByteBuffer.wrap(this.longDataArray);
    private final byte[] shortDataArray = new byte[2];
    private final ByteBuffer shortBb = ByteBuffer.wrap(this.shortDataArray);
    private final byte[] singleDataArray = new byte[1];
    private final ByteBuffer singleBb = ByteBuffer.wrap(this.singleDataArray);
    private double xScale;
    private double yScale;
    private double zScale;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private final File lasFile;
    private FileChannel fc;
    private FileInputStream fis;
    private long offset;
    private long records;
    private short recordLength;
    private boolean isOpen;
    private CoordinateReferenceSystem crs;
    private long readRecords = 0L;
    private double xMax;
    private double xMin;
    private double yMax;
    private double yMin;
    private double zMax;
    private double zMin;
    private LasHeader header;

    public LasReader(File lasFile, CoordinateReferenceSystem crs) throws Exception {
        this.lasFile = lasFile;
        if (crs != null) {
            this.crs = crs;
        } else {
            try {
                this.crs = CrsUtilities.readProjectionFile(lasFile.getAbsolutePath(), "las");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.doubleBb.order(ByteOrder.LITTLE_ENDIAN);
        this.longBb.order(ByteOrder.LITTLE_ENDIAN);
        this.shortBb.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public File getLasFile() {
        return this.lasFile;
    }

    private void checkOpen() {
        if (!this.isOpen) {
            try {
                this.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void open() throws Exception {
        this.fis = new FileInputStream(this.lasFile);
        this.fc = this.fis.getChannel();
        this.parseHeader();
        this.isOpen = true;
    }

    @Override
    public void close() throws Exception {
        if (this.fc != null && this.fc.isOpen()) {
            this.fc.close();
        }
        if (this.fis != null) {
            this.fis.close();
        }
        this.isOpen = false;
    }

    @Override
    public void setOverrideGpsTimeType(int type) {
        this.getHeader();
        this.header.gpsTimeType = type;
    }

    private void parseHeader() throws Exception {
        try {
            byte pointDataFormat;
            long variableLengthRecordNum;
            short headerSize;
            short year;
            short dayOfYear;
            String generatingSoftware;
            String systemIdentifier;
            String projectIdGuidData4;
            short projectIdGuidData3;
            short projectIdGuidData2;
            long projectIdGuidData1;
            int gpsTimeType;
            short fileSourceId;
            String signature;
            this.header = new LasHeader(this.crs);
            this.header.signature = signature = this.getString(4);
            this.header.fileSourceId = fileSourceId = this.getShort2Bytes();
            byte globalEnchodingBitFirstHalf = this.get();
            this.skip(1);
            this.header.gpsTimeType = gpsTimeType = this.getGpsTimeType(globalEnchodingBitFirstHalf);
            this.header.projectIdGuidData1 = projectIdGuidData1 = this.getLong4Bytes();
            this.header.projectIdGuidData2 = projectIdGuidData2 = this.getShort2Bytes();
            this.header.projectIdGuidData3 = projectIdGuidData3 = this.getShort2Bytes();
            this.header.projectIdGuidData4 = projectIdGuidData4 = this.getString(8);
            byte versionMajor = this.get();
            byte versionMinor = this.get();
            this.header.versionMajor = versionMajor;
            this.header.versionMinor = versionMinor;
            this.header.systemIdentifier = systemIdentifier = this.getString(32);
            this.header.generatingSoftware = generatingSoftware = this.getString(32);
            this.header.dayOfYear = dayOfYear = this.getShort2Bytes();
            this.header.year = year = this.getShort2Bytes();
            this.header.headerSize = headerSize = this.getShort2Bytes();
            this.header.offset = this.offset = this.getLong4Bytes();
            this.header.variableLengthRecordNum = variableLengthRecordNum = this.getLong4Bytes();
            this.header.pointDataFormat = pointDataFormat = this.get();
            this.header.recordLength = this.recordLength = this.getShort2Bytes();
            this.header.records = this.records = this.getLong4Bytes();
            this.fc.position(this.fc.position() + 20L);
            this.header.xScale = this.xScale = this.getDouble8Bytes();
            this.header.yScale = this.yScale = this.getDouble8Bytes();
            this.header.zScale = this.zScale = this.getDouble8Bytes();
            this.header.xOffset = this.xOffset = this.getDouble8Bytes();
            this.header.yOffset = this.yOffset = this.getDouble8Bytes();
            this.header.zOffset = this.zOffset = this.getDouble8Bytes();
            this.header.xMax = this.xMax = this.getDouble8Bytes();
            this.header.xMin = this.xMin = this.getDouble8Bytes();
            this.header.yMax = this.yMax = this.getDouble8Bytes();
            this.header.yMin = this.yMin = this.getDouble8Bytes();
            this.header.zMax = this.zMax = this.getDouble8Bytes();
            this.header.zMin = this.zMin = this.getDouble8Bytes();
            this.fc.position(this.offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNextPoint() {
        return this.readRecords < this.records;
    }

    @Override
    public LasRecord getNextPoint() throws IOException {
        int read = 0;
        long x = this.getLong4Bytes();
        long y = this.getLong4Bytes();
        long z = this.getLong4Bytes();
        double xd = (double)x * this.xScale + this.xOffset;
        double yd = (double)y * this.yScale + this.yOffset;
        double zd = (double)z * this.zScale + this.zOffset;
        read += 12;
        short intensity = this.getShort2Bytes();
        read += 2;
        byte b = this.get();
        short returnNumber = this.getReturnNumber(b);
        short numberOfReturns = this.getNumberOfReturns(b);
        ++read;
        byte classification = this.get();
        ++read;
        this.skip(4);
        read += 4;
        LasRecord dot = new LasRecord();
        dot.x = xd;
        dot.y = yd;
        dot.z = zd;
        dot.intensity = intensity;
        dot.classification = classification;
        dot.returnNumber = returnNumber;
        dot.numberOfReturns = numberOfReturns;
        if (this.header.pointDataFormat == 1) {
            dot.gpsTime = this.getDouble8Bytes();
            read += 8;
        } else if (this.header.pointDataFormat == 2) {
            dot.color[0] = this.getShort2Bytes();
            dot.color[1] = this.getShort2Bytes();
            dot.color[2] = this.getShort2Bytes();
            read += 6;
        } else if (this.header.pointDataFormat == 3) {
            dot.gpsTime = this.getDouble8Bytes();
            dot.color[0] = this.getShort2Bytes();
            dot.color[1] = this.getShort2Bytes();
            dot.color[2] = this.getShort2Bytes();
            read += 14;
        }
        int skip = this.recordLength - read;
        this.skip(skip);
        ++this.readRecords;
        return dot;
    }

    @Override
    public LasRecord getPointAtAddress(long address) throws IOException {
        this.fc.position(address);
        return this.getPoint();
    }

    @Override
    public LasRecord getPointAt(long pointNumber) throws IOException {
        this.fc.position(this.offset + pointNumber * (long)this.recordLength);
        return this.getPoint();
    }

    private LasRecord getPoint() throws IOException {
        int read = 0;
        long x = this.getLong4Bytes();
        long y = this.getLong4Bytes();
        long z = this.getLong4Bytes();
        double xd = (double)x * this.xScale + this.xOffset;
        double yd = (double)y * this.yScale + this.yOffset;
        double zd = (double)z * this.zScale + this.zOffset;
        read += 12;
        short intensity = this.getShort2Bytes();
        read += 2;
        byte b = this.get();
        short returnNumber = this.getReturnNumber(b);
        short numberOfReturns = this.getNumberOfReturns(b);
        ++read;
        byte classification = this.get();
        ++read;
        this.skip(4);
        read += 4;
        LasRecord dot = new LasRecord();
        dot.x = xd;
        dot.y = yd;
        dot.z = zd;
        dot.intensity = intensity;
        dot.classification = classification;
        dot.returnNumber = returnNumber;
        dot.numberOfReturns = numberOfReturns;
        if (this.header.pointDataFormat == 1) {
            dot.gpsTime = this.getDouble8Bytes();
            read += 8;
        } else if (this.header.pointDataFormat == 2) {
            dot.color[0] = this.getShort2Bytes();
            dot.color[1] = this.getShort2Bytes();
            dot.color[2] = this.getShort2Bytes();
            read += 6;
        } else if (this.header.pointDataFormat == 3) {
            dot.gpsTime = this.getDouble8Bytes();
            dot.color[0] = this.getShort2Bytes();
            dot.color[1] = this.getShort2Bytes();
            dot.color[2] = this.getShort2Bytes();
            read += 14;
        }
        return dot;
    }

    @Override
    public double[] readNextLasXYZAddress() throws IOException {
        long position = this.fc.position();
        int read = 0;
        long x = this.getLong4Bytes();
        long y = this.getLong4Bytes();
        long z = this.getLong4Bytes();
        double xd = (double)x * this.xScale + this.xOffset;
        double yd = (double)y * this.yScale + this.yOffset;
        double zd = (double)z * this.zScale + this.zOffset;
        int skip = this.recordLength - (read += 12);
        this.skip(skip);
        ++this.readRecords;
        return new double[]{xd, yd, zd, position};
    }

    @Override
    public void seek(long pointNumber) throws IOException {
        this.fc.position(this.offset + pointNumber * (long)this.recordLength);
    }

    @Override
    public ILasHeader getHeader() {
        this.checkOpen();
        return this.header;
    }

    private String getString(int size) throws IOException {
        byte[] bytesStr = new byte[size];
        ByteBuffer singleBb = ByteBuffer.wrap(bytesStr);
        this.fc.read(singleBb);
        String signature = new String(bytesStr);
        return signature;
    }

    private long getLong4Bytes() throws IOException {
        this.longBb.clear();
        this.fc.read(this.longBb);
        long arr2long = ByteUtilities.byteArrayToLongLE(this.longDataArray);
        return arr2long;
    }

    private double getDouble8Bytes() throws IOException {
        this.doubleBb.clear();
        this.fc.read(this.doubleBb);
        double arr2Double = this.doubleBb.getDouble(0);
        return arr2Double;
    }

    private short getShort2Bytes() throws IOException {
        this.shortBb.clear();
        this.fc.read(this.shortBb);
        short arr2short = this.shortBb.getShort(0);
        return arr2short;
    }

    private byte get() throws IOException {
        this.singleBb.clear();
        this.fc.read(this.singleBb);
        return this.singleBb.get(0);
    }

    private void skip(int bytesTpSkip) throws IOException {
        this.fc.position(this.fc.position() + (long)bytesTpSkip);
    }

    private short getReturnNumber(byte b) {
        short rn = 0;
        for (int i = 0; i < 3; ++i) {
            if (!this.isSet(b, i)) continue;
            rn = (short)((double)rn + Math.pow(2.0, i));
        }
        return rn;
    }

    private int getGpsTimeType(byte b) {
        return this.isSet(b, 0) ? 1 : 0;
    }

    private short getNumberOfReturns(byte b) {
        short nor = 0;
        for (int i = 3; i < 6; ++i) {
            if (!this.isSet(b, i)) continue;
            nor = (short)((double)nor + Math.pow(2.0, i - 3));
        }
        return nor;
    }

    private boolean isSet(byte b, int n) {
        return (b & 1 << n) != 0;
    }
}

