/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las.core.liblas;

import java.io.File;
import java.io.IOException;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.jgrasstools.gears.io.las.core.ALasWriter;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.core.liblas.LiblasJNALibrary;
import org.jgrasstools.gears.io.las.core.liblas.LiblasWrapper;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.jgrasstools.gears.utils.JGTVersion;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LiblasWriter
extends ALasWriter {
    private static final String OPEN_METHOD_MSG = "This needs to be called before the open method.";
    private File outFile;
    private CoordinateReferenceSystem crs;
    private File prjFile;
    private double xScale = 0.01;
    private double yScale = 0.01;
    private double zScale = 0.001;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double zOffset = 0.0;
    private double xMin = 0.0;
    private double yMin = 0.0;
    private double zMin = 0.0;
    private double xMax = 0.0;
    private double yMax = 0.0;
    private double zMax = 0.0;
    private int recordsNum = 0;
    private short recordLength = (short)28;
    private int offsetToData = 227;
    private boolean doWriteGroundElevation;
    private boolean openCalled;
    private LiblasJNALibrary WRAPPER;
    private long headerHandle;
    private int pointFormat = 0;
    private long fileHandle;
    private boolean pointFormatHasBeenSet = false;

    public LiblasWriter(File outFile, CoordinateReferenceSystem crs) throws Exception {
        this.outFile = outFile;
        this.crs = crs;
        if (crs != null) {
            String nameWithoutExtention = FileUtilities.getNameWithoutExtention(outFile);
            this.prjFile = new File(outFile.getParent(), nameWithoutExtention + ".prj");
        }
        this.WRAPPER = LiblasWrapper.getWrapper();
    }

    @Override
    public void setScales(double xScale, double yScale, double zScale) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    @Override
    public void setOffset(double xOffset, double yOffset, double zOffset) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    @Override
    public void setPointFormat(int pointFormat) {
        this.pointFormat = pointFormat;
        this.pointFormatHasBeenSet = true;
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
    }

    @Override
    public void setBounds(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
        this.xMin = xMin;
        this.yMin = yMin;
        this.zMin = zMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.zMax = zMax;
    }

    @Override
    public void setBounds(ILasHeader header) {
        if (this.openCalled) {
            throw new ModelsIllegalargumentException(OPEN_METHOD_MSG, this.crs);
        }
        ReferencedEnvelope3D env = header.getDataEnvelope();
        this.xMin = env.getMinX();
        this.yMin = env.getMinY();
        this.zMin = env.getMinZ();
        this.xMax = env.getMaxX();
        this.yMax = env.getMaxY();
        this.zMax = env.getMaxZ();
        double[] xyzOffset = header.getXYZOffset();
        double[] xyzScale = header.getXYZScale();
        this.xOffset = xyzOffset[0];
        this.yOffset = xyzOffset[1];
        this.zOffset = xyzOffset[2];
        this.xScale = xyzScale[0];
        this.yScale = xyzScale[1];
        this.zScale = xyzScale[2];
        this.recordLength = header.getRecordLength();
        this.offsetToData = (int)header.getOffset();
    }

    @Override
    public void open() throws Exception {
        this.writeHeader();
        this.fileHandle = this.WRAPPER.LASWriter_Create(this.outFile.getAbsolutePath(), this.headerHandle, (byte)1);
        this.openCalled = true;
    }

    private void writeHeader() throws IOException {
        this.headerHandle = this.WRAPPER.LASHeader_Create();
        String jgtVersion = "jgrasstools_" + JGTVersion.CURRENT_VERSION.toString();
        if (jgtVersion.length() > 32) {
            jgtVersion = jgtVersion.substring(0, 31);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(jgtVersion);
            for (int i = jgtVersion.length(); i < 32; ++i) {
                sb.append(" ");
            }
            jgtVersion = sb.toString();
        }
        this.WRAPPER.LASHeader_SetSoftwareId(this.headerHandle, jgtVersion);
        this.WRAPPER.LASHeader_SetDataOffset(this.headerHandle, this.offsetToData);
        this.WRAPPER.LASHeader_SetOffset(this.headerHandle, this.xOffset, this.yOffset, this.zOffset);
        this.WRAPPER.LASHeader_SetScale(this.headerHandle, this.xScale, this.yScale, this.zScale);
        this.WRAPPER.LASHeader_SetMin(this.headerHandle, this.xMin, this.yMin, this.zMin);
        this.WRAPPER.LASHeader_SetMax(this.headerHandle, this.xMax, this.yMax, this.zMax);
    }

    @Override
    public synchronized void addPoint(LasRecord record) throws IOException {
        long pointHandle = this.WRAPPER.LASPoint_Create(this.fileHandle);
        this.WRAPPER.LASPoint_SetHeader(pointHandle, this.headerHandle);
        this.WRAPPER.LASPoint_SetX(pointHandle, record.x);
        this.WRAPPER.LASPoint_SetY(pointHandle, record.y);
        if (!this.doWriteGroundElevation) {
            this.WRAPPER.LASPoint_SetZ(pointHandle, record.z);
        } else {
            this.WRAPPER.LASPoint_SetZ(pointHandle, record.groundElevation);
        }
        this.WRAPPER.LASPoint_SetIntensity(pointHandle, record.intensity);
        this.WRAPPER.LASPoint_SetNumberOfReturns(pointHandle, record.numberOfReturns);
        this.WRAPPER.LASPoint_SetReturnNumber(pointHandle, record.returnNumber);
        this.WRAPPER.LASPoint_SetClassification(pointHandle, record.classification);
        if (record.gpsTime > 0.0) {
            this.WRAPPER.LASPoint_SetTime(pointHandle, record.gpsTime);
            if (!this.pointFormatHasBeenSet) {
                this.pointFormat = 1;
            }
        }
        if (this.pointFormat == 3 || this.pointFormat == 2) {
            long colorHandle = this.WRAPPER.LASColor_Create();
            this.WRAPPER.LASColor_SetRed(colorHandle, record.color[0]);
            this.WRAPPER.LASColor_SetGreen(colorHandle, record.color[1]);
            this.WRAPPER.LASColor_SetBlue(colorHandle, record.color[2]);
            this.WRAPPER.LASPoint_SetColor(pointHandle, colorHandle);
        }
        this.WRAPPER.LASWriter_WritePoint(this.fileHandle, pointHandle);
        this.WRAPPER.LASPoint_Destroy(pointHandle);
        ++this.recordsNum;
    }

    @Override
    public void close() throws Exception {
        this.WRAPPER.LASHeader_SetPointRecordsCount(this.headerHandle, this.recordsNum);
        this.WRAPPER.LASHeader_SetDataFormatId(this.headerHandle, (byte)this.pointFormat);
        this.WRAPPER.LASWriter_Destroy(this.fileHandle);
        if (this.crs != null) {
            CrsUtilities.writeProjectionFile(this.prjFile.getAbsolutePath(), null, this.crs);
        }
    }

    @Override
    public void setWriteGroundElevation(boolean doWriteGroundElevation) {
        this.doWriteGroundElevation = doWriteGroundElevation;
    }
}

