/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.las;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.index.strtree.AbstractSTRtree;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.util.WeakValueHashMap;
import org.jgrasstools.gears.io.las.ALasDataManager;
import org.jgrasstools.gears.io.las.core.ALasReader;
import org.jgrasstools.gears.io.las.core.ILasHeader;
import org.jgrasstools.gears.io.las.core.LasRecord;
import org.jgrasstools.gears.io.las.index.LasIndexer;
import org.jgrasstools.gears.io.las.index.OmsLasIndexReader;
import org.jgrasstools.gears.io.las.index.strtree.STRtreeJGT;
import org.jgrasstools.gears.libs.modules.JGTConstants;
import org.jgrasstools.gears.utils.CrsUtilities;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.files.FileUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class LasFolderIndexDataManager
extends ALasDataManager
implements AutoCloseable {
    private WeakValueHashMap<String, Pair> fileName2LasReaderMap;
    private WeakValueHashMap<String, STRtreeJGT> fileName2IndexMap;
    private List<String> fileName4LasReaderMapSupport;
    private File lasFolderIndexFile;
    private File lasFolder;
    private STRtreeJGT mainLasFolderIndex;
    private GridCoverage2D inDem;
    private double elevThreshold;
    private SimpleFeatureCollection overviewFeatures;
    private ReferencedEnvelope referencedEnvelope2D;
    private List<ReferencedEnvelope> referencedEnvelope2DList = new ArrayList<ReferencedEnvelope>();
    private List<String> fileNamesList = new ArrayList<String>();
    private ReferencedEnvelope3D referencedEnvelope3D;

    LasFolderIndexDataManager(File lasFolderIndexFile, GridCoverage2D inDem, double elevThreshold, CoordinateReferenceSystem inCrs) {
        this.lasFolderIndexFile = lasFolderIndexFile;
        this.inDem = inDem;
        this.elevThreshold = elevThreshold;
        this.lasFolder = lasFolderIndexFile.getParentFile();
        try {
            inCrs = CrsUtilities.readProjectionFile(lasFolderIndexFile.getAbsolutePath(), "lasfolder");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inCrs != null) {
            this.crs = inCrs;
        } else if (inDem != null) {
            this.crs = inDem.getCoordinateReferenceSystem();
        } else {
            throw new IllegalArgumentException("The Crs can't be null.");
        }
        this.fileName2LasReaderMap = new WeakValueHashMap();
        this.fileName2IndexMap = new WeakValueHashMap();
        this.fileName4LasReaderMapSupport = new ArrayList<String>();
    }

    @Override
    public File getFile() {
        return this.lasFolderIndexFile;
    }

    @Override
    public void open() throws Exception {
        this.mainLasFolderIndex = OmsLasIndexReader.readIndex(this.lasFolderIndexFile.getAbsolutePath());
    }

    @Override
    public synchronized List<LasRecord> getPointsInGeometry(Geometry checkGeom, boolean doOnlyEnvelope) throws Exception {
        this.checkOpen();
        ArrayList<LasRecord> pointsListForTile = new ArrayList<LasRecord>();
        Envelope env = checkGeom.getEnvelopeInternal();
        PreparedGeometry preparedGeometry = null;
        if (!doOnlyEnvelope) {
            preparedGeometry = PreparedGeometryFactory.prepare((Geometry)checkGeom);
        }
        List filesList = this.mainLasFolderIndex.query(env);
        for (Object fileName : filesList) {
            if (!(fileName instanceof String)) continue;
            String name = (String)fileName;
            Pair pair = (Pair)this.fileName2LasReaderMap.get((Object)name);
            if (pair == null) {
                File lasFile = new File(this.lasFolder, name);
                File lasIndexFile = FileUtilities.substituteExtention(lasFile, "lasfix");
                if (!lasIndexFile.exists()) continue;
                pair = this.getIndexPair(lasFile);
                if (pair != null) {
                    this.fileName2LasReaderMap.put((Object)name, (Object)pair);
                    this.fileName4LasReaderMapSupport.add(name);
                }
            }
            List addressesList = pair.strTree.query(env);
            for (Object obj : addressesList) {
                if (!(obj instanceof double[])) continue;
                double[] addresses = (double[])obj;
                long from = (long)addresses[0];
                long to = (long)addresses[1];
                for (long pointNum = from; pointNum < to; ++pointNum) {
                    Coordinate c;
                    LasRecord lasDot = pair.reader.getPointAt(pointNum);
                    if (!this.doAccept(lasDot)) continue;
                    if (this.inDem != null) {
                        double height;
                        double value;
                        c = new Coordinate(lasDot.x, lasDot.y);
                        if (!env.contains(c) || !doOnlyEnvelope && !preparedGeometry.contains((Geometry)this.gf.createPoint(c)) || JGTConstants.isNovalue(value = CoverageUtilities.getValue(this.inDem, lasDot.x, lasDot.y)) || !((height = lasDot.z - value) > this.elevThreshold)) continue;
                        lasDot.groundElevation = height;
                        pointsListForTile.add(lasDot);
                        continue;
                    }
                    c = new Coordinate(lasDot.x, lasDot.y);
                    if (!env.contains(c) || !doOnlyEnvelope && !preparedGeometry.contains((Geometry)this.gf.createPoint(c))) continue;
                    pointsListForTile.add(lasDot);
                }
            }
        }
        return pointsListForTile;
    }

    @Override
    public synchronized List<Geometry> getEnvelopesInGeometry(Geometry checkGeom, boolean doOnlyEnvelope, double[] minMaxZ) throws Exception {
        this.checkOpen();
        ArrayList<Geometry> envelopeListForTile = new ArrayList<Geometry>();
        Envelope env = checkGeom.getEnvelopeInternal();
        PreparedGeometry preparedGeometry = null;
        if (!doOnlyEnvelope) {
            preparedGeometry = PreparedGeometryFactory.prepare((Geometry)checkGeom);
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        List filesList = this.mainLasFolderIndex.query(env);
        for (Object fileName : filesList) {
            if (!(fileName instanceof String)) continue;
            String name = (String)fileName;
            File lasFile = new File(this.lasFolder, name);
            File lasIndexFile = FileUtilities.substituteExtention(lasFile, "lasfix");
            String absolutePath = lasIndexFile.getAbsolutePath();
            STRtreeJGT lasIndex = (STRtreeJGT)this.fileName2IndexMap.get((Object)absolutePath);
            if (lasIndex == null) {
                lasIndex = OmsLasIndexReader.readIndex(absolutePath);
                this.fileName2IndexMap.put((Object)absolutePath, (Object)lasIndex);
            }
            List queryBoundables = lasIndex.queryBoundables(env);
            for (Object object : queryBoundables) {
                ItemBoundable itemBoundable;
                double[] item;
                if (!(object instanceof ItemBoundable) || (item = (double[])(itemBoundable = (ItemBoundable)object).getItem()).length <= 0) continue;
                Envelope bounds = (Envelope)itemBoundable.getBounds();
                Polygon envelopePolygon = LasIndexer.envelopeToPolygon(bounds);
                envelopePolygon.setUserData((Object)new double[]{item[2], item[3]});
                if (minMaxZ != null) {
                    min = Math.min(min, item[2]);
                    max = Math.max(max, item[2]);
                }
                if (doOnlyEnvelope) {
                    envelopeListForTile.add((Geometry)envelopePolygon);
                    continue;
                }
                if (!preparedGeometry.intersects((Geometry)envelopePolygon)) continue;
                envelopeListForTile.add((Geometry)envelopePolygon);
            }
        }
        if (minMaxZ != null) {
            minMaxZ[0] = min;
            minMaxZ[1] = max;
        }
        return envelopeListForTile;
    }

    @Override
    public synchronized ReferencedEnvelope getOverallEnvelope() throws Exception {
        if (this.referencedEnvelope2D == null) {
            this.checkOpen();
            Class<AbstractSTRtree> class1 = AbstractSTRtree.class;
            Field f1 = class1.getDeclaredField("itemBoundables");
            f1.setAccessible(true);
            ArrayList boundablesList = (ArrayList)f1.get(this.mainLasFolderIndex);
            Envelope env = null;
            for (Object item : boundablesList) {
                if (!(item instanceof ItemBoundable)) continue;
                ItemBoundable boundable = (ItemBoundable)item;
                Envelope envelope = (Envelope)boundable.getBounds();
                ReferencedEnvelope tmp = new ReferencedEnvelope(envelope, this.crs);
                this.referencedEnvelope2DList.add(tmp);
                String name = (String)boundable.getItem();
                this.fileNamesList.add(name);
                if (env == null) {
                    env = envelope;
                    continue;
                }
                env.expandToInclude(envelope.getMinX(), envelope.getMinY());
                env.expandToInclude(envelope.getMaxX(), envelope.getMaxY());
            }
            this.referencedEnvelope2D = new ReferencedEnvelope(env, this.crs);
        }
        return this.referencedEnvelope2D;
    }

    @Override
    public List<ReferencedEnvelope> getEnvelopeList() throws Exception {
        this.getOverallEnvelope();
        return this.referencedEnvelope2DList;
    }

    @Override
    public synchronized ReferencedEnvelope3D getEnvelope3D() throws Exception {
        if (this.referencedEnvelope3D == null) {
            this.checkReadersMap();
            for (String key : this.fileName4LasReaderMapSupport) {
                File lasFile;
                Pair pair = (Pair)this.fileName2LasReaderMap.get((Object)key);
                if (pair == null && (pair = this.getIndexPair(lasFile = new File(this.lasFolder, key))) == null) {
                    System.err.println("Null reader pair: " + lasFile);
                    continue;
                }
                ILasHeader header = pair.reader.getHeader();
                ReferencedEnvelope3D envelope = header.getDataEnvelope();
                if (this.referencedEnvelope3D == null) {
                    this.referencedEnvelope3D = envelope;
                    continue;
                }
                this.referencedEnvelope3D.expandToInclude(envelope.getMinX(), envelope.getMinY(), envelope.getMinZ());
                this.referencedEnvelope3D.expandToInclude(envelope.getMaxX(), envelope.getMaxY(), envelope.getMaxZ());
            }
        }
        return this.referencedEnvelope3D;
    }

    @Override
    public synchronized SimpleFeatureCollection getOverviewFeatures() throws Exception {
        if (this.overviewFeatures == null) {
            List<ReferencedEnvelope> envelopeList = this.getEnvelopeList();
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName("overview");
            b.setCRS(this.crs);
            b.add("the_geom", Polygon.class);
            b.add("name", String.class);
            SimpleFeatureType type = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            this.overviewFeatures = new DefaultFeatureCollection();
            for (int i = 0; i < envelopeList.size(); ++i) {
                String name = this.fileNamesList.get(i);
                ReferencedEnvelope envelope = envelopeList.get(i);
                Polygon polygon = OmsLasIndexReader.envelopeToPolygon((Envelope)envelope);
                Object[] objs = new Object[]{polygon, name};
                builder.addAll(objs);
                SimpleFeature feature = builder.buildFeature(null);
                ((DefaultFeatureCollection)this.overviewFeatures).add(feature);
            }
        }
        return this.overviewFeatures;
    }

    private void checkReadersMap() throws Exception {
        this.checkOpen();
        if (this.fileName2LasReaderMap.size() == 0) {
            List filesList = this.mainLasFolderIndex.itemsTree();
            for (Object fileName : filesList) {
                if (fileName instanceof String) {
                    String name = (String)fileName;
                    this.getReader(name);
                    continue;
                }
                if (fileName instanceof List) {
                    List filesList2 = (List)fileName;
                    for (Object fileName2 : filesList2) {
                        if (!(fileName2 instanceof String)) continue;
                        String name2 = (String)fileName2;
                        this.getReader(name2);
                    }
                    continue;
                }
                throw new RuntimeException();
            }
        }
    }

    private void getReader(String name) throws Exception {
        File lasFile;
        Pair pair = (Pair)this.fileName2LasReaderMap.get((Object)name);
        if (pair == null && (pair = this.getIndexPair(lasFile = new File(this.lasFolder, name))) != null) {
            this.fileName2LasReaderMap.put((Object)name, (Object)pair);
            this.fileName4LasReaderMapSupport.add(name);
        }
    }

    private Pair getIndexPair(File lasFile) throws Exception {
        File lasIndexFile = FileUtilities.substituteExtention(lasFile, "lasfix");
        if (lasIndexFile.exists()) {
            ALasReader reader = ALasReader.getReader(lasFile, this.crs);
            reader.open();
            reader.getHeader();
            STRtreeJGT lasIndex = OmsLasIndexReader.readIndex(lasIndexFile.getAbsolutePath());
            Pair pair = new Pair();
            pair.reader = reader;
            pair.strTree = lasIndex;
            return pair;
        }
        System.err.println("Doesn't exist: " + lasIndexFile);
        return null;
    }

    private void checkOpen() throws Exception {
        if (this.mainLasFolderIndex == null) {
            this.open();
        }
    }

    @Override
    public void close() throws Exception {
        for (String key : this.fileName4LasReaderMapSupport) {
            Pair pair = (Pair)this.fileName2LasReaderMap.get((Object)key);
            if (pair == null) continue;
            pair.close();
        }
        this.fileName4LasReaderMapSupport.clear();
        this.fileName2LasReaderMap.clear();
        this.fileName2LasReaderMap = null;
    }

    private class Pair {
        ALasReader reader;
        STRtreeJGT strTree;

        private Pair() {
        }

        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.reader = null;
            this.strTree = null;
        }
    }
}

