/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.jgrasstools.gears.io.dxfdwg.libs.dxf.DxfGroup;
import org.jgrasstools.gears.utils.features.FeatureMate;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryType;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;

public class DxfUtils {
    public static final String SUFFIX = "_";
    public static final String ZERO = "0.0";
    public static final String SEQEND = "SEQEND";
    public static final String VERTEX = "VERTEX";
    public static final String LINE = "LINE";
    public static final String POLYLINE = "POLYLINE";
    public static final String POINT = "POINT";
    public static final String LAYER = "LAYER";
    public static final String TEXT_STYLE = "TEXT_STYLE";
    public static final String BYLAYER = "BYLAYER";
    public static final String LTYPE = "LTYPE";
    public static final String ELEVATION = "ELEVATION";
    public static final String THICKNESS = "THICKNESS";
    public static final String COLOR = "COLOR";
    public static final String TEXT_HEIGHT = "TEXT_HEIGHT";
    public static final String TEXT = "TEXT";
    public static int precision = 3;

    public static String feature2Dxf(FeatureMate featureMate, String layerName, String elevationAttrName, boolean suffix, boolean force2CoordsToLine) {
        Geometry g = featureMate.getGeometry();
        GeometryType geometryType = GeometryUtilities.getGeometryType(g);
        if (geometryType == GeometryType.POINT || geometryType == GeometryType.MULTIPOINT) {
            return DxfUtils.point2Dxf(featureMate, layerName, elevationAttrName);
        }
        if (geometryType == GeometryType.LINE || geometryType == GeometryType.MULTILINE) {
            return DxfUtils.lineString2Dxf(featureMate, layerName, elevationAttrName, force2CoordsToLine);
        }
        if (geometryType == GeometryType.POLYGON || geometryType == GeometryType.MULTIPOLYGON) {
            return DxfUtils.polygon2Dxf(featureMate, layerName, elevationAttrName, suffix);
        }
        if (g instanceof GeometryCollection) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                SimpleFeature ff = SimpleFeatureBuilder.copy((SimpleFeature)featureMate.getFeature());
                ff.setDefaultGeometry((Object)g.getGeometryN(i));
                FeatureMate fm = new FeatureMate(ff);
                sb.append(DxfUtils.feature2Dxf(fm, layerName, elevationAttrName, suffix, force2CoordsToLine));
            }
            return sb.toString();
        }
        return null;
    }

    private static String point2Dxf(FeatureMate featureMate, String layerName, String elevationAttrName) {
        Double elev;
        StringBuffer sb = null;
        SimpleFeature feature = featureMate.getFeature();
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, TEXT);
        boolean hasText = attribute != null && !attribute.equals("");
        sb = hasText ? new StringBuffer(DxfGroup.toString(0, TEXT)) : new StringBuffer(DxfGroup.toString(0, POINT));
        DxfUtils.handleLAYER(feature, layerName, sb);
        DxfUtils.handleLTYPE(feature, sb);
        DxfUtils.handleELEVATION(feature, sb);
        DxfUtils.handleTHICKNESS(feature, sb);
        DxfUtils.handleColor(feature, sb);
        Coordinate coord = ((Point)featureMate.getGeometry()).getCoordinate();
        if (elevationAttrName != null && (elev = featureMate.getAttribute(elevationAttrName, Double.class)) != null) {
            coord.z = elev;
        }
        sb.append(DxfGroup.toString(10, coord.x, precision));
        sb.append(DxfGroup.toString(20, coord.y, precision));
        if (!Double.isNaN(coord.z)) {
            sb.append(DxfGroup.toString(30, coord.z, precision));
        }
        DxfUtils.handleTEXTHEIGHT(feature, sb, hasText);
        return sb.toString();
    }

    private static String lineString2Dxf(FeatureMate featureMate, String layerName, String elevationAttrName, boolean force2CoordsToLine) {
        Double tmp;
        Geometry geom = featureMate.getGeometry();
        Coordinate[] coords = geom.getCoordinates();
        boolean is2CoordsLine = coords.length == 2;
        boolean doLine = is2CoordsLine && force2CoordsToLine;
        StringBuffer sb = doLine ? new StringBuffer(DxfGroup.toString(0, LINE)) : new StringBuffer(DxfGroup.toString(0, POLYLINE));
        double elev = Double.NaN;
        if (elevationAttrName != null && (tmp = featureMate.getAttribute(elevationAttrName, Double.class)) != null) {
            elev = tmp;
        }
        SimpleFeature feature = featureMate.getFeature();
        DxfUtils.handleLAYER(feature, layerName, sb);
        DxfUtils.handleLTYPE(feature, sb);
        DxfUtils.handleELEVATION(feature, sb);
        DxfUtils.handleTHICKNESS(feature, sb);
        DxfUtils.handleColor(feature, sb);
        if (doLine) {
            sb.append(DxfGroup.toString(10, coords[0].x, precision));
            sb.append(DxfGroup.toString(20, coords[0].y, precision));
            coords[0].z = elev;
            if (!Double.isNaN(coords[0].z)) {
                sb.append(DxfGroup.toString(30, ZERO));
            }
            sb.append(DxfGroup.toString(11, coords[1].x, precision));
            sb.append(DxfGroup.toString(21, coords[1].y, precision));
            coords[1].z = elev;
            if (!Double.isNaN(coords[1].z)) {
                sb.append(DxfGroup.toString(31, ZERO));
            }
        } else {
            sb.append(DxfGroup.toString(66, 1));
            sb.append(DxfGroup.toString(10, ZERO));
            sb.append(DxfGroup.toString(20, ZERO));
            coords[0].z = elev;
            if (!Double.isNaN(coords[0].z)) {
                sb.append(DxfGroup.toString(30, ZERO));
            }
            sb.append(DxfGroup.toString(70, 8));
            for (int i = 0; i < coords.length; ++i) {
                sb.append(DxfGroup.toString(0, VERTEX));
                DxfUtils.handleLAYER(feature, layerName, sb);
                sb.append(DxfGroup.toString(10, coords[i].x, precision));
                sb.append(DxfGroup.toString(20, coords[i].y, precision));
                coords[i].z = elev;
                if (!Double.isNaN(coords[i].z)) {
                    sb.append(DxfGroup.toString(30, coords[i].z, precision));
                }
                sb.append(DxfGroup.toString(70, 32));
            }
            sb.append(DxfGroup.toString(0, SEQEND));
        }
        return sb.toString();
    }

    private static String polygon2Dxf(FeatureMate featureMate, String layerName, String elevationAttrName, boolean suffix) {
        Geometry geometry = featureMate.getGeometry();
        int numGeometries = geometry.getNumGeometries();
        StringBuffer sb = new StringBuffer();
        for (int g = 0; g < numGeometries; ++g) {
            Double tmp;
            Polygon geom = (Polygon)geometry.getGeometryN(g);
            Coordinate[] coords = geom.getExteriorRing().getCoordinates();
            sb.append(DxfGroup.toString(0, POLYLINE));
            sb.append(DxfGroup.toString(8, layerName));
            SimpleFeature feature = featureMate.getFeature();
            DxfUtils.handleLTYPE(feature, sb);
            DxfUtils.handleELEVATION(feature, sb);
            DxfUtils.handleTHICKNESS(feature, sb);
            DxfUtils.handleColor(feature, sb);
            double elev = Double.NaN;
            if (elevationAttrName != null && (tmp = featureMate.getAttribute(elevationAttrName, Double.class)) != null) {
                elev = tmp;
            }
            sb.append(DxfGroup.toString(66, 1));
            sb.append(DxfGroup.toString(10, ZERO));
            sb.append(DxfGroup.toString(20, ZERO));
            coords[0].z = elev;
            if (!Double.isNaN(coords[0].z)) {
                sb.append(DxfGroup.toString(30, ZERO));
            }
            sb.append(DxfGroup.toString(70, 9));
            for (int i = 0; i < coords.length; ++i) {
                sb.append(DxfGroup.toString(0, VERTEX));
                sb.append(DxfGroup.toString(8, layerName));
                sb.append(DxfGroup.toString(10, coords[i].x, precision));
                sb.append(DxfGroup.toString(20, coords[i].y, precision));
                coords[i].z = elev;
                if (!Double.isNaN(coords[i].z)) {
                    sb.append(DxfGroup.toString(30, coords[i].z, precision));
                }
                sb.append(DxfGroup.toString(70, 32));
            }
            sb.append(DxfGroup.toString(0, SEQEND));
            for (int h = 0; h < geom.getNumInteriorRing(); ++h) {
                sb.append(DxfGroup.toString(0, POLYLINE));
                if (suffix) {
                    sb.append(DxfGroup.toString(8, layerName + SUFFIX));
                } else {
                    sb.append(DxfGroup.toString(8, layerName));
                }
                DxfUtils.handleLTYPE(feature, sb);
                DxfUtils.handleTHICKNESS(feature, sb);
                DxfUtils.handleColor(feature, sb);
                sb.append(DxfGroup.toString(66, 1));
                sb.append(DxfGroup.toString(10, ZERO));
                sb.append(DxfGroup.toString(20, ZERO));
                coords[0].z = elev;
                if (!Double.isNaN(coords[0].z)) {
                    sb.append(DxfGroup.toString(30, ZERO));
                }
                sb.append(DxfGroup.toString(70, 9));
                coords = geom.getInteriorRingN(h).getCoordinates();
                for (int i = 0; i < coords.length; ++i) {
                    sb.append(DxfGroup.toString(0, VERTEX));
                    if (suffix) {
                        sb.append(DxfGroup.toString(8, layerName + SUFFIX));
                    } else {
                        sb.append(DxfGroup.toString(8, layerName));
                    }
                    sb.append(DxfGroup.toString(10, coords[i].x, precision));
                    sb.append(DxfGroup.toString(20, coords[i].y, precision));
                    coords[i].z = elev;
                    if (!Double.isNaN(coords[i].z)) {
                        sb.append(DxfGroup.toString(30, coords[i].z, precision));
                    }
                    sb.append(DxfGroup.toString(70, 32));
                }
                sb.append(DxfGroup.toString(0, SEQEND));
            }
        }
        return sb.toString();
    }

    private static void handleLAYER(SimpleFeature feature, String layerName, StringBuffer sb) {
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, LAYER);
        if (attribute != null && !attribute.equals("")) {
            sb.append(DxfGroup.toString(8, feature.getAttribute(LAYER)));
        } else {
            sb.append(DxfGroup.toString(8, layerName));
        }
    }

    private static void handleTEXTHEIGHT(SimpleFeature feature, StringBuffer sb, boolean hasText) {
        boolean hasTextHeight;
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, TEXT_HEIGHT);
        boolean bl = hasTextHeight = attribute != null && !attribute.equals(new Float(0.0f));
        if (hasTextHeight) {
            sb.append(DxfGroup.toString(40, feature.getAttribute(TEXT_HEIGHT)));
        }
        if (hasText && hasTextHeight) {
            sb.append(DxfGroup.toString(1, feature.getAttribute(TEXT)));
            sb.append(DxfGroup.toString(7, feature.getAttribute(TEXT_STYLE)));
        }
    }

    private static void handleColor(SimpleFeature feature, StringBuffer sb) {
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, COLOR);
        if (attribute != null && (Integer)attribute != 256) {
            sb.append(DxfGroup.toString(62, feature.getAttribute(COLOR).toString()));
        }
    }

    private static void handleTHICKNESS(SimpleFeature feature, StringBuffer sb) {
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, THICKNESS);
        if (attribute != null && !attribute.equals(new Float(0.0f))) {
            sb.append(DxfGroup.toString(39, feature.getAttribute(THICKNESS)));
        } else {
            sb.append(DxfGroup.toString(39, 100));
        }
    }

    private static void handleELEVATION(SimpleFeature feature, StringBuffer sb) {
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, ELEVATION);
        if (attribute != null && !attribute.equals(new Float(0.0f))) {
            sb.append(DxfGroup.toString(38, feature.getAttribute(ELEVATION)));
        }
    }

    private static void handleLTYPE(SimpleFeature feature, StringBuffer sb) {
        Object attribute = FeatureUtilities.getAttributeCaseChecked(feature, LTYPE);
        if (attribute != null && !attribute.equals(BYLAYER)) {
            sb.append(DxfGroup.toString(6, feature.getAttribute(LTYPE)));
        }
    }
}

