/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.adige;

import java.util.Arrays;

public class VegetationLibraryRecord {
    private final int id;
    private final double architecturalResistance;
    private final double minStomatalResistanc;
    private final double[] laiMonths;
    private final double[] albedoMonths;
    private final double[] roughMonths;
    private final double[] displMonths;
    private final double windHeight;
    private final double windAtten;
    private final double rgl;
    private final double radAtten;
    private final double trunkRatio;

    public VegetationLibraryRecord(int id, double architecturalResistance, double minStomatalResistanc, double[] laiMonths, double[] albedoMonths, double[] roughMonths, double[] displMonths, double windHeight, double windAtten, double rgl, double radAtten, double trunkRatio) {
        this.id = id;
        this.architecturalResistance = architecturalResistance;
        this.minStomatalResistanc = minStomatalResistanc;
        this.laiMonths = laiMonths;
        this.albedoMonths = albedoMonths;
        this.roughMonths = roughMonths;
        this.displMonths = displMonths;
        this.windHeight = windHeight;
        this.windAtten = windAtten;
        this.rgl = rgl;
        this.radAtten = radAtten;
        this.trunkRatio = trunkRatio;
    }

    public int getId() {
        return this.id;
    }

    public double getArchitecturalResistance() {
        return this.architecturalResistance;
    }

    public double getMinStomatalResistance() {
        return this.minStomatalResistanc;
    }

    public double getLai(int month) {
        return this.laiMonths[month - 1];
    }

    public double getAlbedo(int month) {
        return this.albedoMonths[month - 1];
    }

    public double getRoughness(int month) {
        return this.roughMonths[month - 1];
    }

    public double getDisplacement(int month) {
        return this.displMonths[month - 1];
    }

    public double getWindHeight() {
        return this.windHeight;
    }

    public double getWindAtten() {
        return this.windAtten;
    }

    public double getRgl() {
        return this.rgl;
    }

    public double getRadAtten() {
        return this.radAtten;
    }

    public double getTrunkRatio() {
        return this.trunkRatio;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VegetationLibraryRecord [\n\talbedoMonths=");
        builder.append(Arrays.toString(this.albedoMonths));
        builder.append(", \n\tarchitecturalResistance=");
        builder.append(this.architecturalResistance);
        builder.append(", \n\tdisplMonths=");
        builder.append(Arrays.toString(this.displMonths));
        builder.append(", \n\tid=");
        builder.append(this.id);
        builder.append(", \n\tlaiMonths=");
        builder.append(Arrays.toString(this.laiMonths));
        builder.append(", \n\tminStomatalResistanc=");
        builder.append(this.minStomatalResistanc);
        builder.append(", \n\tradAtten=");
        builder.append(this.radAtten);
        builder.append(", \n\trgl=");
        builder.append(this.rgl);
        builder.append(", \n\troughMonths=");
        builder.append(Arrays.toString(this.roughMonths));
        builder.append(", \n\ttrunkRatio=");
        builder.append(this.trunkRatio);
        builder.append(", \n\twindAtten=");
        builder.append(this.windAtten);
        builder.append(", \n\twindHeight=");
        builder.append(this.windHeight);
        builder.append("\n]");
        return builder.toString();
    }
}

