/*
 * Decompiled with CFR 0.152.
 */
package gw.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gw.util.ProjectionUtils;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoToolsUtils {
    public static double[] getMinMaxHeight(SimpleFeature[] features, Globe globe, CoordinateReferenceSystem crs) {
        double[] minmax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (SimpleFeature feature : features) {
            Coordinate[] coords;
            Geometry geo = (Geometry)feature.getDefaultGeometry();
            for (Coordinate c : coords = geo.getCoordinates()) {
                double[] dArray = new double[]{c.x, c.y};
                LatLon ll = ProjectionUtils.toLatLon(dArray, crs);
                double elevation = globe.getElevation(ll.getLatitude(), ll.getLongitude());
                if (elevation < minmax[0]) {
                    minmax[0] = elevation;
                }
                if (!(elevation > minmax[1])) continue;
                minmax[1] = elevation;
            }
        }
        return minmax;
    }

    public static Position getFeatureCenter(SimpleFeature feature, CoordinateReferenceSystem crs) {
        Position rval = null;
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        Coordinate[] coords = geometry.getCoordinates();
        Position[] vertices = new Position[coords.length];
        LatLon center = LatLon.ZERO;
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < coords.length; ++i) {
            cx += coords[i].x;
            cy += coords[i].y;
        }
        cx /= (double)coords.length;
        cy /= (double)coords.length;
        try {
            rval = new Position(ProjectionUtils.toLatLon(new double[]{cx, cy}, crs), 10.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rval;
    }

    public static ReferencedEnvelope[] subdivideEnvelope(ReferencedEnvelope e) {
        double cx = e.getCenter(0);
        double cy = e.getCenter(1);
        ReferencedEnvelope topLeft = new ReferencedEnvelope(e.getMinX(), cx, cy, e.getMaxY(), e.getCoordinateReferenceSystem());
        ReferencedEnvelope topRight = new ReferencedEnvelope(cx, e.getMaxX(), cy, e.getMaxY(), e.getCoordinateReferenceSystem());
        ReferencedEnvelope bottomLeft = new ReferencedEnvelope(e.getMinX(), cx, e.getMinY(), cy, e.getCoordinateReferenceSystem());
        ReferencedEnvelope bottomRight = new ReferencedEnvelope(cx, e.getMaxX(), e.getMinY(), cy, e.getCoordinateReferenceSystem());
        return new ReferencedEnvelope[]{topLeft, topRight, bottomLeft, bottomRight};
    }

    public static SimpleFeature getFeatureAt(LatLon latlon, FeatureSource featureSource, CoordinateReferenceSystem originalCRS) {
        try {
            Intersects filter;
            FeatureCollection fc;
            FeatureIterator i;
            if (latlon == null) {
                return null;
            }
            double[] pcoord = null;
            try {
                pcoord = ProjectionUtils.latLonToProjection(latlon, originalCRS);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
            GeometryFactory gf = new GeometryFactory();
            double epsilon = 0.001;
            Coordinate[] coords = new Coordinate[5];
            double[] ll = ProjectionUtils.latLonToProjection(latlon.add(new LatLon(Angle.fromDegrees((double)(-epsilon)), Angle.fromDegrees((double)(-epsilon)))), originalCRS);
            double[] lr = ProjectionUtils.latLonToProjection(latlon.add(new LatLon(Angle.fromDegrees((double)epsilon), Angle.fromDegrees((double)(-epsilon)))), originalCRS);
            double[] ur = ProjectionUtils.latLonToProjection(latlon.add(new LatLon(Angle.fromDegrees((double)epsilon), Angle.fromDegrees((double)epsilon))), originalCRS);
            double[] ul = ProjectionUtils.latLonToProjection(latlon.add(new LatLon(Angle.fromDegrees((double)(-epsilon)), Angle.fromDegrees((double)epsilon))), originalCRS);
            coords[0] = new Coordinate(ll[0], ll[1]);
            coords[1] = new Coordinate(lr[0], lr[1]);
            coords[2] = new Coordinate(ur[0], ur[1]);
            coords[3] = new Coordinate(ul[0], ul[1]);
            coords[4] = new Coordinate(ll[0], ll[1]);
            LinearRing mbox = gf.createLinearRing(coords);
            Polygon mouseBox = gf.createPolygon(mbox, null);
            String fieldname = featureSource.getSchema().getGeometryDescriptor().getName().getLocalPart();
            if (fieldname.equals("")) {
                fieldname = "the_geom";
            }
            if ((i = (fc = featureSource.getFeatures((Filter)(filter = ff.intersects((Expression)ff.property(fieldname), (Expression)ff.literal((Object)mouseBox))))).features()).hasNext()) {
                SimpleFeature feature = (SimpleFeature)i.next();
                return feature;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

