/*
 * Decompiled with CFR 0.152.
 */
package gw.renderables;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellatorCallback;

public class ComplexPolygonTesselationCallback
implements GLUtessellatorCallback {
    private GL gl;
    private GLU glu;

    public ComplexPolygonTesselationCallback(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    public void begin(int type) {
        this.gl.glBegin(type);
    }

    public void end() {
        this.gl.glEnd();
    }

    public void vertex(Object vertexData) {
        if (vertexData instanceof double[]) {
            double[] pointer = (double[])vertexData;
            if (pointer.length == 7) {
                this.gl.glColor4dv(pointer, 3);
            }
            this.gl.glVertex3dv(pointer, 0);
        }
    }

    public void vertexData(Object vertexData, Object polygonData) {
    }

    public void combine(double[] coords, Object[] data, float[] weight, Object[] outData) {
        double[] vertex = new double[7];
        vertex[0] = coords[0];
        vertex[1] = coords[1];
        vertex[2] = coords[2];
        for (int i = 3; i < 6; ++i) {
            vertex[i] = (double)weight[0] * ((double[])data[0])[i] + (double)weight[1] * ((double[])data[1])[i] + (double)weight[2] * ((double[])data[2])[i] + (double)weight[3] * ((double[])data[3])[i];
        }
        outData[0] = vertex;
    }

    public void combineData(double[] coords, Object[] data, float[] weight, Object[] outData, Object polygonData) {
    }

    public void error(int errnum) {
        String estring = this.glu.gluErrorString(errnum);
        System.err.println("Tessellation Error: " + estring);
        System.exit(0);
    }

    public void beginData(int type, Object polygonData) {
    }

    public void endData(Object polygonData) {
    }

    public void edgeFlag(boolean boundaryEdge) {
    }

    public void edgeFlagData(boolean boundaryEdge, Object polygonData) {
    }

    public void errorData(int errnum, Object polygonData) {
    }
}

