/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Renderable;
import gw.events.FeatureSelectionListener;
import gw.layers.SimpleFeatureLayer;
import gw.renderables.ElevatedSurfaceImage;
import gw.util.GeoToolsUtils;
import gw.util.WorldWindUtils;
import java.awt.Color;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import org.opengis.feature.simple.SimpleFeature;

public class SimpleFeatureLayerSelectionMask
implements SelectListener {
    SimpleFeatureLayer baseShapeLayer;
    GlobeAnnotation tooltip;
    SimpleFeature tooltipFeature;
    ArrayList<FeatureSelection> selections = new ArrayList();
    List<FeatureSelectionListener> featureSelectionListeners = new ArrayList<FeatureSelectionListener>();

    public SimpleFeatureLayerSelectionMask(SimpleFeatureLayer sl) {
        this.baseShapeLayer = sl;
    }

    public void elevationChanged() {
        for (FeatureSelection selection : this.selections) {
            selection.remakeRenderable();
        }
    }

    public void selected(SelectEvent event) {
        PickedObject obj;
        if (event.getMouseEvent() == null) {
            return;
        }
        if (!this.baseShapeLayer.isPickEnabled()) {
            return;
        }
        if ((event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") || event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.RightClick")) && (obj = event.getTopPickedObject()) != null && obj.getObject() instanceof ElevatedSurfaceImage) {
            try {
                SimpleFeature featureAtMousePoint = this.baseShapeLayer.getFeatureAt(this.baseShapeLayer.getMousePosition().getLatLon());
                if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                    this.setSelectedFeature(featureAtMousePoint);
                } else if (event.getEventAction().equals("gov.nasa.worldwind.SelectEvent.RightClick")) {
                    this.showTooltip(featureAtMousePoint);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void clearTooltip() {
        if (this.tooltip != null) {
            this.baseShapeLayer.removeRenderable((Renderable)this.tooltip);
        }
    }

    public void showTooltip(SimpleFeature feature) {
        this.clearTooltip();
        if (feature.equals(this.tooltipFeature)) {
            this.tooltipFeature = null;
            return;
        }
        this.tooltipFeature = feature;
        String txt = "";
        for (int i = 1; i < feature.getAttributeCount(); ++i) {
            txt = txt + feature.getFeatureType().getType(i).getName().getLocalPart() + ": " + feature.getAttribute(i).toString() + "\n";
        }
        this.tooltip = new GlobeAnnotation(txt, new Position(this.baseShapeLayer.getMousePosition().getLatLon(), 0.0));
        this.tooltip.getAttributes().setInsets(new Insets(1, 1, 1, 1));
        this.tooltip.getAttributes().setBorderColor(new Color(0.0f, 0.0f, 0.0f, 1.0f));
        this.tooltip.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 0.85f, 1.0f));
        this.tooltip.getAttributes().setTextColor(Color.BLACK);
        this.tooltip.getAttributes().setScale(0.8);
        this.tooltip.setAlwaysOnTop(true);
        this.baseShapeLayer.addRenderable((Renderable)this.tooltip);
    }

    public SimpleFeature getSelectedFeature() {
        if (this.selections.isEmpty()) {
            return null;
        }
        return this.selections.get(0).getFeature();
    }

    public void addFeatureSelectionListener(FeatureSelectionListener l) {
        this.featureSelectionListeners.add(l);
    }

    public void removeFeatureSelectionListener(FeatureSelectionListener l) {
        this.featureSelectionListeners.remove(l);
    }

    private boolean confirmSelection(SimpleFeature feature) {
        boolean selectionConfirmed = true;
        for (FeatureSelectionListener listener : this.featureSelectionListeners) {
            if (listener.featureSelected(feature)) continue;
            selectionConfirmed = false;
        }
        return selectionConfirmed;
    }

    public boolean isFeatureSelected(SimpleFeature feature) {
        for (FeatureSelection s : this.selections) {
            if (s.getFeature() != feature) continue;
            return true;
        }
        return false;
    }

    public void addSelectedFeature(SimpleFeature feature) {
        if (this.isFeatureSelected(feature)) {
            return;
        }
        if (this.confirmSelection(feature)) {
            this.selections.add(new FeatureSelection(feature));
        }
    }

    public void setSelectedFeature(SimpleFeature feature) {
        if (this.selections.size() == 1 && this.isFeatureSelected(feature)) {
            return;
        }
        if (this.confirmSelection(feature)) {
            this.clearSelection();
            if (feature != null) {
                this.selections.add(new FeatureSelection(feature));
            }
        }
    }

    public void clearSelection() {
        try {
            for (FeatureSelection f : this.selections) {
                this.baseShapeLayer.removeRenderable(f.getRenderable());
            }
            this.selections.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class FeatureSelection {
        private SimpleFeature feature;
        private Renderable renderable;

        public SimpleFeature getFeature() {
            return this.feature;
        }

        public Renderable getRenderable() {
            return this.renderable;
        }

        public void setRenderable(Renderable renderable) {
            this.renderable = renderable;
        }

        public void makeRenderable() {
            Class geomType = SimpleFeatureLayerSelectionMask.this.baseShapeLayer.getSchema().getGeometryDescriptor().getType().getBinding();
            if (geomType.isAssignableFrom(Polygon.class) || geomType.isAssignableFrom(MultiPolygon.class) || geomType.isAssignableFrom(LineString.class) || geomType.isAssignableFrom(MultiLineString.class)) {
                this.renderable = SimpleFeatureLayerSelectionMask.this.baseShapeLayer.isFloating() ? WorldWindUtils.linePathFromFeature(this.feature, SimpleFeatureLayerSelectionMask.this.baseShapeLayer.getCRS(), new Color(1.0f, 0.0f, 0.0f, 0.75f), 2, SimpleFeatureLayerSelectionMask.this.baseShapeLayer.getElevation(), SimpleFeatureLayerSelectionMask.this.baseShapeLayer.isFloating()) : WorldWindUtils.polylineFromFeature(this.feature, SimpleFeatureLayerSelectionMask.this.baseShapeLayer.getCRS(), new Color(1.0f, 0.0f, 0.0f, 0.75f), SimpleFeatureLayerSelectionMask.this.baseShapeLayer.getElevation());
            } else {
                Position p = GeoToolsUtils.getFeatureCenter(this.feature, SimpleFeatureLayerSelectionMask.this.baseShapeLayer.getCRS());
                this.renderable = new Sphere(new Vec4(p.getLongitude().getDegrees(), p.getLatitude().getDegrees(), p.getElevation()), 20.0);
            }
            SimpleFeatureLayerSelectionMask.this.baseShapeLayer.addRenderable(this.renderable);
        }

        public void remakeRenderable() {
            SimpleFeatureLayerSelectionMask.this.baseShapeLayer.removeRenderable(this.renderable);
            this.makeRenderable();
        }

        public FeatureSelection(SimpleFeature feature) {
            this.feature = feature;
            this.makeRenderable();
        }
    }
}

