/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gw.events.FeatureSelectionListener;
import gw.layers.SimpleFeatureLayerSelectionMask;
import gw.renderables.ElevatedSurfaceImage;
import gw.renderables.LinePath;
import gw.util.ColorBlend;
import gw.util.GeoToolsUtils;
import gw.util.ProjectionNotFoundException;
import gw.util.ProjectionUtils;
import gw.util.StyleInfo;
import gw.util.TransformFailedException;
import gw.util.WorldWindUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class SimpleFeatureLayer
extends RenderableLayer
implements PositionListener {
    int dim = 512;
    CoordinateReferenceSystem originalCRS;
    FeatureSource<SimpleFeatureType, SimpleFeature> featureSource;
    MapContext map;
    Envelope initialBounds;
    ReferencedEnvelope layerBounds;
    Style style;
    BufferedImage img;
    Graphics2D ig;
    ElevatedSurfaceImage surfaceImage;
    SurfaceImage shadowImage;
    double attrMin;
    double attrMax;
    int attrNum = -1;
    Color borderColor = Color.WHITE;
    Color attrMinColor = Color.BLACK;
    Color attrMaxColor = Color.WHITE;
    int borderWidth = 1;
    SimpleFeatureLayerSelectionMask selectionMask;
    SimpleFeature[] features;
    int[][] imgX;
    int[][] imgY;
    boolean drawLines = true;
    long lastCursorMoveTime = 0L;
    Position mousePosition = Position.ZERO;
    boolean drawStyled = true;
    Map<Integer, Double> colorRampValues = null;
    double crmin = Double.MAX_VALUE;
    double crmax = Double.MIN_VALUE;

    public SimpleFeatureLayer(String name, FeatureSource<SimpleFeatureType, SimpleFeature> source, Style s, WorldWindow canvas, int dim) throws IOException {
        this.dim = dim;
        this.setPickEnabled(false);
        this.setName(name);
        this.featureSource = source;
        this.style = s;
        this.img = new BufferedImage(dim, dim, 2);
        this.map = new DefaultMapContext(((SimpleFeatureType)this.featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem());
        this.map.addLayer(this.featureSource, this.style);
        this.initialBounds = this.map.getAreaOfInterest();
        this.originalCRS = this.map.getCoordinateReferenceSystem();
        try {
            this.map.setCoordinateReferenceSystem(ProjectionUtils.getDefaultCRS());
        }
        catch (FactoryException fe) {
            throw new ProjectionNotFoundException(fe);
        }
        catch (TransformException te) {
            throw new TransformFailedException(te);
        }
        this.features = (SimpleFeature[])this.featureSource.getFeatures().toArray();
        this.calculateProjectedCoordinates(this.getSector());
        this.layerBounds = this.map.getLayerBounds();
        this.img = new BufferedImage(dim, dim, 2);
        this.redraw();
        this.surfaceImage = new ElevatedSurfaceImage(this.img, this.getSector());
        this.surfaceImage.setElevation(0.0);
        this.setFloating(false);
        this.shadowImage = new SurfaceImage((Object)this.createShadowImage(), this.getSector());
        this.shadowImage.setOpacity(0.0);
        this.addRenderable((Renderable)this.shadowImage);
        this.addRenderable((Renderable)this.surfaceImage);
        this.selectionMask = new SimpleFeatureLayerSelectionMask(this);
        canvas.addPositionListener((PositionListener)this);
        canvas.addSelectListener((SelectListener)this.selectionMask);
    }

    public void sharpenLines() {
        StyleInfo info = new StyleInfo();
        this.getStyle().accept((StyleVisitor)info);
        Class type = this.getSchema().getGeometryDescriptor().getType().getBinding();
        if (type.isAssignableFrom(Polygon.class) || type.isAssignableFrom(MultiPolygon.class)) {
            for (SimpleFeature feature : this.features) {
                Color lineColor = Color.decode((String)info.getPolygonStroke().getColor().evaluate((Object)feature));
                int width = ((Number)info.getPolygonStroke().getWidth().evaluate((Object)feature)).intValue();
                LinePath renderable = WorldWindUtils.linePathFromFeature(feature, this.getCRS(), lineColor, width, 0.0, false);
                this.addRenderable(renderable);
            }
        }
        this.drawLines = false;
    }

    public void addFeatureSelection(SimpleFeature f) {
        this.selectionMask.addSelectedFeature(f);
    }

    public void addFeatureSelectionListener(FeatureSelectionListener l) {
        this.selectionMask.addFeatureSelectionListener(l);
    }

    private void calculateProjectedCoordinates(Sector sector) {
        this.imgX = new int[this.features.length][];
        this.imgY = new int[this.features.length][];
        int featureIndex = 0;
        for (SimpleFeature feature : this.features) {
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            Coordinate[] coords = geometry.getCoordinates();
            this.imgX[featureIndex] = new int[coords.length];
            this.imgY[featureIndex] = new int[coords.length];
            for (int i = 0; i < coords.length; ++i) {
                double[] c = new double[]{coords[i].x, coords[i].y};
                LatLon ll = ProjectionUtils.toLatLon(c, this.originalCRS);
                double px = (ll.getLongitude().getDegrees() - sector.getMinLongitude().getDegrees()) / sector.getDeltaLonDegrees();
                double py = 1.0 - (ll.getLatitude().getDegrees() - sector.getMinLatitude().getDegrees()) / sector.getDeltaLatDegrees();
                this.imgX[featureIndex][i] = (int)(px * (double)this.img.getWidth());
                this.imgY[featureIndex][i] = (int)(py * (double)this.img.getHeight());
            }
            ++featureIndex;
        }
    }

    public void clearSelections() {
        this.selectionMask.clearSelection();
    }

    protected Color colorForFeature(SimpleFeature feature) {
        if (this.attrNum == -1) {
            return this.attrMaxColor;
        }
        double attrval = ((Number)feature.getAttribute(this.attrNum)).doubleValue();
        double percentage = (attrval - this.attrMin) / (this.attrMax - this.attrMin);
        return ColorBlend.mixColors(this.attrMinColor, this.attrMaxColor, (float)percentage);
    }

    protected void drawFeature(int index, double min, double max, Map<Integer, Double> values) {
        SimpleFeature feature = this.features[index];
        Color featureColor = null;
        if (values != null) {
            double attrval = values.get(index);
            double percentage = (attrval - min) / (max - min);
            featureColor = ColorBlend.mixColors(this.attrMinColor, this.attrMaxColor, (float)percentage);
        } else {
            featureColor = this.colorForFeature(feature);
        }
        this.drawFeature(this.ig, index, featureColor, this.drawLines);
    }

    protected void drawFeature(Graphics2D graphics, int index, Color color, boolean drawBorder) {
        Class geomType = this.getSchema().getGeometryDescriptor().getType().getBinding();
        if (geomType.isAssignableFrom(Polygon.class) || geomType.isAssignableFrom(MultiPolygon.class)) {
            graphics.setStroke(new BasicStroke(this.getBorderWidth()));
            graphics.setPaint(color);
            graphics.fillPolygon(this.imgX[index], this.imgY[index], this.imgX[index].length);
            if (drawBorder) {
                graphics.setPaint(this.getBorderColor());
                graphics.drawPolygon(this.imgX[index], this.imgY[index], this.imgX[index].length);
            }
        } else if (geomType.isAssignableFrom(LineString.class) || geomType.isAssignableFrom(MultiLineString.class)) {
            graphics.setStroke(new BasicStroke(4.0f));
            graphics.setPaint(color);
            graphics.drawPolyline(this.imgX[index], this.imgY[index], this.imgX[index].length);
        } else {
            graphics.setPaint(color);
            graphics.fillOval(this.imgX[index][0], this.imgY[index][0], 10, 10);
        }
    }

    public long getLastCursorMoveTime() {
        return this.lastCursorMoveTime;
    }

    public void moved(PositionEvent event) {
        if (event == null || event.getPosition() == null) {
            return;
        }
        this.lastCursorMoveTime = System.currentTimeMillis();
        this.mousePosition = event.getPosition();
    }

    private double getShadowBrightness() {
        return 0.25 + (1.0 - this.getElevation() / 40000.0) * 0.75;
    }

    private BufferedImage createShadowImage() {
        BufferedImage shadowImg = new BufferedImage(this.dim, this.dim, 2);
        Graphics2D graphics = shadowImg.createGraphics();
        graphics.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        graphics.clearRect(0, 0, this.dim, this.dim);
        for (int i = 0; i < this.features.length; ++i) {
            this.drawFeature(graphics, i, new Color(0.0f, 0.0f, 0.0f, 0.4f), false);
        }
        return shadowImg;
    }

    public void redraw() {
        if (this.isDrawStyled()) {
            this.redrawStyled();
        } else {
            this.redrawWithColorRamp();
        }
    }

    protected void redrawWithColorRamp() {
        this.ig = this.img.createGraphics();
        this.ig.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.ig.clearRect(0, 0, this.dim, this.dim);
        for (int i = 0; i < this.features.length; ++i) {
            this.drawFeature(i, this.crmin, this.crmax, this.getColorRampValues());
        }
        if (this.surfaceImage != null) {
            this.surfaceImage.refresh();
        }
    }

    protected void redrawStyled() {
        this.ig = this.img.createGraphics();
        this.ig.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.ig.clearRect(0, 0, this.dim, this.dim);
        StreamingRenderer render = new StreamingRenderer();
        render.setContext(this.map);
        render.paint(this.ig, new Rectangle(this.dim, this.dim), this.layerBounds);
        if (this.surfaceImage != null) {
            this.surfaceImage.refresh();
        }
    }

    public void selectFeature(SimpleFeature f) {
        try {
            this.selectionMask.setSelectedFeature(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void calcShadow() {
        if (this.shadowImage == null || this.surfaceImage == null) {
            return;
        }
        double elev = this.getElevation();
        if (elev > 0.0 && this.isFloating()) {
            this.shadowImage.setOpacity(this.surfaceImage.getOpacity() * this.getShadowBrightness());
        } else {
            this.shadowImage.setOpacity(0.0);
        }
    }

    public boolean isFloating() {
        return this.surfaceImage.getFloating();
    }

    public void setFloating(boolean floating) {
        this.surfaceImage.setFloating(floating);
        if (this.selectionMask != null) {
            this.selectionMask.elevationChanged();
        }
        this.calcShadow();
    }

    public double getElevation() {
        return this.surfaceImage.getElevation();
    }

    public void setElevation(double elev) {
        this.surfaceImage.setElevation(elev);
        if (this.selectionMask != null) {
            this.selectionMask.elevationChanged();
        }
        this.calcShadow();
    }

    public CoordinateReferenceSystem getCRS() {
        return this.originalCRS;
    }

    public SimpleFeature getFeatureAt(LatLon latlon) {
        return GeoToolsUtils.getFeatureAt(latlon, this.featureSource, this.originalCRS);
    }

    public SimpleFeature[] getFeatures() {
        return this.features;
    }

    public FeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public Position getMousePosition() {
        return this.mousePosition;
    }

    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.featureSource.getSchema();
    }

    public Sector getSector() {
        ReferencedEnvelope env = this.map.getAreaOfInterest();
        double aspect = 1.0;
        double halfWidth = env.getWidth() * 0.5 * aspect;
        double halfHeight = env.getHeight() * 0.5;
        double cx = env.getMinX() + env.getWidth() * 0.5;
        double cy = env.getMinY() + env.getHeight() * 0.5;
        Sector unprojectedSector = Sector.fromDegrees((double)(cy - halfHeight), (double)(cy + halfHeight), (double)(cx - halfWidth), (double)(cx + halfWidth));
        return unprojectedSector;
    }

    public void setPrimaryAttr(int attrnum) {
        this.attrNum = attrnum;
        this.attrMin = Double.MAX_VALUE;
        this.attrMax = Double.MIN_VALUE;
        for (SimpleFeature feature : this.getFeatures()) {
            double attr = Double.parseDouble(feature.getAttribute(this.attrNum).toString());
            if (attr < this.attrMin) {
                this.attrMin = attr;
            }
            if (!(attr > this.attrMax)) continue;
            this.attrMax = attr;
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.map.clearLayerList();
        this.map.addLayer(this.featureSource, style);
        this.redrawStyled();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getAttrMinColor() {
        return this.attrMinColor;
    }

    public void setAttrMinColor(Color attrMinColor) {
        this.attrMinColor = attrMinColor;
    }

    public Color getAttrMaxColor() {
        return this.attrMaxColor;
    }

    public void setAttrMaxColor(Color attrMaxColor) {
        this.attrMaxColor = attrMaxColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public double getOpacity() {
        return this.surfaceImage.getOpacity();
    }

    public void setOpacity(double opacity) {
        this.surfaceImage.setOpacity(opacity);
        if (this.getElevation() > 0.0) {
            this.shadowImage.setOpacity(opacity * this.getShadowBrightness());
        }
    }

    public String toString() {
        return this.getName();
    }

    public boolean isDrawStyled() {
        return this.drawStyled;
    }

    public void setDrawStyled(boolean drawStyled) {
        this.drawStyled = drawStyled;
    }

    public Map<Integer, Double> getColorRampValues() {
        return this.colorRampValues;
    }

    public void setColorRampValues(Map<Integer, Double> colorRampValues) {
        this.colorRampValues = colorRampValues;
        this.crmin = Double.MAX_VALUE;
        this.crmax = Double.MIN_VALUE;
        if (this.getColorRampValues() != null) {
            for (Double obj : this.getColorRampValues().values()) {
                double attr = ((Number)obj).doubleValue();
                if (attr < this.crmin) {
                    this.crmin = attr;
                }
                if (!(attr > this.crmax)) continue;
                this.crmax = attr;
            }
        }
    }
}

