/*
 * Decompiled with CFR 0.152.
 */
package gw.layers;

import gov.nasa.worldwind.WorldWindow;
import gw.layers.SimpleFeatureLayer;
import gw.util.AnimationFile;
import gw.util.ColorBlend;
import gw.util.StyleInfo;
import java.awt.Color;
import java.io.IOException;
import org.geotools.data.FeatureSource;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class AnimatedSimpleFeatureLayer
extends SimpleFeatureLayer {
    AnimationFile animationFile;
    StyleInfo styleInfo;
    private int frame = 0;
    AnimationFile.Timestep currentTimestep = null;
    double colMin = 0.0;
    double colMax = 0.0;
    private int animationColumn;

    public AnimatedSimpleFeatureLayer(String name, FeatureSource<SimpleFeatureType, SimpleFeature> source, Style s, WorldWindow canvas, AnimationFile animationFile) throws IOException {
        super(name, source, s, canvas, 256);
        this.animationFile = animationFile;
        this.setFrame(0);
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
        this.currentTimestep = this.animationFile.getTimestep(frame);
    }

    public int getFrameCount() {
        if (this.animationFile == null) {
            return 0;
        }
        return this.animationFile.getTimestepCount();
    }

    @Override
    public void setPrimaryAttr(int attr) {
        super.setPrimaryAttr(attr);
    }

    @Override
    public void redraw() {
        this.redrawWithColorRamp();
    }

    @Override
    protected Color colorForFeature(SimpleFeature feature) {
        if (this.attrNum == -1) {
            return Color.BLACK;
        }
        String[] attrs = this.currentTimestep.match(1, feature.getAttribute(this.attrNum).toString());
        double attr = Double.parseDouble(attrs[this.getAnimationColumn()]);
        double percentage = (attr - this.colMin) / (this.colMax - this.colMin);
        return ColorBlend.mixColors(this.attrMinColor, this.attrMaxColor, (float)percentage);
    }

    public int getAnimationColumn() {
        return this.animationColumn;
    }

    public void setAnimationColumn(int animationColumn) {
        this.animationColumn = animationColumn;
        this.colMin = this.animationFile.getMinDouble(animationColumn);
        this.colMax = this.animationFile.getMaxDouble(animationColumn);
    }
}

