/*
 * Decompiled with CFR 0.152.
 */
package oms3.doc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oms3.annotations.Author;
import oms3.annotations.Bibliography;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Range;
import oms3.annotations.SourceInfo;
import oms3.annotations.Unit;
import oms3.annotations.VersionInfo;
import oms3.io.CSProperties;
import oms3.util.Components;

public class Documents {
    public static void db5Sim(File file, Class comp, CSProperties params, String title) throws FileNotFoundException {
        Documents.db5Sim(file, comp, params, title, Locale.getDefault());
    }

    public static void db5Sim(File file, Class comp, CSProperties params, String title, Locale loc) throws FileNotFoundException {
        DB5 db5 = new DB5(loc);
        db5.generateDB5(file, comp, params, title);
    }

    static class DB5 {
        private static String db50 = "<book version='5.0' xmlns='http://docbook.org/ns/docbook' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:xi='http://www.w3.org/2001/XInclude' xmlns:svg='http://www.w3.org/2000/svg' xmlns:m='http://www.w3.org/1998/Math/MathML' xmlns:html='http://www.w3.org/1999/xhtml' xmlns:db='http://docbook.org/ns/docbook'>";
        Locale loc;
        ResourceBundle b;

        DB5(Locale loc) {
            this.loc = loc;
            this.b = ResourceBundle.getBundle("oms3.doc.Loc", loc);
        }

        void generateDB5(File file, Class comp, CSProperties params, String title) throws FileNotFoundException {
            SimpleDateFormat df = new SimpleDateFormat(this.b.getString("date_format"), this.loc);
            PrintStream f = new PrintStream(file);
            f.println(db50);
            f.println("<info>");
            f.println("<title>" + title + "</title>");
            f.println("<subtitle>" + this.b.getString("subtitle") + "</subtitle>");
            f.println("<pubdate>" + df.format(new Date()) + "</pubdate>");
            f.println("</info>");
            if (comp != null) {
                Collection<Class<?>> c = Components.internalComponents(comp);
                f.println(this.getComponentsChapter(c));
            }
            if (params != null) {
                f.println(this.getParamChapter(params));
            }
            f.println("<index/>");
            f.println("</book>");
            f.close();
        }

        String getParamChapter(CSProperties p) {
            StringBuilder db = new StringBuilder();
            db.append("<chapter>");
            db.append("<title>" + this.b.getString("parameterset") + "</title>");
            db.append(this.paramList("Parameter", p));
            db.append("</chapter>");
            return db.toString();
        }

        String paramList(String title, CSProperties p) {
            if (p.size() == 0) {
                return "";
            }
            ArrayList keys = new ArrayList(p.keySet());
            Collections.sort(keys);
            StringBuilder db = new StringBuilder();
            db.append("<variablelist>");
            for (String name : keys) {
                db.append(this.varlistentry(name, p.get(name).toString(), p.getInfo(name)));
            }
            db.append("</variablelist>");
            return db.toString();
        }

        String varlistentry(String name, String item, Map<String, String> info) {
            StringBuilder db = new StringBuilder();
            db.append("<varlistentry><term><emphasis role='bold'>" + name + "</emphasis>");
            db.append("<indexterm><primary>" + name + " (" + this.b.getString("parameter") + ")</primary><secondary>" + "Value</secondary></indexterm>");
            String descr = info.get("descr");
            if (descr != null) {
                db.append(" - " + descr);
            }
            db.append("</term>");
            db.append("<listitem><para><code>");
            db.append(item);
            db.append("</code></para>");
            for (String key : info.keySet()) {
                if (key.equals("descr")) continue;
                db.append("<para>" + key + " - " + info.get(key) + "</para>");
            }
            db.append("</listitem>");
            db.append("</varlistentry>");
            return db.toString();
        }

        String classSection(Class<?> c) {
            Documentation doc;
            License lic;
            SourceInfo source;
            VersionInfo version;
            Description descr;
            StringBuilder db = new StringBuilder();
            db.append("<section>");
            db.append("<title>" + this.b.getString("component") + " '" + c.getSimpleName() + "'</title>");
            db.append("<indexterm><primary>" + c.getSimpleName() + " (" + this.b.getString("component") + ")</primary></indexterm>");
            Keywords keywords = c.getAnnotation(Keywords.class);
            if (keywords != null && !keywords.value().isEmpty()) {
                StringTokenizer t = new StringTokenizer(keywords.value(), ",");
                while (t.hasMoreTokens()) {
                    db.append("<indexterm><primary>" + t.nextToken().trim() + " (" + this.b.getString("keyword") + ")</primary><secondary>" + c.getSimpleName() + "</secondary></indexterm>");
                }
            }
            if ((descr = c.getAnnotation(Description.class)) != null) {
                String d = DB5.locDesc(descr, this.loc);
                db.append("<para><![CDATA[" + d + "]]></para>");
            }
            db.append("<variablelist>");
            db.append(DB5.varlistentry(this.b.getString("name"), "<code>" + c.getName() + "</code>"));
            Author author = c.getAnnotation(Author.class);
            if (author != null) {
                StringTokenizer t = new StringTokenizer(author.name(), ",");
                StringBuilder authindex = new StringBuilder();
                while (t.hasMoreTokens()) {
                    authindex.append("<indexterm><primary>" + t.nextToken().trim() + " (" + this.b.getString("author") + ")</primary><secondary>" + c.getSimpleName() + "</secondary></indexterm>");
                }
                db.append(DB5.varlistentry(this.b.getString("author"), author.name() + (author.contact().isEmpty() ? "" : " - " + author.contact()), authindex.toString()));
            }
            if (keywords != null && !keywords.value().isEmpty()) {
                db.append(DB5.varlistentry(this.b.getString("keyword"), keywords.value()));
            }
            if ((version = c.getAnnotation(VersionInfo.class)) != null) {
                db.append(DB5.varlistentry(this.b.getString("version"), version.value()));
            }
            if ((source = c.getAnnotation(SourceInfo.class)) != null) {
                String src = source.value();
                db.append(DB5.varlistentry(this.b.getString("source"), src));
            }
            if ((lic = c.getAnnotation(License.class)) != null) {
                db.append(DB5.varlistentry(this.b.getString("license"), lic.value()));
            }
            db.append("</variablelist>");
            db.append(this.table(this.b.getString("parameter"), this.b.getString("parameter"), c, Components.parameter(c)));
            db.append(this.table(this.b.getString("var_in"), this.b.getString("variable"), c, Components.inVars(c)));
            db.append(this.table(this.b.getString("var_out"), this.b.getString("variable"), c, Components.outVars(c)));
            Bibliography biblio = c.getAnnotation(Bibliography.class);
            if (biblio != null) {
                db.append("<section>");
                db.append("<title>" + this.b.getString("bibliography") + "</title>");
                db.append("<variablelist>");
                StringBuffer bs = new StringBuffer("<itemizedlist>");
                for (String entry : biblio.value()) {
                    bs.append("<listitem><para>" + entry + "</para></listitem>");
                }
                bs.append("</itemizedlist>");
                db.append(DB5.varlistentry("", bs.toString()));
                db.append("</variablelist>");
                db.append("</section>");
            }
            if ((doc = c.getAnnotation(Documentation.class)) != null) {
                String v = doc.value();
                if (v.endsWith(".xml")) {
                    try {
                        URL url = new URL(v);
                        db.append("<xi:include href='" + v + "' xmlns:xi='http://www.w3.org/2001/XInclude'/>");
                    }
                    catch (MalformedURLException E) {
                        try {
                            File f;
                            File rel = new File(v);
                            if (!rel.isAbsolute() && System.getProperty("oms3.work") != null) {
                                File work = new File(System.getProperty("oms3.work"));
                                File locF = DB5.locFile(work, v, this.loc);
                                v = ("file:/" + locF.toString()).replace('\\', '/');
                            }
                            if ((f = new File(new URI(v))).exists()) {
                                db.append("<xi:include href='" + v + "' xmlns:xi='http://www.w3.org/2001/XInclude'/>");
                            } else {
                                System.out.println("Document not found: " + v);
                            }
                        }
                        catch (URISyntaxException ex) {
                            System.out.println("Document not found: " + v);
                        }
                        catch (IllegalArgumentException iae) {
                            iae.printStackTrace(System.out);
                            System.out.println("Illegal Argument: " + iae.getMessage() + " " + v);
                        }
                    }
                } else {
                    db.append("<variablelist><varlistentry><term><emphasis role='bold'>" + this.b.getString("further") + "</emphasis></term>");
                    db.append("<listitem><para>");
                    db.append(v);
                    db.append("</para></listitem>");
                    db.append("</varlistentry></variablelist>");
                }
            }
            db.append("</section>");
            return db.toString();
        }

        String getComponentsChapter(Collection<Class<?>> comps) {
            StringBuffer db = new StringBuffer();
            db.append("<chapter>");
            db.append("<title>" + this.b.getString("model") + "</title>");
            Class<?> mai = comps.iterator().next();
            db.append(this.classSection(mai));
            db.append("</chapter>");
            comps.remove(mai);
            Map<Package, List<Class<?>>> pmap = DB5.categorize(comps);
            ArrayList<Package> pl = new ArrayList<Package>(pmap.keySet());
            Collections.sort(pl, new Comparator<Package>(){

                @Override
                public int compare(Package o1, Package o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            db.append("<chapter>");
            db.append("<title>" + this.b.getString("sub") + "</title>");
            for (Package p : pl) {
                db.append("<section>");
                db.append("<title>'" + p.getName() + "'</title>");
                List<Class<?>> co = pmap.get(p);
                Collections.sort(co, new Comparator<Class<?>>(){

                    @Override
                    public int compare(Class o1, Class o2) {
                        return o1.getSimpleName().compareToIgnoreCase(o2.getSimpleName());
                    }
                });
                for (Class<?> c : co) {
                    db.append(this.classSection(c));
                }
                db.append("</section>");
            }
            db.append("</chapter>");
            return db.toString();
        }

        String table(String title, String cl, Class comp, List<Field> l) {
            if (l.size() == 0) {
                return "";
            }
            Collections.sort(l, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            StringBuffer db = new StringBuffer();
            db.append("<section>");
            db.append("<title>" + title + "</title>");
            db.append("<variablelist>");
            for (Field field : l) {
                db.append("<varlistentry><term><emphasis role='bold'>" + field.getName() + "</emphasis>");
                Unit unit = field.getAnnotation(Unit.class);
                if (unit != null) {
                    db.append("<code> [");
                    db.append(unit.value());
                    db.append("]</code>");
                }
                db.append("<code> - " + field.getType().getSimpleName() + "</code>");
                Range range = field.getAnnotation(Range.class);
                if (range != null) {
                    db.append("  (");
                    db.append(range.min() == Double.MIN_VALUE ? "" : Double.valueOf(range.min()));
                    db.append(" ... ");
                    db.append(range.max() == Double.MAX_VALUE ? "" : Double.valueOf(range.max()));
                    db.append(")");
                }
                db.append("<indexterm><primary>" + field.getName() + " (" + cl + ")</primary><secondary>" + field.getDeclaringClass().getSimpleName() + "</secondary></indexterm>");
                db.append("</term>");
                db.append("<listitem><para>");
                Description descr = field.getAnnotation(Description.class);
                if (descr != null) {
                    String d = DB5.locDesc(descr, this.loc);
                    db.append("<![CDATA[" + d + "]]>");
                }
                db.append("</para></listitem>");
                db.append("</varlistentry>");
            }
            db.append("</variablelist>");
            db.append("</section>");
            return db.toString();
        }

        static String varlistentry(String name, String item) {
            return DB5.varlistentry(name, item, "");
        }

        static String varlistentry(String name, String item, String indexterm) {
            StringBuffer db = new StringBuffer();
            db.append("<varlistentry><term><emphasis role='bold'>" + name + "</emphasis>" + indexterm + "</term>");
            db.append("<listitem><para>");
            db.append(item);
            db.append("</para></listitem>");
            db.append("</varlistentry>");
            return db.toString();
        }

        static Map<Package, List<Class<?>>> categorize(Collection<Class<?>> comp) {
            HashMap packages = new HashMap();
            for (Class<?> c : comp) {
                Package p = c.getPackage();
                ArrayList tos = (ArrayList)packages.get(p);
                if (tos == null) {
                    tos = new ArrayList();
                    packages.put(p, tos);
                }
                tos.add(c);
            }
            return packages;
        }

        static File locFile(File work, String descr, Locale l) {
            if (l == null) {
                return new File(work, descr);
            }
            String locName = descr.substring(0, descr.lastIndexOf(46));
            String locExt = descr.substring(descr.lastIndexOf(46));
            String locLan = l.getLanguage();
            File f = new File(work, locName + "_" + locLan + locExt);
            if (f.exists()) {
                return f;
            }
            f = new File(work, descr);
            if (f.exists()) {
                return f;
            }
            throw new IllegalArgumentException(descr);
        }

        static String locDesc(Description descr, Locale l) {
            if (l == null) {
                return descr.value();
            }
            if (l.getLanguage().equals("en")) {
                return descr.en().isEmpty() ? descr.value() : descr.en();
            }
            if (l.getLanguage().equals("de")) {
                return descr.de().isEmpty() ? descr.value() : descr.de();
            }
            return descr.value();
        }
    }
}

