/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.ArrayDataOutput;

public class BufferedDataOutputStream
extends BufferedOutputStream
implements ArrayDataOutput {
    public BufferedDataOutputStream(OutputStream outputStream) {
        super(outputStream, 32768);
    }

    public BufferedDataOutputStream(OutputStream outputStream, int n) {
        super(outputStream, n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.checkBuf(1);
        this.buf[this.count++] = bl ? (byte)1 : 0;
    }

    public void writeByte(int n) throws IOException {
        this.checkBuf(1);
        this.buf[this.count++] = (byte)n;
    }

    public void writeInt(int n) throws IOException {
        this.checkBuf(4);
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeShort(int n) throws IOException {
        this.checkBuf(2);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeChar(int n) throws IOException {
        this.checkBuf(2);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeLong(long l) throws IOException {
        this.checkBuf(8);
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    public void writeFloat(float f) throws IOException {
        this.checkBuf(4);
        int n = Float.floatToIntBits(f);
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeDouble(double d) throws IOException {
        this.checkBuf(8);
        long l = Double.doubleToLongBits(d);
        this.buf[this.count++] = (byte)(l >>> 56);
        this.buf[this.count++] = (byte)(l >>> 48);
        this.buf[this.count++] = (byte)(l >>> 40);
        this.buf[this.count++] = (byte)(l >>> 32);
        this.buf[this.count++] = (byte)(l >>> 24);
        this.buf[this.count++] = (byte)(l >>> 16);
        this.buf[this.count++] = (byte)(l >>> 8);
        this.buf[this.count++] = (byte)l;
    }

    public void writeBytes(String string) throws IOException {
        this.write(string.getBytes(), 0, string.length());
    }

    public void writeChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeChar(string.charAt(n));
            ++n;
        }
    }

    public void writeUTF(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(this);
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    public void writePrimitiveArray(Object object) throws IOException {
        this.writeArray(object);
    }

    public void writeArray(Object object) throws IOException {
        String string = object.getClass().getName();
        if (string.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.write" + string);
        }
        if (string.charAt(1) == '[') {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.writeArray(((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (string.charAt(1)) {
                case 'Z': {
                    this.write((boolean[])object, 0, ((boolean[])object).length);
                    break;
                }
                case 'B': {
                    this.write((byte[])object, 0, ((byte[])object).length);
                    break;
                }
                case 'C': {
                    this.write((char[])object, 0, ((char[])object).length);
                    break;
                }
                case 'S': {
                    this.write((short[])object, 0, ((short[])object).length);
                    break;
                }
                case 'I': {
                    this.write((int[])object, 0, ((int[])object).length);
                    break;
                }
                case 'J': {
                    this.write((long[])object, 0, ((long[])object).length);
                    break;
                }
                case 'F': {
                    this.write((float[])object, 0, ((float[])object).length);
                    break;
                }
                case 'D': {
                    this.write((double[])object, 0, ((double[])object).length);
                    break;
                }
                case 'L': {
                    if (string.equals("[Ljava.lang.String;")) {
                        this.write((String[])object, 0, ((String[])object).length);
                        break;
                    }
                    if (string.equals("[Ljava.lang.Object;")) {
                        int n = 0;
                        while (n < ((Object[])object).length) {
                            this.writeArray(((Object[])object)[n]);
                            ++n;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + string);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + string);
                }
            }
        }
    }

    public void write(boolean[] blArray) throws IOException {
        this.write(blArray, 0, blArray.length);
    }

    public void write(boolean[] blArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 1 > this.buf.length) {
                this.checkBuf(1);
            }
            this.buf[this.count++] = blArray[n3] ? (byte)1 : 0;
            ++n3;
        }
    }

    public void write(short[] sArray) throws IOException {
        this.write(sArray, 0, sArray.length);
    }

    public void write(short[] sArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 2 > this.buf.length) {
                this.checkBuf(2);
            }
            this.buf[this.count++] = (byte)(sArray[n3] >> 8);
            this.buf[this.count++] = (byte)sArray[n3];
            ++n3;
        }
    }

    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 2 > this.buf.length) {
                this.checkBuf(2);
            }
            this.buf[this.count++] = (byte)(cArray[n3] >> 8);
            this.buf[this.count++] = (byte)cArray[n3];
            ++n3;
        }
    }

    public void write(int[] nArray) throws IOException {
        this.write(nArray, 0, nArray.length);
    }

    public void write(int[] nArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 4 > this.buf.length) {
                this.checkBuf(4);
            }
            this.buf[this.count++] = (byte)(nArray[n3] >>> 24);
            this.buf[this.count++] = (byte)(nArray[n3] >>> 16);
            this.buf[this.count++] = (byte)(nArray[n3] >>> 8);
            this.buf[this.count++] = (byte)nArray[n3];
            ++n3;
        }
    }

    public void write(long[] lArray) throws IOException {
        this.write(lArray, 0, lArray.length);
    }

    public void write(long[] lArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 8 > this.buf.length) {
                this.checkBuf(8);
            }
            int n4 = (int)(lArray[n3] >>> 32);
            this.buf[this.count++] = (byte)(n4 >>> 24);
            this.buf[this.count++] = (byte)(n4 >>> 16);
            this.buf[this.count++] = (byte)(n4 >>> 8);
            this.buf[this.count++] = (byte)n4;
            n4 = (int)lArray[n3];
            this.buf[this.count++] = (byte)(n4 >>> 24);
            this.buf[this.count++] = (byte)(n4 >>> 16);
            this.buf[this.count++] = (byte)(n4 >>> 8);
            this.buf[this.count++] = (byte)n4;
            ++n3;
        }
    }

    public void write(float[] fArray) throws IOException {
        this.write(fArray, 0, fArray.length);
    }

    public void write(float[] fArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 4 > this.buf.length) {
                this.checkBuf(4);
            }
            int n4 = Float.floatToIntBits(fArray[n3]);
            this.buf[this.count++] = (byte)(n4 >>> 24);
            this.buf[this.count++] = (byte)(n4 >>> 16);
            this.buf[this.count++] = (byte)(n4 >>> 8);
            this.buf[this.count++] = (byte)n4;
            ++n3;
        }
    }

    public void write(double[] dArray) throws IOException {
        this.write(dArray, 0, dArray.length);
    }

    public void write(double[] dArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            if (this.count + 8 > this.buf.length) {
                this.checkBuf(8);
            }
            long l = Double.doubleToLongBits(dArray[n3]);
            int n4 = (int)(l >>> 32);
            this.buf[this.count++] = (byte)(n4 >>> 24);
            this.buf[this.count++] = (byte)(n4 >>> 16);
            this.buf[this.count++] = (byte)(n4 >>> 8);
            this.buf[this.count++] = (byte)n4;
            n4 = (int)l;
            this.buf[this.count++] = (byte)(n4 >>> 24);
            this.buf[this.count++] = (byte)(n4 >>> 16);
            this.buf[this.count++] = (byte)(n4 >>> 8);
            this.buf[this.count++] = (byte)n4;
            ++n3;
        }
    }

    public void write(String[] stringArray) throws IOException {
        this.write(stringArray, 0, stringArray.length);
    }

    public void write(String[] stringArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.writeBytes(stringArray[n3]);
            ++n3;
        }
    }

    protected void checkBuf(int n) throws IOException {
        if (this.count + n > this.buf.length) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }
}

