/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.image.ImageTiler;
import nom.tam.util.ArrayFuncs;

public class ImageHDU
extends BasicHDU {
    public ImageHDU(Header header, Data data) throws FitsException {
        this.myData = data;
        this.myHeader = header;
    }

    protected boolean canBePrimary() {
        return true;
    }

    protected void setPrimaryHDU(boolean bl) {
        try {
            super.setPrimaryHDU(bl);
        }
        catch (FitsException fitsException) {
            System.err.println("Impossible exception in ImageData");
        }
        if (bl) {
            this.myHeader.setSimple(true);
        } else {
            this.myHeader.setXtension("IMAGE");
        }
    }

    public static boolean isHeader(Header header) {
        String string;
        boolean bl = false;
        bl = header.getBooleanValue("SIMPLE");
        if (!bl && (string = header.getStringValue("XTENSION")) != null && (string.trim().equals("IMAGE") || string.trim().equals("IUEIMAGE"))) {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        return !header.getBooleanValue("GROUPS");
    }

    public static boolean isData(Object object) {
        String string = object.getClass().getName();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '[') break;
            ++n;
        }
        return n > 0 && string.charAt(n) != 'L' && string.charAt(n) != 'Z';
    }

    public Data manufactureData() throws FitsException {
        return ImageHDU.manufactureData(this.myHeader);
    }

    public static Data manufactureData(Header header) throws FitsException {
        return new ImageData(header);
    }

    public static Header manufactureHeader(Data data) throws FitsException {
        if (data == null) {
            return null;
        }
        Header header = new Header();
        data.fillHeader(header);
        return header;
    }

    public static Data encapsulate(Object object) throws FitsException {
        return new ImageData(object);
    }

    public ImageTiler getTiler() {
        return ((ImageData)this.myData).getTiler();
    }

    public void info() {
        if (ImageHDU.isHeader(this.myHeader)) {
            System.out.println("  Image");
        } else {
            System.out.println("  Image (bad header)");
        }
        System.out.println("      Header Information:");
        System.out.println("         BITPIX=" + this.myHeader.getIntValue("BITPIX", -1));
        int n = this.myHeader.getIntValue("NAXIS", -1);
        System.out.println("         NAXIS=" + n);
        int n2 = 1;
        while (n2 <= n) {
            System.out.println("         NAXIS" + n2 + "=" + this.myHeader.getIntValue("NAXIS" + n2, -1));
            ++n2;
        }
        System.out.println("      Data information:");
        try {
            if (this.myData.getData() == null) {
                System.out.println("        No Data");
            } else {
                System.out.println("         " + ArrayFuncs.arrayDescription(this.myData.getData()));
            }
        }
        catch (Exception exception) {
            System.out.println("      Unable to get data");
        }
    }
}

