/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.util.BoundMath;

public class ActivationGaussian
implements ActivationFunction {
    public static final int PARAM_GAUSSIAN_CENTER = 0;
    public static final int PARAM_GAUSSIAN_PEAK = 1;
    public static final int PARAM_GAUSSIAN_WIDTH = 2;
    private double[] params = new double[3];
    private static final long serialVersionUID = -7166136514935838114L;

    public ActivationGaussian(double d, double d2, double d3) {
        this.params[0] = d;
        this.params[1] = d2;
        this.params[2] = d3;
    }

    public ActivationFunction clone() {
        return new ActivationGaussian(this.getCenter(), this.getPeak(), this.getWidth());
    }

    private double getWidth() {
        return this.getParams()[2];
    }

    private double getCenter() {
        return this.getParams()[0];
    }

    private double getPeak() {
        return this.getParams()[1];
    }

    public boolean hasDerivative() {
        return true;
    }

    public void activationFunction(double[] dArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            dArray[i] = this.params[1] * BoundMath.exp(-Math.pow(dArray[i] - this.params[0], 2.0) / (2.0 * this.params[2] * this.params[2]));
        }
    }

    public double derivativeFunction(double d) {
        double d2 = this.params[2];
        double d3 = this.params[1];
        return Math.exp(-0.5 * d2 * d2 * d * d) * d3 * d2 * d2 * (d2 * d2 * d * d - 1.0);
    }

    public String[] getParamNames() {
        String[] stringArray = new String[]{"center", "peak", "width"};
        return stringArray;
    }

    public double[] getParams() {
        return this.params;
    }

    public void setParam(int n, double d) {
        this.params[n] = d;
    }

    public String getOpenCLExpression(boolean bl) {
        return null;
    }
}

