/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx.demo;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jdesktop.xswingx.JXSearchField;

public class ScreenShotter {
    private JXSearchField c;
    private String name = "searchfield";
    private String lnf = "";
    private String layout = "";
    private String directory = "";

    public ScreenShotter(JXSearchField sf) throws Exception {
        this.c = sf;
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.c.updateUI();
        this.lnf = "system";
        this.lnfSession();
        this.vistaSession();
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        this.c.updateUI();
        this.lnf = "metal";
        this.lnfSession();
        UIManager.setLookAndFeel(new MotifLookAndFeel());
        this.c.updateUI();
        this.lnf = "motif";
        this.lnfSession();
        UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
        this.c.updateUI();
        this.lnf = "plastic";
        this.lnfSession();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            this.c.updateUI();
            this.lnf = "plasticxp";
            this.lnfSession();
            this.vistaSession();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
    }

    private void vistaSession() {
        this.c.setText("rollover");
        this.c.getCancelButton().setIcon(this.c.getCancelButton().getRolloverIcon());
        this.shoot("clear_rollover");
        this.c.updateUI();
        this.c.getPopupButton().setIcon(this.c.getPopupButton().getRolloverIcon());
        this.shoot("popup_rollover");
        this.c.updateUI();
        this.c.setText("pressed");
        this.c.getCancelButton().setIcon(this.c.getCancelButton().getPressedIcon());
        this.shoot("clear_pressed");
        this.c.updateUI();
        this.c.getPopupButton().setIcon(this.c.getPopupButton().getPressedIcon());
        this.shoot("popup_pressed");
        this.c.updateUI();
        this.c.setText("rollover");
        this.c.setSearchMode(JXSearchField.SearchMode.REGULAR);
        this.c.getFindButton().setIcon(this.c.getFindButton().getRolloverIcon());
        this.shoot("search_rollover");
        this.c.updateUI();
        this.c.setText("pressed");
        this.c.setSearchMode(JXSearchField.SearchMode.REGULAR);
        this.c.getFindButton().setIcon(this.c.getFindButton().getPressedIcon());
        this.shoot("search_pressed");
        this.c.setSearchMode(JXSearchField.SearchMode.INSTANT);
    }

    private void lnfSession() {
        this.c.setLayoutStyle(JXSearchField.LayoutStyle.MAC);
        this.layout = "mac";
        this.layoutSession();
        this.c.setLayoutStyle(JXSearchField.LayoutStyle.VISTA);
        this.layout = "vista";
        this.layoutSession();
    }

    private void layoutSession() {
        this.c.setText(null);
        this.c.setFindPopupMenu(null);
        this.shoot();
        this.c.setText("searching");
        this.shoot("searching");
        this.c.setText(null);
        this.c.setFindPopupMenu(new JPopupMenu());
        this.shoot("popup");
    }

    private void shoot() {
        this.shoot("");
    }

    private void shoot(String postfix) {
        this.c.setSize(this.c.getPreferredSize());
        this.c.doLayout();
        BufferedImage bi = new BufferedImage(this.c.getSize().width, this.c.getSize().height, 1);
        this.c.paint(bi.getGraphics());
        try {
            File file = new File(this.directory + this.name + "_" + this.lnf + "_" + this.layout + "_" + postfix + ".png");
            ImageIO.write((RenderedImage)bi, "png", file);
            System.out.println("saved file: " + file.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JXSearchField sf = new JXSearchField("Search");
        sf.setColumns(10);
        try {
            new ScreenShotter(sf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

