/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx.demo;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.BuddySupport;
import org.jdesktop.xswingx.demo.BookmarkButton;
import org.jdesktop.xswingx.demo.CustomizePanel;
import org.jdesktop.xswingx.demo.InsetsFormatter;
import org.jdesktop.xswingx.demo.RssButton;
import org.jdesktop.xswingx.demo.SnapBackButton;
import org.jdesktop.xswingx.demo.TitledSeparator;

public class CustomizeBuddyField
extends CustomizePanel {
    private JPanel panel2;
    private TitledSeparator titledSeparator1;
    private JLabel label2;
    private JFormattedTextField txtOuterMargin;
    private JPanel panel3;
    private JRadioButton cbSnapBack;
    private JLabel toggleButton1;
    private JRadioButton cbRss;
    private JLabel label1;
    private JRadioButton cbCheckbox;
    private JCheckBox checkBox2;
    private JRadioButton cbGap;
    private JPanel panel1;
    private JButton btnAddLeft;
    private JButton btnAddRight;
    private JButton btnRemoveall;

    public CustomizeBuddyField() {
        this.initComponents();
    }

    public void setField(JTextComponent textComponent) {
        super.setField(textComponent);
        this.txtOuterMargin.setFormatterFactory(new DefaultFormatterFactory(new InsetsFormatter()));
        Insets outerMargin = BuddySupport.getOuterMargin((JTextField)textComponent);
        if (outerMargin == null) {
            outerMargin = new Insets(0, 0, 0, 0);
        }
        this.txtOuterMargin.setValue(outerMargin);
    }

    private Component getSelectedComponent() {
        if (this.cbCheckbox.isSelected()) {
            JCheckBox cb = new JCheckBox();
            cb.setMargin(new Insets(0, 0, 0, 0));
            cb.setOpaque(false);
            cb.setCursor(Cursor.getDefaultCursor());
            return cb;
        }
        if (this.cbRss.isSelected()) {
            return new RssButton();
        }
        if (this.cbSnapBack.isSelected()) {
            return new SnapBackButton();
        }
        if (this.cbGap.isSelected()) {
            return BuddySupport.createGap(3);
        }
        return new BookmarkButton();
    }

    private void btnAddLeftActionPerformed(ActionEvent e) {
        BuddySupport.addLeft(this.getSelectedComponent(), this.getTextField());
        this.changed();
    }

    private void btnAddRightActionPerformed(ActionEvent e) {
        BuddySupport.addRight(this.getSelectedComponent(), this.getTextField());
        this.changed();
    }

    private void btnRemoveallActionPerformed(ActionEvent e) {
        BuddySupport.removeAll(this.getTextField());
        this.changed();
    }

    private void txtOuterMarginPropertyChange(PropertyChangeEvent e) {
        BuddySupport.setOuterMargin(this.getTextField(), (Insets)this.txtOuterMargin.getValue());
        this.changed();
    }

    private JTextField getTextField() {
        return (JTextField)this.getField();
    }

    private void initComponents() {
        this.panel2 = new JPanel();
        this.titledSeparator1 = new TitledSeparator();
        this.label2 = new JLabel();
        this.txtOuterMargin = new JFormattedTextField();
        this.panel3 = new JPanel();
        this.cbSnapBack = new JRadioButton();
        this.toggleButton1 = new JLabel();
        this.cbRss = new JRadioButton();
        this.label1 = new JLabel();
        this.cbCheckbox = new JRadioButton();
        this.checkBox2 = new JCheckBox();
        this.cbGap = new JRadioButton();
        this.panel1 = new JPanel();
        this.btnAddLeft = new JButton();
        this.btnAddRight = new JButton();
        this.btnRemoveall = new JButton();
        CellConstraints cc = new CellConstraints();
        this.panel2.setLayout(new BorderLayout());
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.titledSeparator1.setTitle("Buddies");
        this.add((Component)this.titledSeparator1, cc.xywh(1, 1, 4, 1));
        this.label2.setText("Outer Margin:");
        this.add((Component)this.label2, cc.xy(2, 3));
        this.txtOuterMargin.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                CustomizeBuddyField.this.txtOuterMarginPropertyChange(e);
            }
        });
        this.add((Component)this.txtOuterMargin, cc.xy(4, 3));
        this.panel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DLUX1, 0.0), FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DLUX1, 0.0), FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DLUX1, 0.0), FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.cbSnapBack.setSelected(true);
        this.panel3.add((Component)this.cbSnapBack, cc.xy(1, 1));
        this.toggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/jdesktop/xswingx/demo/Search_SnapBack.png")));
        this.panel3.add((Component)this.toggleButton1, cc.xy(3, 1));
        this.panel3.add((Component)this.cbRss, cc.xy(5, 1));
        this.label1.setIcon(new ImageIcon(this.getClass().getResource("/org/jdesktop/xswingx/demo/ShowRSSButton.png")));
        this.panel3.add((Component)this.label1, cc.xy(7, 1));
        this.panel3.add((Component)this.cbCheckbox, cc.xy(9, 1));
        this.panel3.add((Component)this.checkBox2, cc.xy(11, 1));
        this.cbGap.setText("Gap");
        this.panel3.add((Component)this.cbGap, cc.xy(13, 1));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")));
        this.btnAddLeft.setText("Add Left");
        this.btnAddLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizeBuddyField.this.btnAddLeftActionPerformed(e);
            }
        });
        this.panel1.add((Component)this.btnAddLeft, cc.xy(2, 1));
        this.btnAddRight.setText("Add Right");
        this.btnAddRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizeBuddyField.this.btnAddRightActionPerformed(e);
            }
        });
        this.panel1.add((Component)this.btnAddRight, cc.xy(4, 1));
        this.btnRemoveall.setText("Remove All");
        this.btnRemoveall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizeBuddyField.this.btnRemoveallActionPerformed(e);
            }
        });
        this.panel1.add((Component)this.btnRemoveall, cc.xywh(6, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT));
        this.panel3.add((Component)this.panel1, cc.xywh(1, 3, 13, 1));
        this.add((Component)this.panel3, cc.xywh(2, 5, 3, 1));
        this.panel2.add((Component)this, "Center");
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.cbSnapBack);
        buttonGroup1.add(this.cbRss);
        buttonGroup1.add(this.cbCheckbox);
        buttonGroup1.add(this.cbGap);
    }
}

