/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util;

import java.util.Calendar;

public class Times {
    public static final int SOLAR_YEAR = 1;
    public static final int WATER_YEAR = 2;
    public static final int CALENDAR_YEAR = 3;
    private static final long SERIAL_BASE_1900 = -2209050000000L;
    public static final long MILLISECS_PER_MINUTE = 60000L;
    public static final long MILLISECS_PER_HOUR = 3600000L;
    protected static final long MILLISECS_PER_DAY = 86400000L;
    public static final long EPOCH_UNIX_ERA_DAY = 2440588L;

    public static long getUnixDay(Calendar cal) {
        long offset = cal.get(15) + cal.get(16);
        long day = (long)Math.floor((double)(cal.getTime().getTime() + offset) / 8.64E7);
        return day;
    }

    public static long getJulianDay(Calendar cal) {
        return Times.getUnixDay(cal) + 2440588L;
    }

    public static long diffDayPeriods(Calendar start, Calendar end) {
        long endL = end.getTimeInMillis() + (long)end.getTimeZone().getOffset(end.getTimeInMillis());
        long startL = start.getTimeInMillis() + (long)start.getTimeZone().getOffset(start.getTimeInMillis());
        return (endL - startL) / 86400000L;
    }

    public static boolean isLeapYear(int year) {
        return year >= 1582 ? year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) : year % 4 == 0;
    }

    public static int getDayOfYear(Calendar cal, int type) {
        int jday = cal.get(6);
        int mo = cal.get(2) + 1;
        if (type == 3) {
            return jday;
        }
        if (type == 1) {
            int day = cal.get(5);
            return mo == 12 && day > 21 ? day - 21 : jday + 10;
        }
        if (type == 2) {
            return mo > 9 ? jday - (Times.isLeapYear(cal.get(1)) ? 274 : 273) : jday + 92;
        }
        throw new IllegalArgumentException("getDayOfYear() type argument unknown");
    }

    public static double toSerialDate(Calendar cal) {
        long calTime = cal.getTimeInMillis();
        return (double)(calTime - -2209050000000L) / 8.64E7 + 1.0;
    }

    public static void setSerialDate(Calendar cal, double serialDate) {
        cal.setTimeInMillis(-2209050000000L + (long)((serialDate - 1.0) * 8.64E7));
    }

    public static double deltaHours(int calUnit, int increments) {
        if (calUnit == 5) {
            return 24 * increments;
        }
        if (calUnit == 10) {
            return increments;
        }
        if (calUnit == 12) {
            return increments / 60;
        }
        if (calUnit == 13) {
            return increments / 3600;
        }
        return -1.0;
    }
}

