/*
 * Decompiled with CFR 0.152.
 */
package ngmf.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ngmf.io.CSProperties;
import ngmf.io.CSTable;
import ngmf.io.CSVParser;
import ngmf.io.CSVStrategy;

public class DataIO {
    private static final String P = "@";
    public static final String TABLE = "@T";
    public static final String HEADER = "@H";
    public static final String PROPERTIES = "@S";
    public static final String PROPERTY = "@P";
    public static final String KEY_UNIT = "Unit";
    public static final String KEY_TYPE = "Type";
    public static final String KEY_FORMAT = "Format";
    public static final String KEY_NAME = "Name";
    public static final String VAL_DATE = "Date";
    public static final String CSPROPERTIES_EXT = "csp";
    public static final String CSTABLE_EXT = "cst";
    private static final String ROOT_ANN = "___root___";
    private static final String COMMENT = "#";
    private static final Map<String, String> NOINFO = Collections.unmodifiableMap(new HashMap());
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^$}]+)\\}");
    private static final String ISO8601 = "yyyy-MM-dd'T'hh:mm:ss";

    public static double[] getColumnDoubleValues(CSTable t, String columnName) {
        ArrayList<Double> l = new ArrayList<Double>();
        int col = -1;
        for (int i = 0; i < t.getColumnCount(); ++i) {
            if (!t.getName(i).equals(columnName)) continue;
            col = i;
            break;
        }
        if (col == -1) {
            throw new IllegalArgumentException("No such column: " + columnName);
        }
        for (String[] s : t) {
            l.add(new Double(s[col]));
        }
        double[] arr = new double[l.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (Double)l.get(i);
        }
        return arr;
    }

    public static Date getDate(CSProperties p, String key) throws ParseException {
        String val = (String)p.get(key);
        if (val == null) {
            throw new IllegalArgumentException(key);
        }
        String f = p.getInfo(key).get("format");
        SimpleDateFormat fmt = new SimpleDateFormat(f == null ? ISO8601 : f);
        return fmt.parse(val);
    }

    public static int getInt(CSProperties p, String key) throws ParseException {
        String val = (String)p.get(key);
        if (val == null) {
            throw new IllegalArgumentException(key);
        }
        return Integer.parseInt(val);
    }

    public static void print(CSProperties props, PrintWriter out) {
        out.println("@S," + CSVParser.printLine(props.getName()));
        for (String key : props.getInfo().keySet()) {
            out.println(" " + CSVParser.printLine(key, props.getInfo().get(key)));
        }
        out.println();
        for (String key : props.keySet()) {
            out.println("@P," + CSVParser.printLine(key, (String)props.get(key)));
            for (String key1 : props.getInfo(key).keySet()) {
                out.println(" " + CSVParser.printLine(key1, props.getInfo(key).get(key1)));
            }
            out.println();
        }
        out.flush();
        out.println();
    }

    public static void print(CSTable table, PrintWriter out) {
        out.println("@T," + CSVParser.printLine(table.getName()));
        for (String key : table.getInfo().keySet()) {
            out.println(CSVParser.printLine(key, table.getInfo().get(key)));
        }
        out.print(HEADER);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            out.print("," + table.getName(i));
        }
        out.println();
        Map<String, String> m = table.getInfo(0);
        for (String key : m.keySet()) {
            out.print(key);
            for (int i = 0; i < table.getColumnCount(); ++i) {
                out.print("," + table.getInfo(i).get(key));
            }
            out.println();
        }
        for (String[] row : table) {
            out.println("," + CSVParser.printLine(row));
        }
        out.flush();
        out.println();
    }

    public static CSProperties properties(Reader r, String name) throws IOException {
        return new CSVProperties(r, name);
    }

    public static CSProperties properties(Reader[] r, String name) throws IOException {
        CSVProperties p = new CSVProperties(r[0], name);
        for (int i = 1; i < r.length; ++i) {
            CSVParser csv = new CSVParser(r[i], CSVStrategy.DEFAULT_STRATEGY);
            DataIO.locate(csv, name, PROPERTIES);
            p.readProps(csv);
            r[i].close();
        }
        return p;
    }

    public static Properties properties(CSProperties p) {
        Properties pr = new Properties();
        pr.putAll((Map<?, ?>)p);
        return pr;
    }

    public static CSProperties properties(Properties p) {
        return new BasicCSProperties(p);
    }

    public static CSProperties properties() {
        return new BasicCSProperties();
    }

    public static CSTable table(File r, String name) throws IOException {
        return new CSVTable(r, name);
    }

    private static String locate(CSVParser r, String name, String type) throws IOException {
        if (name == null) {
            name = ".*";
        }
        Pattern p = Pattern.compile(name);
        String[] line = null;
        while ((line = r.getLine()) != null) {
            if (line.length != 2 || line[0].startsWith(COMMENT) || !line[0].startsWith(P) || !line[0].equalsIgnoreCase(type) || !p.matcher(line[1]).matches()) continue;
            return line[1];
        }
        throw new IllegalArgumentException("Not found : " + type + ", " + name);
    }

    private static class CSVProperties
    extends LinkedHashMap<String, String>
    implements CSProperties {
        String name;
        Map<String, Map<String, String>> info;

        CSVProperties(Reader reader, String name) throws IOException {
            CSVParser csv = new CSVParser(reader, CSVStrategy.DEFAULT_STRATEGY);
            this.name = DataIO.locate(csv, name, DataIO.PROPERTIES);
            this.info = new HashMap<String, Map<String, String>>();
            this.readProps(csv);
            reader.close();
        }

        void readProps(CSVParser csv) throws IOException {
            HashMap<String, String> propInfo = null;
            String[] line = null;
            String propKey = DataIO.ROOT_ANN;
            while ((line = csv.getLine()) != null && !line[0].equalsIgnoreCase(DataIO.PROPERTIES) && !line[0].equalsIgnoreCase(DataIO.TABLE)) {
                if (line[0].startsWith(DataIO.COMMENT) || line[0].isEmpty()) continue;
                if (line[0].equalsIgnoreCase(DataIO.PROPERTY)) {
                    if (line.length < 2) {
                        throw new IOException("Expected property name in line " + csv.getLineNumber());
                    }
                    propKey = line[1];
                    this.put(propKey, line.length == 3 ? line[2] : null);
                    propInfo = null;
                    continue;
                }
                if (propInfo == null) {
                    propInfo = new HashMap<String, String>();
                    this.info.put(propKey, propInfo);
                }
                propInfo.put(line[0], line.length > 1 ? line[1] : null);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getInfo(String property) {
            Map<String, String> im = this.info.get(property);
            return im == null ? NOINFO : Collections.unmodifiableMap(im);
        }

        @Override
        public Map<String, String> getInfo() {
            return this.getInfo(DataIO.ROOT_ANN);
        }

        @Override
        public String get(Object key) {
            String val = (String)super.get(key);
            return this.resolve(val);
        }

        private String resolve(String str) {
            if (str != null && str.contains("${")) {
                Matcher ma = null;
                while ((ma = varPattern.matcher(str)).find()) {
                    String key = ma.group(1);
                    String val = this.get(key);
                    if (val == null) {
                        throw new IllegalArgumentException("value substitution failed for " + key);
                    }
                    Pattern repl = Pattern.compile("\\$\\{" + key + "\\}");
                    str = repl.matcher(str).replaceAll(val);
                }
            }
            return str;
        }
    }

    private static class CSVTable
    implements CSTable {
        Map<Integer, Map<String, String>> info;
        String name;
        int colCount;
        int firstLine;
        String[] columnNames;
        File file;

        private CSVTable(File file, String name) throws IOException {
            FileReader r = new FileReader(file);
            CSVParser csv = new CSVParser(r, CSVStrategy.DEFAULT_STRATEGY);
            this.name = DataIO.locate(csv, name, DataIO.TABLE);
            this.info = new HashMap<Integer, Map<String, String>>();
            this.firstLine = this.readTableHeader(csv);
            ((Reader)r).close();
            this.file = file;
        }

        @Override
        public Iterator<String[]> iterator() {
            try {
                final BufferedReader r = new BufferedReader(new FileReader(this.file));
                while (this.firstLine-- > 0) {
                    r.readLine();
                }
                final CSVParser p = new CSVParser(r, CSVStrategy.DEFAULT_STRATEGY);
                return new Iterator<String[]>(){
                    String[] line = this.readLine();

                    private String[] readLine() {
                        try {
                            return p.getLine();
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.line != null && this.line.length > 1 && this.line[0].isEmpty();
                    }

                    @Override
                    public String[] next() {
                        String[] s = this.line;
                        this.line = this.readLine();
                        return Arrays.copyOfRange(s, 1, s.length);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void finalize() throws Throwable {
                        try {
                            r.close();
                        }
                        finally {
                            super.finalize();
                        }
                    }
                };
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private int readTableHeader(CSVParser csv) throws IOException {
            int i;
            LinkedHashMap<String, String> tableInfo = new LinkedHashMap<String, String>();
            this.info.put(-1, tableInfo);
            String[] line = null;
            while ((line = csv.getLine()) != null && !line[0].equalsIgnoreCase(DataIO.HEADER)) {
                if (line[0].startsWith(DataIO.COMMENT)) continue;
                tableInfo.put(line[0], line.length > 1 ? line[1] : null);
            }
            if (line == null) {
                throw new IOException("Invalid table structure.");
            }
            this.colCount = line.length - 1;
            this.columnNames = new String[this.colCount];
            for (i = 1; i < line.length; ++i) {
                this.columnNames[i - 1] = line[i];
                this.info.put(i - 1, new LinkedHashMap());
            }
            while ((line = csv.getLine()) != null && !line[0].isEmpty()) {
                if (line[0].startsWith(DataIO.COMMENT)) continue;
                for (i = 1; i < line.length; ++i) {
                    this.info.get(i - 1).put(line[0], line[i]);
                }
            }
            assert (line != null && line[0].isEmpty());
            return csv.getLineNumber() - 1;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getInfo() {
            return this.getInfo(-1);
        }

        @Override
        public Map<String, String> getInfo(int column) {
            return Collections.unmodifiableMap(this.info.get(column));
        }

        @Override
        public int getColumnCount() {
            return this.colCount;
        }

        @Override
        public String getName(int column) {
            return this.columnNames[column];
        }
    }

    private static class BasicCSProperties
    extends LinkedHashMap<String, String>
    implements CSProperties {
        BasicCSProperties(Properties p) {
            for (Object key : p.keySet()) {
                this.put(key.toString(), p.getProperty(key.toString()));
            }
        }

        BasicCSProperties() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public Map<String, String> getInfo() {
            return NOINFO;
        }

        @Override
        public Map<String, String> getInfo(String propertyName) {
            return NOINFO;
        }
    }
}

