/*
 * Decompiled with CFR 0.152.
 */
package ngmf;

public class FieldContent {
    static final int NONE = 0;
    static final int IN = 1;
    static final int OUT = 2;
    static final int LEAF = 4;
    static final int IO = 3;
    static final int LEAF_IN = 5;
    static final int LEAF_OUT = 6;
    private int access = 0;
    private Object value;

    FieldContent() {
    }

    public FieldContent(Object value) {
        this.value = value;
    }

    void invalidate() {
        if (this.access != 5) {
            this.value = null;
        }
    }

    synchronized void setValue(Object value) {
        this.value = value;
        this.notifyAll();
    }

    synchronized Object getValue() {
        while (this.value == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.value;
    }

    void tagIn() {
        this.access |= 1;
    }

    void tagOut() {
        this.access |= 2;
    }

    void tagLeaf() {
        this.access |= 4;
    }

    int access() {
        return this.access;
    }

    boolean isValid() {
        return this.access == 3 || this.access == 5 || this.access == 2;
    }
}

