/*
 * Decompiled with CFR 0.152.
 */
package ngmf;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ngmf.ComponentAccess;
import ngmf.FieldAccess;
import ngmf.FieldContent;
import ngmf.Notification;

public class Controller {
    Notification ens = new Notification(this);
    Set<FieldContent> dataSet = new HashSet<FieldContent>();
    Map<Object, ComponentAccess> oMap = new HashMap<Object, ComponentAccess>();
    ComponentAccess ca;

    Controller(Object compound) {
        this.ca = new ComponentAccess(compound, this.ens);
    }

    private ComponentAccess lookup(Object cmd) {
        assert (cmd != null);
        if (cmd == this.ca.getComponent()) {
            throw new IllegalArgumentException("Cannot add the compound to itself. Create and add an inner class instead.");
        }
        ComponentAccess w = this.oMap.get(cmd);
        if (w == null) {
            w = new ComponentAccess(cmd, this.ens);
            this.oMap.put(cmd, w);
        }
        return w;
    }

    void mapOut(String outfield, Object dest, String in) {
        ComponentAccess ac_dest = this.lookup(dest);
        FieldAccess destAccess = ac_dest.output(in);
        FieldAccess srcAccess = this.ca.output(outfield);
        FieldContent data = srcAccess.getData();
        data.tagLeaf();
        data.tagOut();
        this.dataSet.add(data);
        destAccess.setData(data);
    }

    void mapIn(String infield, Object dest, String in) {
        ComponentAccess ac_dest = this.lookup(dest);
        FieldAccess destAccess = ac_dest.input(in);
        FieldAccess srcAccess = this.ca.input(infield);
        FieldContent data = srcAccess.getData();
        data.tagLeaf();
        data.tagIn();
        this.dataSet.add(data);
        destAccess.setData(data);
    }

    void connect(Object src, String out, Object dest, String in) {
        FieldAccess destAccess;
        if (src == dest) {
            throw new IllegalArgumentException("src == dest Command.");
        }
        if (in == null || out == null) {
            throw new IllegalArgumentException("Some field arguments are null");
        }
        ComponentAccess ac_src = this.lookup(src);
        ComponentAccess ac_dest = this.lookup(dest);
        FieldAccess srcAccess = ac_src.output(out);
        if (!srcAccess.canConnect(destAccess = ac_dest.input(in))) {
            throw new IllegalArgumentException("Type/Access mismatch, Cannot connect: " + in + " -> " + out);
        }
        FieldContent data = srcAccess.getData();
        data.tagIn();
        data.tagOut();
        this.dataSet.add(data);
        destAccess.setData(data);
    }

    void sanityCheck() {
        for (FieldAccess in : this.ca.inputs()) {
            if (in.getData().isValid()) continue;
            throw new IllegalStateException("Invalid Access " + in + " -> " + in.getData().access());
        }
        for (ComponentAccess w : this.oMap.values()) {
            for (FieldAccess in : w.inputs()) {
                if (in.getData().isValid()) continue;
                throw new IllegalStateException("Invalid Access " + in + " -> " + in.getData().access());
            }
        }
    }

    void internalExec() throws Exception {
        Collection<ComponentAccess> cmds = this.oMap.values();
        if (cmds.size() == 0) {
            return;
        }
        for (FieldAccess a : this.ca.inputs()) {
            a.out();
        }
        for (FieldContent dataRef : this.dataSet) {
            dataRef.invalidate();
        }
        this.ens.fireStart(this.ca);
        final CountDownLatch latch = new CountDownLatch(cmds.size());
        final ExecutorService e = Executors.newFixedThreadPool(cmds.size() + 1);
        for (final ComponentAccess c : cmds) {
            e.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.exec();
                    }
                    catch (Throwable E) {
                        try {
                            Controller.this.ens.fireException(E, c);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        E.printStackTrace();
                        e.shutdownNow();
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException E) {
            throw new RuntimeException(E);
        }
        finally {
            e.shutdown();
        }
        this.ens.fireFinnish(this.ca);
        for (FieldAccess a : this.ca.outputs()) {
            a.in();
        }
    }

    public Collection<FieldContent> getData() {
        return Collections.unmodifiableCollection(this.dataSet);
    }

    public Collection<Object> getComponents() {
        return Collections.unmodifiableCollection(this.oMap.keySet());
    }

    public void addListener(Notification.Listener l) {
        this.ens.addListener(l);
    }

    public void callAnnotated(Class<? extends Annotation> ann, boolean lazy) {
        for (ComponentAccess p : this.oMap.values()) {
            p.callAnnotatedMethod(ann, lazy);
        }
    }

    public void removeListerer(Notification.Listener l) {
        this.ens.removeListener(l);
    }
}

