/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.xml;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.util.xml.XMLParserNotification;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractXMLEventParser
implements XMLEventParser {
    protected static final String CHARACTERS_CONTENT = "CharactersContent";
    protected final String namespaceURI;
    protected AVList fields;
    protected XMLEventParser parent;

    public AbstractXMLEventParser() {
        this.namespaceURI = null;
    }

    public AbstractXMLEventParser(String string) {
        this.namespaceURI = string;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public XMLEventParser newInstance() throws Exception {
        Constructor<? extends AbstractXMLEventParser> constructor = this.getAConstructor(String.class);
        if (constructor != null) {
            return constructor.newInstance(this.getNamespaceURI());
        }
        constructor = this.getAConstructor(new Class[0]);
        if (constructor != null) {
            return constructor.newInstance(new Object[0]);
        }
        return null;
    }

    public void setField(QName qName, Object object) {
        this.setField(qName.getLocalPart(), object);
    }

    public void setField(String string, Object object) {
        if (this.fields == null) {
            this.fields = new AVListImpl();
        }
        this.fields.setValue(string, object);
    }

    public void setFields(Map<String, Object> map) {
        if (this.fields == null) {
            this.fields = new AVListImpl();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.setField(entry.getKey(), entry.getValue());
        }
    }

    public Object getField(QName qName) {
        return this.fields != null ? this.getField(qName.getLocalPart()) : null;
    }

    public Object getField(String string) {
        return this.fields != null ? this.fields.getValue(string) : null;
    }

    public boolean hasField(QName qName) {
        return this.hasField(qName.getLocalPart());
    }

    public boolean hasField(String string) {
        return this.fields != null && this.fields.hasKey(string);
    }

    public void removeField(String string) {
        if (this.fields != null) {
            this.fields.removeKey(string);
        }
    }

    public boolean hasFields() {
        return this.fields != null;
    }

    public AVList getFields() {
        return this.fields;
    }

    protected AbstractXMLEventParser mergeFields(AbstractXMLEventParser abstractXMLEventParser, AbstractXMLEventParser abstractXMLEventParser2) {
        for (Map.Entry<String, Object> entry : abstractXMLEventParser2.getFields().getEntries()) {
            if (abstractXMLEventParser.hasField(entry.getKey())) continue;
            abstractXMLEventParser.setField(entry.getKey(), entry.getValue());
        }
        return this;
    }

    protected AbstractXMLEventParser overrideFields(AbstractXMLEventParser abstractXMLEventParser, AbstractXMLEventParser abstractXMLEventParser2) {
        if (abstractXMLEventParser2.getFields() != null) {
            for (Map.Entry<String, Object> entry : abstractXMLEventParser2.getFields().getEntries()) {
                abstractXMLEventParser.setField(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public XMLEventParser getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XMLEventParser xMLEventParser) {
        this.parent = xMLEventParser;
    }

    @Override
    public void freeResources() {
    }

    protected Constructor<? extends AbstractXMLEventParser> getAConstructor(Class ... classArray) {
        try {
            return this.getClass().getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public XMLEventParser getRoot() {
        XMLEventParser xMLEventParser = this;
        XMLEventParser xMLEventParser2;
        while ((xMLEventParser2 = xMLEventParser.getParent()) != null) {
            xMLEventParser = xMLEventParser2;
        }
        return xMLEventParser;
    }

    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        if (xMLEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XMLEventParser xMLEventParser = xMLEventParserContext.allocate(xMLEvent);
        if (xMLEventParser != null) {
            xMLEventParser.setParent(this);
        }
        return xMLEventParser;
    }

    @Override
    public Object parse(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        if (xMLEventParserContext == null) {
            String string = Logging.getMessage("nullValue.ParserContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (xMLEvent == null) {
            String string = Logging.getMessage("nullValue.EventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            this.doParseEventAttributes(xMLEventParserContext, xMLEvent, objectArray);
            object = (String)this.getField("id");
            if (object != null) {
                xMLEventParserContext.addId((String)object, this);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            xMLEventParserContext.firePropertyChange(new XMLParserNotification(xMLEventParserContext, "gov.nasa.worldwind.util.xml.XMLParserNotification.Exception", xMLEvent, "XML.ExceptionParsingElement", null, xMLStreamException));
        }
        object = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (object != null) {
                if (xMLEventParserContext.isEndElement((XMLEvent)object, xMLEvent)) {
                    if (this.hasField(CHARACTERS_CONTENT)) {
                        StringBuilder stringBuilder = (StringBuilder)this.getField(CHARACTERS_CONTENT);
                        if (stringBuilder != null && stringBuilder.length() > 0) {
                            this.setField(CHARACTERS_CONTENT, (Object)stringBuilder.toString());
                        } else {
                            this.removeField(CHARACTERS_CONTENT);
                        }
                    }
                    return this;
                }
                try {
                    if (object.isCharacters()) {
                        this.doAddCharacters(xMLEventParserContext, (XMLEvent)object, objectArray);
                    } else {
                        this.doParseEventContent(xMLEventParserContext, (XMLEvent)object, objectArray);
                    }
                }
                catch (XMLStreamException xMLStreamException) {
                    xMLEventParserContext.firePropertyChange(new XMLParserNotification(xMLEventParserContext, "gov.nasa.worldwind.util.xml.XMLParserNotification.Exception", (XMLEvent)object, "XML.ExceptionParsingElement", null, xMLStreamException));
                }
            }
            object = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    protected void doAddCharacters(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        String string = xMLEventParserContext.getCharacters(xMLEvent);
        if (WWUtil.isEmpty(string)) {
            return;
        }
        StringBuilder stringBuilder = (StringBuilder)this.getField(CHARACTERS_CONTENT);
        if (stringBuilder != null) {
            stringBuilder.append(string);
        } else {
            this.setField(CHARACTERS_CONTENT, (Object)new StringBuilder(string));
        }
    }

    public String getCharacters() {
        return (String)this.getField(CHARACTERS_CONTENT);
    }

    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEvent.isStartElement()) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser == null) {
                xMLEventParserContext.firePropertyChange(new XMLParserNotification(xMLEventParserContext, "gov.nasa.worldwind.util.xml.XMLParserNotification.Unrecognized", xMLEvent, "XML.UnrecognizedElement", null, xMLEvent));
                xMLEventParser = xMLEventParserContext.getUnrecognizedElementParser();
                object = xMLEvent.asStartElement().getName();
                if (object != null) {
                    xMLEventParserContext.registerParser((QName)object, xMLEventParser);
                }
            }
            if (xMLEventParser != null) {
                object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray);
                if (object == null) {
                    return;
                }
                this.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
            }
        }
    }

    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        this.setField(xMLEvent.asStartElement().getName(), object);
    }

    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            this.doAddEventAttribute(iterator.next(), xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void doAddEventAttribute(Attribute attribute, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        this.setField(attribute.getName(), (Object)attribute.getValue());
    }

    protected String parseCharacterContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        StringBuilder stringBuilder = new StringBuilder();
        XMLEvent xMLEvent2 = xMLEventParserContext.nextEvent();
        while (xMLEvent2 != null) {
            String string;
            if (xMLEventParserContext.isEndElement(xMLEvent2, xMLEvent)) {
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
            if (xMLEvent2.isCharacters() && (string = xMLEventParserContext.getCharacters(xMLEvent2)) != null) {
                stringBuilder.append(string);
            }
            xMLEvent2 = xMLEventParserContext.nextEvent();
        }
        return null;
    }
}

