/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.webview;

import com.jogamp.opengl.util.texture.Texture;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.webview.AbstractWebView;
import gov.nasa.worldwind.util.webview.MacWebViewJNI;
import gov.nasa.worldwind.util.webview.WebResourceResolver;
import gov.nasa.worldwind.util.webview.WebViewTexture;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;

public class MacWebView
extends AbstractWebView {
    protected long webViewWindowPtr;

    public MacWebView(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.SizeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!Configuration.isMacOS()) {
            String string = Logging.getMessage("NativeLib.UnsupportedOperatingSystem", "Mac WebView", System.getProperty("os.name"));
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        this.frameSize = dimension;
        this.webViewWindowPtr = MacWebViewJNI.allocWebViewWindow(this.frameSize);
        MacWebViewJNI.setPropertyChangeListener(this.webViewWindowPtr, this);
    }

    @Override
    public void dispose() {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.releaseWebViewWindow(this.webViewWindowPtr);
            this.webViewWindowPtr = 0L;
        }
    }

    @Override
    public void setHTMLString(String string) {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.setHTMLString(this.webViewWindowPtr, string);
        }
    }

    @Override
    public void setHTMLString(String string, URL uRL) {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.setHTMLStringWithBaseURL(this.webViewWindowPtr, string, uRL);
        }
    }

    @Override
    public void setHTMLString(String string, WebResourceResolver webResourceResolver) {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.setHTMLStringWithResourceResolver(this.webViewWindowPtr, string, webResourceResolver);
        }
    }

    @Override
    protected void doSetFrameSize(Dimension dimension) {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.setFrameSize(this.webViewWindowPtr, dimension);
        }
    }

    @Override
    public Dimension getContentSize() {
        if (this.webViewWindowPtr != 0L) {
            return MacWebViewJNI.getContentSize(this.webViewWindowPtr);
        }
        return null;
    }

    @Override
    public Dimension getMinContentSize() {
        if (this.webViewWindowPtr != 0L) {
            return MacWebViewJNI.getMinContentSize(this.webViewWindowPtr);
        }
        return null;
    }

    @Override
    public void setMinContentSize(Dimension dimension) {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.setMinContentSize(this.webViewWindowPtr, dimension);
        }
    }

    @Override
    public URL getContentURL() {
        if (this.webViewWindowPtr != 0L) {
            return MacWebViewJNI.getContentURL(this.webViewWindowPtr);
        }
        return null;
    }

    @Override
    public Iterable<AVList> getLinks() {
        AVList[] aVListArray;
        if (this.webViewWindowPtr != 0L && (aVListArray = MacWebViewJNI.getLinks(this.webViewWindowPtr)) != null) {
            return Arrays.asList(aVListArray);
        }
        return Collections.emptyList();
    }

    @Override
    public void sendEvent(InputEvent inputEvent) {
        if (this.webViewWindowPtr != 0L && inputEvent != null) {
            MacWebViewJNI.sendEvent(this.webViewWindowPtr, inputEvent);
        }
    }

    @Override
    public void goBack() {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.goBack(this.webViewWindowPtr);
        }
    }

    @Override
    public void goForward() {
        if (this.webViewWindowPtr != 0L) {
            MacWebViewJNI.goForward(this.webViewWindowPtr);
        }
    }

    @Override
    public void setBackgroundColor(Color color) {
    }

    @Override
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    protected WWTexture createTextureRepresentation(DrawContext drawContext) {
        MacWebViewTexture macWebViewTexture = new MacWebViewTexture(this.getFrameSize(), false);
        macWebViewTexture.setUseAnisotropy(false);
        return macWebViewTexture;
    }

    protected class MacWebViewTexture
    extends WebViewTexture {
        protected boolean textureUpdateFailed;

        public MacWebViewTexture(Dimension dimension, boolean bl) {
            super(dimension, bl, true);
        }

        @Override
        protected void updateIfNeeded(DrawContext drawContext) {
            if (this.textureUpdateFailed) {
                return;
            }
            Texture texture = this.getTextureFromCache(drawContext);
            if (texture == null) {
                return;
            }
            try {
                this.displayInTexture(drawContext, texture);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("WebView.ExceptionUpdatingTexture"), exception);
                this.textureUpdateFailed = true;
            }
        }

        protected void displayInTexture(DrawContext drawContext, Texture texture) {
            long l = MacWebView.this.webViewWindowPtr;
            if (l == 0L) {
                return;
            }
            if (MacWebViewJNI.mustDisplayInTexture(l)) {
                MacWebViewJNI.displayInTexture(l, texture.getTarget());
            }
        }
    }
}

