/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import java.lang.reflect.Method;
import java.net.URL;

public class BrowserOpener {
    public static void browse(URL uRL) throws Exception {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            String string = uRL.toString();
            if (Configuration.isMacOS()) {
                BrowserOpener.browseMacOS(string);
            } else if (Configuration.isWindowsOS()) {
                BrowserOpener.browseWindows(string);
            } else if (Configuration.isUnixOS() || Configuration.isLinuxOS()) {
                BrowserOpener.browseUnix(string);
            }
        }
        catch (Exception exception) {
            throw new Exception(String.format("Cannot browse URL %s", uRL), exception);
        }
    }

    private static void browseMacOS(String string) throws Exception {
        Class<?> clazz = Class.forName("com.apple.eio.FileManager");
        Method method = clazz.getDeclaredMethod("openURL", String.class);
        method.invoke(null, string);
    }

    private static void browseWindows(String string) throws Exception {
        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
    }

    private static void browseUnix(String string) throws Exception {
        String[] stringArray;
        String string2 = null;
        for (String string3 : stringArray = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"}) {
            if (Runtime.getRuntime().exec(new String[]{"which", string3}).waitFor() != 0) continue;
            string2 = string3;
        }
        if (string2 == null) {
            throw new Exception("Cannot find browser");
        }
        Runtime.getRuntime().exec(new String[]{string2, string});
    }
}

