/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.event.MessageListener;
import gov.nasa.worldwind.ogc.kml.KMLRoot;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;

public class KMLController
extends WWObjectImpl
implements PreRenderable,
Renderable,
MessageListener {
    protected KMLRoot kmlRoot;
    protected KMLTraversalContext tc;

    public KMLController(KMLRoot kMLRoot) {
        this.setKmlRoot(kMLRoot);
        this.setTraversalContext(new KMLTraversalContext());
    }

    public KMLRoot getKmlRoot() {
        return this.kmlRoot;
    }

    public void setKmlRoot(KMLRoot kMLRoot) {
        KMLRoot kMLRoot2 = this.getKmlRoot();
        if (kMLRoot2 != null) {
            kMLRoot2.removePropertyChangeListener(this);
        }
        this.kmlRoot = kMLRoot;
        if (kMLRoot != null) {
            kMLRoot.addPropertyChangeListener(this);
        }
    }

    public void setTraversalContext(KMLTraversalContext kMLTraversalContext) {
        this.tc = kMLTraversalContext;
    }

    public KMLTraversalContext getTraversalContext() {
        return this.tc;
    }

    @Override
    public void preRender(DrawContext drawContext) {
        this.initializeTraversalContext(this.getTraversalContext());
        this.kmlRoot.preRender(this.getTraversalContext(), drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        this.initializeTraversalContext(this.getTraversalContext());
        this.kmlRoot.render(this.getTraversalContext(), drawContext);
    }

    protected void initializeTraversalContext(KMLTraversalContext kMLTraversalContext) {
        kMLTraversalContext.initialize();
        kMLTraversalContext.setDetailHint(this.kmlRoot.getDetailHint());
    }

    @Override
    public void onMessage(Message message) {
        if (this.kmlRoot != null) {
            this.kmlRoot.onMessage(message);
        }
    }
}

