/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLAbstractContainer
extends KMLAbstractFeature {
    protected ArrayList<KMLAbstractFeature> features = new ArrayList();

    protected KMLAbstractContainer(String string) {
        super(string);
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof KMLAbstractFeature) {
            this.addFeature((KMLAbstractFeature)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public List<KMLAbstractFeature> getFeatures() {
        return this.features;
    }

    public void addFeature(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature != null) {
            this.features.add(kMLAbstractFeature);
        }
    }

    public void removeFeature(KMLAbstractFeature kMLAbstractFeature) {
        if (kMLAbstractFeature != null) {
            this.getFeatures().remove(kMLAbstractFeature);
        }
    }

    @Override
    protected boolean isFeatureActive(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        return this.getVisibility() == null || this.getVisibility() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPreRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        this.beginRendering(kMLTraversalContext, drawContext);
        try {
            this.preRenderFeatures(kMLTraversalContext, drawContext);
        }
        finally {
            this.endRendering(kMLTraversalContext, drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        this.beginRendering(kMLTraversalContext, drawContext);
        try {
            this.renderBalloon(kMLTraversalContext, drawContext);
            this.renderFeatures(kMLTraversalContext, drawContext);
        }
        finally {
            this.endRendering(kMLTraversalContext, drawContext);
        }
    }

    protected void beginRendering(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getRegion() != null) {
            kMLTraversalContext.pushRegion(this.getRegion());
        }
    }

    protected void endRendering(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getRegion() != null) {
            kMLTraversalContext.popRegion();
        }
    }

    protected void preRenderFeatures(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        ArrayList<KMLAbstractFeature> arrayList = new ArrayList<KMLAbstractFeature>();
        for (KMLAbstractFeature kMLAbstractFeature : this.getFeatures()) {
            if (kMLAbstractFeature instanceof KMLAbstractContainer) {
                arrayList.add(kMLAbstractFeature);
                continue;
            }
            kMLAbstractFeature.preRender(kMLTraversalContext, drawContext);
        }
        for (KMLAbstractFeature kMLAbstractFeature : arrayList) {
            kMLAbstractFeature.preRender(kMLTraversalContext, drawContext);
        }
    }

    protected void renderFeatures(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        ArrayList<KMLAbstractFeature> arrayList = new ArrayList<KMLAbstractFeature>();
        for (KMLAbstractFeature kMLAbstractFeature : this.getFeatures()) {
            if (kMLAbstractFeature instanceof KMLAbstractContainer) {
                arrayList.add(kMLAbstractFeature);
                continue;
            }
            kMLAbstractFeature.render(kMLTraversalContext, drawContext);
        }
        for (KMLAbstractFeature kMLAbstractFeature : arrayList) {
            kMLAbstractFeature.render(kMLTraversalContext, drawContext);
        }
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLAbstractContainer)) {
            String string = Logging.getMessage("KML.InvalidElementType", kMLAbstractObject.getClass().getName());
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        super.applyChange(kMLAbstractObject);
        KMLAbstractContainer kMLAbstractContainer = (KMLAbstractContainer)kMLAbstractObject;
        if (kMLAbstractContainer.getFeatures() != null && kMLAbstractContainer.getFeatures().size() > 0) {
            this.mergeFeatures(kMLAbstractContainer);
        }
    }

    protected void mergeFeatures(KMLAbstractContainer kMLAbstractContainer) {
        ArrayList arrayList = new ArrayList(this.getFeatures().size());
        Collections.copy(arrayList, this.getFeatures());
        for (KMLAbstractFeature kMLAbstractFeature : kMLAbstractContainer.getFeatures()) {
            String string = kMLAbstractFeature.getId();
            if (!WWUtil.isEmpty(string)) {
                for (KMLAbstractFeature kMLAbstractFeature2 : arrayList) {
                    String string2 = kMLAbstractFeature2.getId();
                    if (WWUtil.isEmpty(string2) || !string2.equals(string)) continue;
                    this.getFeatures().remove(kMLAbstractFeature2);
                }
            }
            this.getFeatures().add(kMLAbstractFeature);
        }
    }

    @Override
    public void onMessage(Message message) {
        for (KMLAbstractFeature kMLAbstractFeature : this.getFeatures()) {
            kMLAbstractFeature.onMessage(message);
        }
        super.onMessage(message);
    }
}

