/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.DDSConstants;
import gov.nasa.worldwind.formats.dds.DDSPixelFormat;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class DDSHeader {
    protected final int size = 124;
    protected int flags;
    protected int width;
    protected int height;
    protected int linearSize;
    protected int depth;
    protected int mipMapCount;
    protected DDSPixelFormat pixelFormat = new DDSPixelFormat();
    protected int caps;
    protected int caps2;
    protected int caps3;
    protected int caps4;

    public final int getSize() {
        return this.size;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getLinearSize() {
        return this.linearSize;
    }

    public void setLinearSize(int n) {
        this.linearSize = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getMipMapCount() {
        return this.mipMapCount;
    }

    public void setMipMapCount(int n) {
        this.mipMapCount = n;
    }

    public DDSPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(DDSPixelFormat dDSPixelFormat) {
        if (dDSPixelFormat == null) {
            String string = Logging.getMessage("nullValue.PixelFormatIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pixelFormat = dDSPixelFormat;
    }

    public int getCaps() {
        return this.caps;
    }

    public void setCaps(int n) {
        this.caps = n;
    }

    public int getCaps2() {
        return this.caps2;
    }

    public void setCaps2(int n) {
        this.caps2 = n;
    }

    public int getCaps3() {
        return this.caps3;
    }

    public void setCaps3(int n) {
        this.caps3 = n;
    }

    public int getCaps4() {
        return this.caps4;
    }

    public void setCaps4(int n) {
        this.caps4 = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDSHeader readFrom(Object object) throws Exception {
        DDSHeader dDSHeader;
        block3: {
            boolean bl = null != object && object instanceof InputStream;
            InputStream inputStream = WWIO.openStream(object);
            ReadableByteChannel readableByteChannel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream));
            try {
                int n = 128;
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                WWIO.readChannelToBuffer(readableByteChannel, byteBuffer);
                dDSHeader = DDSHeader.readFrom(byteBuffer);
                if (bl) break block3;
                WWIO.closeStream(inputStream, null != object ? object.toString() : "unknown");
            }
            catch (Throwable throwable) {
                if (!bl) {
                    WWIO.closeStream(inputStream, null != object ? object.toString() : "unknown");
                }
                throw throwable;
            }
        }
        return dDSHeader;
    }

    public static DDSHeader readFrom(ByteBuffer byteBuffer) throws IllegalArgumentException, IOException {
        if (null == byteBuffer) {
            String string = Logging.getMessage("nullValue.BufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer.order() != ByteOrder.LITTLE_ENDIAN) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int n = 128;
        if (byteBuffer.remaining() < n) {
            String string = byteBuffer.remaining() + " < " + n;
            String string2 = Logging.getMessage("generic.LengthIsInvalid", string);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        int n2 = byteBuffer.getInt();
        if (DDSConstants.MAGIC != n2) {
            String string = Logging.getMessage("generic.UnknownFileFormat", n2);
            Logging.logger().fine(string);
            throw new IOException(string);
        }
        int n3 = byteBuffer.getInt();
        if (n3 != 124) {
            String string = Logging.getMessage("generic.UnknownContentType", n3);
            Logging.logger().fine(string);
            throw new IOException(string);
        }
        DDSHeader dDSHeader = new DDSHeader();
        dDSHeader.setFlags(byteBuffer.getInt());
        dDSHeader.setHeight(byteBuffer.getInt());
        dDSHeader.setWidth(byteBuffer.getInt());
        dDSHeader.setLinearSize(byteBuffer.getInt());
        dDSHeader.setDepth(byteBuffer.getInt());
        dDSHeader.setMipMapCount(byteBuffer.getInt());
        byteBuffer.position(76);
        DDSPixelFormat dDSPixelFormat = new DDSPixelFormat();
        n3 = byteBuffer.getInt();
        if (n3 != 32) {
            String string = Logging.getMessage("generic.UnknownContentType", n3);
            Logging.logger().fine(string);
            throw new IOException(string);
        }
        dDSPixelFormat.setFlags(byteBuffer.getInt());
        dDSPixelFormat.setFourCC(byteBuffer.getInt());
        dDSPixelFormat.setRGBBitCount(byteBuffer.getInt());
        dDSPixelFormat.setRBitMask(byteBuffer.getInt());
        dDSPixelFormat.setGBitMask(byteBuffer.getInt());
        dDSPixelFormat.setBBitMask(byteBuffer.getInt());
        dDSPixelFormat.setABitMask(byteBuffer.getInt());
        dDSHeader.setPixelFormat(dDSPixelFormat);
        dDSHeader.setCaps(byteBuffer.getInt());
        dDSHeader.setCaps2(byteBuffer.getInt());
        dDSHeader.setCaps3(byteBuffer.getInt());
        dDSHeader.setCaps4(byteBuffer.getInt());
        byteBuffer.getInt();
        return dDSHeader;
    }
}

