/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.csv;

import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class CSVWriter {
    private final PrintWriter printWriter;
    private int lineNumber = 0;

    public CSVWriter(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
    }

    public CSVWriter(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
    }

    public void writeTrack(Track track) {
        if (track == null) {
            String string = Logging.getMessage("nullValue.TrackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doWriteTrack(track, this.printWriter);
        this.doFlush();
    }

    public void close() {
        this.doFlush();
        this.printWriter.close();
    }

    private void doWriteTrack(Track track, PrintWriter printWriter) {
        if (track != null && track.getSegments() != null) {
            for (TrackSegment trackSegment : track.getSegments()) {
                this.doWriteTrackSegment(trackSegment, printWriter);
            }
        }
    }

    private void doWriteTrackSegment(TrackSegment trackSegment, PrintWriter printWriter) {
        if (trackSegment != null && trackSegment.getPoints() != null) {
            for (TrackPoint trackPoint : trackSegment.getPoints()) {
                this.doWriteTrackPoint(trackPoint, printWriter);
            }
        }
    }

    private void doWriteTrackPoint(TrackPoint trackPoint, PrintWriter printWriter) {
        if (trackPoint != null) {
            int n = this.lineNumber++;
            printWriter.print(n);
            printWriter.print(",");
            printWriter.print(trackPoint.getLatitude());
            printWriter.print(",");
            printWriter.print(trackPoint.getLongitude());
            printWriter.print(",");
            printWriter.print(trackPoint.getElevation());
            printWriter.print(",");
            printWriter.print(trackPoint.getTime() != null ? trackPoint.getTime() : "");
            printWriter.println();
        }
    }

    private void doFlush() {
        this.printWriter.flush();
    }
}

