/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.data.AbstractDataRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.GDAL;
import gov.nasa.worldwind.data.GDALMetadata;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.gdal.GDALUtils;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.Driver;
import org.gdal.gdal.MajorObject;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.osr.SpatialReference;

public class GDALDataRaster
extends AbstractDataRaster
implements Cacheable {
    protected Dataset dsVRT = null;
    protected SpatialReference srs;
    protected File srcFile = null;
    protected GDAL.Area area = null;
    protected final Object usageLock = new Object();
    protected static final int DEFAULT_MAX_RASTER_SIZE_LIMIT = 3072;

    protected static int getMaxRasterSizeLimit() {
        return 3072;
    }

    public GDALDataRaster(Object object) throws IllegalArgumentException, FileNotFoundException {
        this(object, false);
    }

    public GDALDataRaster(Object object, boolean bl) throws IllegalArgumentException, FileNotFoundException {
        Dataset dataset;
        File file = WWIO.getFileForLocalAddress(object);
        if (null == file) {
            String string = null != object ? Logging.getMessage("generic.UnrecognizedSourceType", object.getClass().getName()) : Logging.getMessage("nullValue.SourceIsNull");
            if (!bl) {
                Logging.logger().finest(string);
            }
            throw new IllegalArgumentException(string);
        }
        this.srcFile = file;
        String string = this.srcFile.getName();
        if (null != string && string.length() > 0) {
            this.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
            this.setValue("gov.nasa.worldwind.avkey.File", this.srcFile);
        }
        if ((dataset = GDALUtils.open(file, bl)) == null) {
            String string2 = GDALUtils.getErrorMessage();
            if (WWUtil.isEmpty(string2)) {
                string2 = Logging.getMessage("nullValue.DataSetIsNull");
            }
            if (!bl) {
                Logging.logger().severe(string2);
            }
            throw new IllegalArgumentException(string2);
        }
        this.init(dataset, bl);
    }

    public void setSector(Sector sector) throws IllegalArgumentException {
        double d;
        if (null == sector) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem") || "gov.nasa.worldwind.avkey.CoordinateSystem.Unknown".equals(this.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"))) {
            this.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
        }
        this.srs = GDALUtils.createGeographicSRS();
        this.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        this.area = new GDAL.Area(this.srs, sector);
        this.setValue("gov.nasa.worldwind.avkey.GDAL.Area", this.area);
        if (this.width > 0) {
            d = sector.getDeltaLonDegrees() / (double)this.width;
            this.setValue("gov.nasa.worldwind.avkey.PixelWidth", d);
        }
        if (this.height > 0) {
            d = sector.getDeltaLatDegrees() / (double)this.height;
            this.setValue("gov.nasa.worldwind.avkey.PixelWidth", d);
        }
        if (this.dsVRT != null) {
            String string;
            Driver driver;
            if (!"VRT".equalsIgnoreCase(this.dsVRT.GetDriver().getShortName()) && null != (driver = gdal.GetDriverByName("VRT"))) {
                this.dsVRT = driver.CreateCopy("", this.dsVRT);
            }
            double[] dArray = GDALUtils.calcGetGeoTransform(sector, this.width, this.height);
            this.dsVRT.SetGeoTransform(dArray);
            String string2 = GDALUtils.getErrorMessage();
            if (string2 != null) {
                string = Logging.getMessage("gdal.InternalError", string2);
                Logging.logger().severe(string);
            }
            if (null != this.srs) {
                this.dsVRT.SetProjection(this.srs.ExportToWkt());
            }
            if ((string2 = GDALUtils.getErrorMessage()) != null) {
                string = Logging.getMessage("gdal.InternalError", string2);
                Logging.logger().severe(string);
            }
            this.srs = this.readSpatialReference(this.dsVRT);
        }
    }

    protected SpatialReference readSpatialReference(Dataset dataset) {
        Object object;
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        String string = dataset.GetProjectionRef();
        if (null == string || 0 == string.length()) {
            string = dataset.GetProjection();
        }
        if ((null == string || 0 == string.length()) && null != this.srcFile) {
            object = WWIO.replaceSuffix(this.srcFile.getAbsolutePath(), ".prj");
            File file = new File((String)object);
            if (!file.exists() && Configuration.isUnixOS()) {
                object = WWIO.replaceSuffix(this.srcFile.getAbsolutePath(), ".PRJ");
                file = new File((String)object);
            }
            try {
                if (file.exists()) {
                    string = WWIO.readTextFile(file);
                }
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.UnknownProjection", string);
                Logging.logger().severe(string2);
            }
        }
        object = null;
        if (!WWUtil.isEmpty(string)) {
            object = new SpatialReference(string);
        }
        if ((null == object || ((SpatialReference)object).IsLocal() == 1) && this.hasKey("gov.nasa.worldwind.avkey.SpatialReference.WKT")) {
            string = this.getStringValue("gov.nasa.worldwind.avkey.SpatialReference.WKT");
            object = new SpatialReference(string);
        }
        return object;
    }

    public GDALDataRaster(Dataset dataset) throws IllegalArgumentException {
        if (null == dataset) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(dataset, false);
    }

    protected void init(Dataset dataset, boolean bl) {
        String string = null;
        AVListImpl aVListImpl = new AVListImpl();
        AVListImpl aVListImpl2 = new AVListImpl();
        GDALMetadata.extractExtendedAndFormatSpecificMetadata(dataset, aVListImpl, aVListImpl2);
        this.setValues(aVListImpl2);
        this.srs = this.readSpatialReference(dataset);
        if (null != this.srs) {
            string = this.srs.ExportToWkt();
            this.setValue("gov.nasa.worldwind.avkey.SpatialReference.WKT", this.srs.ExportToWkt());
        }
        GDALUtils.extractRasterParameters(dataset, this, bl);
        this.dsVRT = dataset;
        this.width = (Integer)this.getValue("gov.nasa.worldwind.avkey.Width");
        this.height = (Integer)this.getValue("gov.nasa.worldwind.avkey.Height");
        Object object = this.getValue("gov.nasa.worldwind.avkey.GDAL.Area");
        this.area = object != null && object instanceof GDAL.Area ? (GDAL.Area)object : null;
        String string2 = dataset.GetProjectionRef();
        String string3 = string2 = null == string2 || 0 == string2.length() ? dataset.GetProjection() : string2;
        if (!(null != string2 && 0 != string2.length() || string != null && 0 != string.length() || !"gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(this.getValue("gov.nasa.worldwind.avkey.CoordinateSystem")))) {
            this.srs = GDALUtils.createGeographicSRS();
            string = this.srs.ExportToWkt();
            this.setValue("gov.nasa.worldwind.avkey.SpatialReference.WKT", this.srs.ExportToWkt());
        }
        if ((null == string2 || 0 == string2.length()) && null != string && 0 < string.length()) {
            try {
                Driver driver = gdal.GetDriverByName("VRT");
                if (null == driver) {
                    String string4 = Logging.getMessage("gdal.InternalError", GDALUtils.getErrorMessage());
                    Logging.logger().severe(string4);
                    throw new WWRuntimeException(string4);
                }
                Dataset dataset2 = driver.CreateCopy("", dataset);
                dataset2.SetProjection(string);
                this.dsVRT = dataset2;
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
    }

    public AVList getMetadata() {
        return this.copy();
    }

    @Override
    public void drawOnTo(DataRaster dataRaster) {
        if (dataRaster == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doDrawOnTo(dataRaster);
    }

    protected void doDrawOnTo(DataRaster dataRaster) {
        try {
            Sector sector = this.getSector();
            Sector sector2 = dataRaster.getSector();
            Sector sector3 = null;
            if (null == sector || null == sector2 || !this.intersects(sector2) || null == (sector3 = sector.intersection(sector2))) {
                String string = Logging.getMessage("generic.SectorRequestedOutsideCoverageArea", sector2, sector);
                Logging.logger().finest(string);
                return;
            }
            Rectangle rectangle = this.computeClipRect(sector3, dataRaster);
            if (null == rectangle || rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            AVList aVList = dataRaster.copy();
            String[] stringArray = new String[]{"gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.MissingDataFlag", "gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.ElevationUnit"};
            WWUtil.copyValues(this, aVList, stringArray, false);
            DataRaster dataRaster2 = this.doGetSubRaster(rectangle.width, rectangle.height, sector3, aVList);
            dataRaster2.drawOnTo(dataRaster);
        }
        catch (WWRuntimeException wWRuntimeException) {
            Logging.logger().severe(wWRuntimeException.getMessage());
        }
        catch (Exception exception) {
            String string = this.composeExceptionReason(exception);
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    protected String composeExceptionReason(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != throwable.getMessage()) {
            stringBuilder.append(throwable.getMessage());
        } else if (null != throwable.getCause()) {
            stringBuilder.append(throwable.getCause().getMessage());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" : ");
        }
        if (null != this.srcFile) {
            stringBuilder.append(this.srcFile);
        }
        return stringBuilder.toString();
    }

    @Override
    public void dispose() {
        if (this.dsVRT != null) {
            this.dsVRT.delete();
            this.dsVRT = null;
        }
        this.clearList();
        if (this.srcFile != null) {
            this.srcFile = null;
        }
        this.srs = null;
    }

    protected Dataset createMaskDataset(int n, int n2, Sector sector) {
        if (n <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Driver driver = gdal.GetDriverByName("MEM");
        Dataset dataset = driver.Create("roi-mask", n, n2, 1, gdalconst.GDT_UInt32);
        Band band = dataset.GetRasterBand(1);
        band.SetColorInterpretation(gdalconst.GCI_AlphaBand);
        double d = GDALUtils.ALPHA_MASK;
        band.SetNoDataValue(d);
        band.Fill(d);
        if (null != sector) {
            SpatialReference spatialReference = GDALUtils.createGeographicSRS();
            String string = spatialReference.ExportToWkt();
            dataset.SetProjection(string);
            dataset.SetGeoTransform(GDALUtils.calcGetGeoTransform(sector, n, n2));
        }
        return dataset;
    }

    protected Dataset getBestSuitedDataset(int n, int n2, Sector sector) {
        MajorObject majorObject;
        int n3;
        if (n <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == this.dsVRT) {
            String string = Logging.getMessage("nullValue.DataSetIsNull");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        if (null == this.area) {
            return this.dsVRT;
        }
        Sector sector2 = this.getSector();
        if (!this.intersects(sector)) {
            String string = Logging.getMessage("generic.SectorRequestedOutsideCoverageArea", sector, sector2);
            Logging.logger().finest(string);
            throw new WWRuntimeException(string);
        }
        Object object = this.getValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (null == object || !"gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(object) && !"gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(object)) {
            String string = null == object ? "generic.UnspecifiedCoordinateSystem" : "generic.UnsupportedCoordinateSystem";
            String string2 = Logging.getMessage(string, object);
            Logging.logger().finest(Logging.getMessage("generic.CannotCreateRaster", string2));
            return this.dsVRT;
        }
        double d = Math.abs(sector.getDeltaLonDegrees() / (double)n);
        double d2 = Math.abs(sector.getDeltaLatDegrees() / (double)n2);
        int n4 = this.dsVRT.getRasterCount();
        if (n4 == 0) {
            return this.dsVRT;
        }
        Band band = this.dsVRT.GetRasterBand(1);
        if (null == band) {
            return this.dsVRT;
        }
        double[] dArray = new double[6];
        this.dsVRT.GetGeoTransform(dArray);
        boolean bl = dArray[2] == 0.0 && dArray[4] == 0.0;
        int n5 = -1;
        int n6 = this.getHeight();
        int n7 = this.getWidth();
        for (n3 = 0; n3 < band.GetOverviewCount(); ++n3) {
            majorObject = band.GetOverview(n3);
            if (null == majorObject) continue;
            int n8 = majorObject.getXSize();
            int n9 = majorObject.getYSize();
            if (0 == n9 || 0 == n8) continue;
            double d3 = Math.abs(sector2.getDeltaLatDegrees() / (double)n9);
            if (!(d3 <= d2)) break;
            n5 = n3;
            n7 = n8;
            n6 = n9;
        }
        if (!bl) {
            if (n5 == -1) {
                n6 = this.getHeight();
                n7 = this.getWidth();
                n3 = 0;
                while (true) {
                    double d4 = Math.pow(2.0, n3);
                    double d5 = Math.floor((double)this.getHeight() / d4);
                    double d6 = Math.floor((double)this.getWidth() / d4);
                    double d7 = Math.abs(sector2.getDeltaLonDegrees() / d6);
                    double d8 = Math.abs(sector2.getDeltaLatDegrees() / d5);
                    if (!(d8 <= d2) || !(d7 <= d)) break;
                    n7 = (int)d6;
                    n6 = (int)d5;
                    ++n3;
                }
            }
            if (n6 > GDALDataRaster.getMaxRasterSizeLimit() || n7 > GDALDataRaster.getMaxRasterSizeLimit()) {
                return this.dsVRT;
            }
            String string = Logging.getMessage("gdal.UseOverviewRaster", n7, n6, n, n2);
            Logging.logger().finest(string);
            majorObject = this.buildNonNorthUpDatasetFromOverview(n5, n7, n6);
            return null != majorObject ? majorObject : this.dsVRT;
        }
        if (n5 == -1) {
            n7 = this.getWidth();
            n6 = this.getHeight();
        } else {
            String string = Logging.getMessage("gdal.UseOverviewRaster", n7, n6, n, n2);
            Logging.logger().finest(string);
        }
        return this.buildNorthUpDatasetFromOverview(sector, n, n2, n5, n7, n6);
    }

    protected Dataset buildNorthUpDatasetFromOverview(Sector sector, int n, int n2, int n3, int n4, int n5) {
        GDAL.Area area = this.area.intersection(new GDAL.Area(this.srs, sector).getBoundingArea());
        if (null == area) {
            String string = Logging.getMessage("generic.SectorRequestedOutsideCoverageArea", sector, this.area);
            Logging.logger().finest(string);
            throw new WWRuntimeException(string);
        }
        AffineTransform affineTransform = this.area.computeGeoToRasterTransform(n4, n5);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        ((Point2D)double_).setLocation(area.getMinX(), area.getMaxY());
        affineTransform.transform(double_, double_2);
        ((Point2D)double_).setLocation(area.getMaxX(), area.getMinY());
        affineTransform.transform(double_, double_3);
        int n6 = (int)Math.floor(((Point2D)double_2).getX());
        int n7 = (int)Math.floor(((Point2D)double_2).getY());
        int n8 = (int)Math.floor(((Point2D)double_3).getX() - ((Point2D)double_2).getX());
        int n9 = (int)Math.floor(((Point2D)double_3).getY() - ((Point2D)double_2).getY());
        n8 = n8 > n4 ? n4 : n8;
        n9 = n9 > n5 ? n5 : n9;
        Driver driver = gdal.GetDriverByName("MEM");
        if (null == driver) {
            return this.dsVRT;
        }
        int n10 = this.dsVRT.getRasterCount();
        if (n10 == 0) {
            return this.dsVRT;
        }
        Band band = this.dsVRT.GetRasterBand(1);
        if (null == band) {
            return this.dsVRT;
        }
        int n11 = band.GetRasterDataType();
        Dataset dataset = driver.Create("cropped", n, n2, n10, n11);
        if (this.srs != null) {
            dataset.SetProjection(this.srs.ExportToWkt());
        }
        double[] dArray = new double[6];
        dArray[0] = area.getMinX();
        dArray[3] = area.getMaxY();
        dArray[1] = Math.abs((area.getMaxX() - area.getMinX()) / (double)n);
        dArray[5] = -Math.abs((area.getMaxY() - area.getMinY()) / (double)n2);
        dArray[4] = 0.0;
        dArray[2] = 0.0;
        dataset.SetGeoTransform(dArray);
        int n12 = n * n2 * (gdal.GetDataTypeSize(n11) / 8);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n12);
        byteBuffer.order(ByteOrder.nativeOrder());
        Double d = this.hasKey("gov.nasa.worldwind.avkey.MissingDataFlag") ? (Double)this.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") : null;
        for (int i = 0; i < n10; ++i) {
            Band band2;
            Band band3 = this.dsVRT.GetRasterBand(i + 1);
            if (null == band3) continue;
            Band band4 = band2 = n3 == -1 ? band3 : band3.GetOverview(n3);
            if (null == band2) continue;
            Band band5 = dataset.GetRasterBand(i + 1);
            if (null != d) {
                band5.SetNoDataValue(d);
            }
            int n13 = band3.GetColorInterpretation();
            band5.SetColorInterpretation(n13);
            if (n13 == gdalconst.GCI_PaletteIndex) {
                band5.SetColorTable(band3.GetColorTable());
            }
            byteBuffer.rewind();
            band2.ReadRaster_Direct(n6, n7, n8, n9, n, n2, n11, byteBuffer);
            byteBuffer.rewind();
            band5.WriteRaster_Direct(0, 0, n, n2, n11, byteBuffer);
        }
        return dataset;
    }

    protected Dataset buildNonNorthUpDatasetFromOverview(int n, int n2, int n3) {
        if (null == this.dsVRT) {
            return null;
        }
        Driver driver = gdal.GetDriverByName("MEM");
        if (null == driver) {
            return null;
        }
        Band band = this.dsVRT.GetRasterBand(1);
        if (null == band) {
            return null;
        }
        int n4 = this.dsVRT.GetRasterCount();
        int n5 = band.GetRasterDataType();
        int n6 = n2 * n3 * (gdal.GetDataTypeSize(n5) / 8);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n6);
        byteBuffer.order(ByteOrder.nativeOrder());
        Double d = this.hasKey("gov.nasa.worldwind.avkey.MissingDataFlag") ? (Double)this.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") : null;
        Dataset dataset = driver.Create("overview", n2, n3, n4, n5);
        if (this.srs != null) {
            dataset.SetProjection(this.srs.ExportToWkt());
        }
        AffineTransform affineTransform = GDAL.getAffineTransform(this.dsVRT, n2, n3);
        double[] dArray = new double[]{affineTransform.getTranslateX(), affineTransform.getScaleX(), affineTransform.getShearX(), affineTransform.getTranslateY(), affineTransform.getShearY(), affineTransform.getScaleY()};
        dataset.SetGeoTransform(dArray);
        for (int i = 0; i < n4; ++i) {
            Band band2;
            Band band3 = this.dsVRT.GetRasterBand(i + 1);
            if (null == band3) continue;
            Band band4 = band2 = n == -1 ? band3 : band3.GetOverview(n);
            if (null == band2) continue;
            Band band5 = dataset.GetRasterBand(i + 1);
            if (null != d) {
                band5.SetNoDataValue(d);
            }
            int n7 = band3.GetColorInterpretation();
            band5.SetColorInterpretation(n7);
            if (n7 == gdalconst.GCI_PaletteIndex) {
                band5.SetColorTable(band3.GetColorTable());
            }
            byteBuffer.rewind();
            band2.ReadRaster_Direct(0, 0, band2.getXSize(), band2.getYSize(), n2, n3, n5, byteBuffer);
            byteBuffer.rewind();
            band5.WriteRaster_Direct(0, 0, n2, n3, n5, byteBuffer);
        }
        return dataset;
    }

    protected Dataset createCompatibleDataset(int n, int n2, Sector sector, AVList aVList) {
        Object object;
        if (n <= 0) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Driver driver = gdal.GetDriverByName("MEM");
        int n3 = this.dsVRT.getRasterCount();
        Band band = this.dsVRT.GetRasterBand(1);
        int n4 = band.getDataType();
        int[] nArray = new int[]{gdalconst.GCI_RedBand, gdalconst.GCI_GreenBand, gdalconst.GCI_BlueBand, gdalconst.GCI_AlphaBand};
        int n5 = 4;
        String string = this.getStringValue("gov.nasa.worldwind.avkey.PixelFormat");
        String string2 = this.getStringValue("gov.nasa.worldwind.avkey.ImageColorFormat");
        if ("gov.nasa.worldwind.avkey.Elevation".equals(string)) {
            n5 = 1;
            nArray = new int[]{gdalconst.GCI_GrayIndex};
        } else if ("gov.nasa.worldwind.avkey.Image".equals(string) && "gov.nasa.worldwind.avkey.Grayscale".equals(string2)) {
            nArray = new int[]{gdalconst.GCI_GrayIndex, gdalconst.GCI_AlphaBand};
            n5 = 2;
        } else if ("gov.nasa.worldwind.avkey.Image".equals(string) && "gov.nasa.worldwind.avkey.Color".equals(string2)) {
            nArray = new int[]{gdalconst.GCI_RedBand, gdalconst.GCI_GreenBand, gdalconst.GCI_BlueBand, gdalconst.GCI_AlphaBand};
            if ("gov.nasa.worldwind.avkey.Int16".equals(this.getValue("gov.nasa.worldwind.avkey.DataType")) && n3 > 3) {
                n5 = 3;
            } else if (n3 >= 3) {
                n5 = 4;
            } else {
                n5 = 1;
                nArray = new int[]{gdalconst.GCI_PaletteIndex};
            }
        }
        Dataset dataset = driver.Create("roi", n, n2, n5, n4);
        Double d = AVListImpl.getDoubleValue(this, "gov.nasa.worldwind.avkey.MissingDataFlag", null);
        Double d2 = AVListImpl.getDoubleValue(this, "gov.nasa.worldwind.avkey.ElevationMinKey", null);
        Double d3 = AVListImpl.getDoubleValue(this, "gov.nasa.worldwind.avkey.ElevationMaxKey", null);
        d = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.MissingDataValue", d);
        for (int i = 0; i < n5; ++i) {
            object = dataset.GetRasterBand(i + 1);
            if (d != null) {
                ((Band)object).SetNoDataValue(d);
            }
            Band band2 = i < n3 ? this.dsVRT.GetRasterBand(i + 1) : null;
            int n6 = gdalconst.GCI_Undefined;
            if (null != band2) {
                n6 = band2.GetColorInterpretation();
                if (n6 == gdalconst.GCI_Undefined) {
                    n6 = nArray[i];
                }
                ((Band)object).SetColorInterpretation(n6);
                if (n6 == gdalconst.GCI_PaletteIndex) {
                    ((Band)object).SetColorTable(band2.GetColorTable());
                }
            } else {
                n6 = nArray[i];
                ((Band)object).SetColorInterpretation(n6);
            }
            if (n6 == gdalconst.GCI_AlphaBand) {
                ((Band)object).Fill(GDALUtils.ALPHA_MASK);
            }
            if (null == d || n6 != gdalconst.GCI_GrayIndex) continue;
            ((Band)object).Fill(d);
            if (null == band2 || d2 == null || d3 == null) continue;
            ((Band)object).SetStatistics(d2, d3, 0.0, 0.0);
        }
        if (null != sector) {
            SpatialReference spatialReference = GDALUtils.createGeographicSRS();
            object = spatialReference.ExportToWkt();
            dataset.SetProjection((String)object);
            dataset.SetGeoTransform(GDALUtils.calcGetGeoTransform(sector, n, n2));
        }
        String[] stringArray = new String[]{"gov.nasa.worldwind.avkey.RasterBand.ActualBitsPerPixel", "gov.nasa.worldwind.avkey.RasterBand.MaxPixelValue"};
        WWUtil.copyValues(this, aVList, stringArray, true);
        return dataset;
    }

    @Override
    public DataRaster getSubRaster(AVList aVList) {
        if (aVList.hasKey("gov.nasa.worldwind.avkey.BandsOrder")) {
            GDALUtils.extractBandOrder(this.dsVRT, aVList);
        }
        String[] stringArray = new String[]{"gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.MissingDataFlag", "gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.ElevationUnit"};
        WWUtil.copyValues(this, aVList, stringArray, false);
        return super.getSubRaster(aVList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DataRaster doGetSubRaster(int n, int n2, Sector sector, AVList aVList) {
        Object object = this.usageLock;
        synchronized (object) {
            Dataset dataset3 = null;
            Dataset dataset2 = null;
            Dataset dataset = null;
            DataRaster dataRaster = null;
            try {
                String string;
                gdal.PushErrorHandler("CPLQuietErrorHandler");
                AVList aVList2 = aVList = null == aVList ? new AVListImpl() : aVList;
                if (null != sector) {
                    aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
                }
                aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
                aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
                if (null == sector || Sector.EMPTY_SECTOR.equals(sector) || !this.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem") || "gov.nasa.worldwind.avkey.CoordinateSystem.Unknown".equals(this.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"))) {
                    DataRaster dataRaster2 = GDALUtils.composeDataRaster(this.dsVRT, aVList);
                    return dataRaster2;
                }
                dataset3 = this.createCompatibleDataset(n, n2, sector, aVList);
                String string2 = dataset3.GetProjection();
                if (null == this.area || null == this.srs || !this.area.contains(new GDAL.Area(this.srs, sector))) {
                    dataset2 = this.createMaskDataset(n, n2, sector);
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = System.currentTimeMillis();
                long l5 = System.currentTimeMillis();
                dataset = this.getBestSuitedDataset(n, n2, sector);
                if (dataset == this.dsVRT) {
                    string = Logging.getMessage("gdal.UseFullResolutionRaster", this.getWidth(), this.getHeight(), n, n2);
                    Logging.logger().finest(string);
                }
                l3 = System.currentTimeMillis() - l5;
                l5 = System.currentTimeMillis();
                if (this.srs != null) {
                    string = this.srs.ExportToWkt();
                    gdal.ReprojectImage(dataset, dataset3, string, string2, gdalconst.GRA_Bilinear);
                    l = System.currentTimeMillis() - l5;
                    l5 = System.currentTimeMillis();
                    if (null != dataset2) {
                        gdal.ReprojectImage(dataset, dataset2, string, string2, gdalconst.GRA_NearestNeighbour);
                    }
                    l2 = System.currentTimeMillis() - l5;
                } else {
                    gdal.ReprojectImage(dataset, dataset3);
                    l = System.currentTimeMillis() - l5;
                    l5 = System.currentTimeMillis();
                    if (null != dataset2) {
                        gdal.ReprojectImage(dataset, dataset2);
                    }
                    l2 = System.currentTimeMillis() - l5;
                }
                string = GDALUtils.getErrorMessage();
                if (string != null) {
                    String string3 = Logging.getMessage("gdal.InternalError", string);
                    Logging.logger().severe(string3);
                }
                if (null != dataset2) {
                    aVList.setValue("gov.nasa.worldwind.avkey.GDAL.MaskDataset", dataset2);
                }
                l5 = System.currentTimeMillis();
                dataRaster = GDALUtils.composeDataRaster(dataset3, aVList);
                long l6 = System.currentTimeMillis() - l5;
                Logging.logger().finest("doGetSubRaster(): [" + n + "x" + n2 + "] - " + " totalTime = " + (System.currentTimeMillis() - l4) + " msec { Cropping = " + l3 + " msec, Reprojection = " + l + " msec, Masking = " + l2 + " msec, Composing = " + l6 + " msec }");
            }
            finally {
                gdal.PopErrorHandler();
                if (null != dataset2) {
                    dataset2.delete();
                }
                if (null != dataset3 && dataset3 != this.dsVRT) {
                    dataset3.delete();
                }
                if (null != dataset && dataset != this.dsVRT) {
                    dataset.delete();
                }
            }
            return dataRaster;
        }
    }

    protected static Band findAlphaBand(Dataset dataset) {
        if (null != dataset) {
            int n;
            for (int i = n = dataset.getRasterCount(); i > 0; --i) {
                Band band = dataset.GetRasterBand(i);
                if (band.GetColorInterpretation() != gdalconst.GCI_AlphaBand) continue;
                return band;
            }
        }
        return null;
    }

    protected static String convertAVListToString(AVList aVList) {
        if (null == aVList) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("{ ");
        Vector<String> vector = new Vector<String>();
        Set<Map.Entry<String, Object>> set = aVList.getEntries();
        for (Map.Entry<String, Object> object : set) {
            vector.add(object.getKey());
        }
        Collections.sort(vector);
        for (String string : vector) {
            stringBuffer.append("\n").append(string).append("=").append(aVList.getValue(string));
        }
        stringBuffer.append("\n};");
        return stringBuffer.toString();
    }

    public String toString() {
        return "GDALDataRaster " + GDALDataRaster.convertAVListToString(this);
    }

    protected boolean intersects(Sector sector) {
        if (null != sector) {
            if (null != this.area) {
                return null != this.area.intersection(sector);
            }
            return sector.intersects(this.getSector());
        }
        return false;
    }

    @Override
    public long getSizeInBytes() {
        return 2048L;
    }
}

