/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.TimedExpirySupport;
import java.util.HashMap;
import java.util.Iterator;

public class ShapeDataCache
implements Iterable<ShapeDataCacheEntry> {
    protected HashMap<Globe, ShapeDataCacheEntry> entries = new HashMap(1);
    protected long maxTimeSinceLastUsed;

    public ShapeDataCache(long l) {
        this.maxTimeSinceLastUsed = l;
    }

    @Override
    public Iterator<ShapeDataCacheEntry> iterator() {
        return this.entries.values().iterator();
    }

    public void addEntry(ShapeDataCacheEntry shapeDataCacheEntry) {
        if (shapeDataCacheEntry == null) {
            return;
        }
        this.entries.put(shapeDataCacheEntry.globeStateKey.getGlobe(), shapeDataCacheEntry);
        shapeDataCacheEntry.lastUsed = System.currentTimeMillis();
    }

    public ShapeDataCacheEntry getEntry(Globe globe) {
        long l = System.currentTimeMillis();
        if (globe == null) {
            return null;
        }
        ShapeDataCacheEntry shapeDataCacheEntry = this.entries.get(globe);
        if (shapeDataCacheEntry != null) {
            shapeDataCacheEntry.lastUsed = l;
        }
        return shapeDataCacheEntry;
    }

    public void setAllExpired(boolean bl) {
        for (ShapeDataCacheEntry shapeDataCacheEntry : this.entries.values()) {
            shapeDataCacheEntry.setExpired(bl);
        }
    }

    public void clearExtents() {
        for (ShapeDataCacheEntry shapeDataCacheEntry : this.entries.values()) {
            shapeDataCacheEntry.setExtent(null);
        }
    }

    public void removeAllEntries() {
        this.entries.clear();
    }

    public static class ShapeDataCacheEntry
    extends AVListImpl {
        protected TimedExpirySupport timer;
        protected long lastUsed = System.currentTimeMillis();
        protected GlobeStateKey globeStateKey;
        protected double verticalExaggeration;
        protected Extent extent;
        protected double eyeDistance;

        public ShapeDataCacheEntry(DrawContext drawContext, long l, long l2) {
            this.timer = new TimedExpirySupport(Math.max(l, 0L), Math.max(l2, 0L));
            this.globeStateKey = drawContext != null ? drawContext.getGlobe().getGlobeStateKey(drawContext) : null;
            this.verticalExaggeration = drawContext != null ? drawContext.getVerticalExaggeration() : 1.0;
        }

        public boolean isValid(DrawContext drawContext) {
            return this.verticalExaggeration == drawContext.getVerticalExaggeration() && this.globeStateKey != null && this.globeStateKey.equals(drawContext.getGlobe().getGlobeStateKey(drawContext));
        }

        public boolean isExpired(DrawContext drawContext) {
            return drawContext != null ? this.timer.isExpired(drawContext) : this.timer.isExpired(System.currentTimeMillis());
        }

        public void setExpired(boolean bl) {
            this.timer.setExpired(bl);
        }

        public void restartTimer(DrawContext drawContext) {
            this.timer.restart(drawContext);
        }

        public double getEyeDistance() {
            return this.eyeDistance;
        }

        public void setEyeDistance(double d) {
            this.eyeDistance = d;
        }

        public Extent getExtent() {
            return this.extent;
        }

        public void setExtent(Extent extent) {
            this.extent = extent;
        }

        public TimedExpirySupport getTimer() {
            return this.timer;
        }

        public void setTimer(TimedExpirySupport timedExpirySupport) {
            this.timer = timedExpirySupport;
        }

        public GlobeStateKey getGlobeStateKey() {
            return this.globeStateKey;
        }

        public void setGlobeStateKey(GlobeStateKey globeStateKey) {
            this.globeStateKey = globeStateKey;
        }

        public double getVerticalExaggeration() {
            return this.verticalExaggeration;
        }

        public void setVerticalExaggeration(double d) {
            this.verticalExaggeration = d;
        }
    }
}

