/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.util.Logging;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class BasicRasterServerCache
extends BasicMemoryCache {
    protected static final int DEFAULT_INACCESSIBLE_MEMORY_SIZE = 0x6400000;
    protected static final long DEFAULT_PRUNER_THREAD_TIMEOUT_MSEC = 5000L;
    protected static final long DEFAULT_LEAST_RECENTLY_USED_TIMEOUT_NSEC = 20000000000L;
    protected AtomicInteger inaccessibleMemorySize = new AtomicInteger(0x6400000);
    protected final ReferenceQueue<Object> queue = new ReferenceQueue();
    protected Reference<Object> lowMemorySemaphore = null;
    protected long timeoutLeastRecentUseInNanoSeconds = 20000000000L;
    private final ReentrantLock removalLock = new ReentrantLock();

    public BasicRasterServerCache() {
        super(0L, Runtime.getRuntime().freeMemory() + Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory());
        new Thread(new MemoryMonitorThread()).start();
        new Thread(new CachePrunerThread()).start();
    }

    public BasicRasterServerCache(int n) {
        this();
        this.inaccessibleMemorySize.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object object, Object object2, long l) {
        BasicMemoryCache.CacheEntry cacheEntry = new BasicMemoryCache.CacheEntry(object, object2, l);
        Object object3 = this.lock;
        synchronized (object3) {
            this.removeExpiredEntries();
            BasicMemoryCache.CacheEntry cacheEntry2 = (BasicMemoryCache.CacheEntry)this.entries.get(object);
            if (cacheEntry2 != null) {
                this.removeEntry(cacheEntry2);
            }
            this.currentUsedCapacity.addAndGet(l);
            this.entries.putIfAbsent(cacheEntry.key, cacheEntry);
            this.updateMemorySemaphore();
        }
        return true;
    }

    protected void updateMemorySemaphore() {
        try {
            if (this.lowMemorySemaphore == null || null == this.lowMemorySemaphore.get()) {
                this.lowMemorySemaphore = new SoftReference<Object>(new byte[this.inaccessibleMemorySize.get()], this.queue);
            }
        }
        catch (Throwable throwable) {
            Logging.logger().finest(throwable.getMessage());
        }
    }

    public long getLeastRecentUseTimeout() {
        return this.timeoutLeastRecentUseInNanoSeconds;
    }

    public void setLeastRecentUseTimeout(long l) {
        this.timeoutLeastRecentUseInNanoSeconds = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExpiredEntries() {
        if (this.entries.size() == 0) {
            return;
        }
        if (this.removalLock.tryLock()) {
            try {
                BasicMemoryCache.CacheEntry[] cacheEntryArray = new BasicMemoryCache.CacheEntry[this.entries.size()];
                Arrays.sort(this.entries.values().toArray(cacheEntryArray));
                for (BasicMemoryCache.CacheEntry cacheEntry : cacheEntryArray) {
                    if (null == cacheEntry || System.nanoTime() - cacheEntry.lastUsed <= this.getLeastRecentUseTimeout()) continue;
                    this.removeEntry(cacheEntry);
                }
            }
            finally {
                this.removalLock.unlock();
            }
        }
    }

    private class CachePrunerThread
    implements Runnable {
        private CachePrunerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        BasicRasterServerCache.this.removeExpiredEntries();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                    }
                }
            }
            catch (Throwable throwable) {
                if (Thread.currentThread().isInterrupted()) {
                    Thread.interrupted();
                }
                throw throwable;
            }
        }
    }

    private class MemoryMonitorThread
    implements Runnable {
        private MemoryMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        Reference<Object> reference;
                        if (null == (reference = BasicRasterServerCache.this.queue.remove())) {
                            continue;
                        }
                        reference.clear();
                        BasicRasterServerCache.this.clear();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                    }
                }
            }
            catch (Throwable throwable) {
                if (Thread.currentThread().isInterrupted()) {
                    Thread.interrupted();
                }
                throw throwable;
            }
        }
    }
}

