/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.stores;

import jams.workspace.DataReader;
import jams.workspace.DataSet;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSet;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jams.workspace.stores.StandardInputDataStore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TableDataStore
extends StandardInputDataStore {
    protected int[] currentPosition;
    protected int[] maxPosition;
    protected Set<DataReader> dataIOSet = new HashSet<DataReader>();
    protected DataReader[] dataIOArray;
    protected int[] positionArray;

    public TableDataStore(JAMSWorkspace ws) {
        super(ws);
    }

    public TableDataStore(JAMSWorkspace ws, String id, Document doc) throws ClassNotFoundException {
        super(ws, id, doc);
        if (ws.getRuntime().getState() == 0) {
            return;
        }
        if (!this.readCache()) {
            this.initDataAccess(doc);
        }
    }

    private void initDataAccess(Document doc) {
        int i;
        Element dataElement = (Element)doc.getElementsByTagName("data").item(0);
        NodeList columns = dataElement.getElementsByTagName("column");
        int colCount = columns.getLength();
        this.dataIOArray = new DataReader[colCount];
        this.positionArray = new int[colCount];
        for (i = 0; i < colCount; ++i) {
            Element columnElement = (Element)columns.item(i);
            this.dataIOArray[i] = (DataReader)this.dataIO.get(columnElement.getAttribute("dataio"));
            this.dataIOSet.add(this.dataIOArray[i]);
            this.positionArray[i] = Integer.parseInt(columnElement.getAttribute("sourcecolumn"));
        }
        this.currentPosition = new int[this.dataIOArray.length];
        this.maxPosition = new int[this.dataIOArray.length];
        for (i = 0; i < this.dataIOArray.length; ++i) {
            this.dataIOArray[i].init();
            this.currentPosition[i] = Integer.MAX_VALUE;
            this.maxPosition[i] = Integer.MAX_VALUE;
        }
    }

    protected void fillBuffer(int i) {
        DataReader io = this.dataIOArray[i];
        if (this.bufferSize > 0) {
            io.fetchValues(this.bufferSize);
        } else {
            io.fetchValues();
        }
        this.maxPosition[i] = Math.min(this.maxPosition[i], io.getData().length);
        this.currentPosition[i] = 0;
    }

    public boolean hasNext() {
        for (int i = 0; i < this.dataIOArray.length; ++i) {
            if (this.currentPosition[i] < this.maxPosition[i]) continue;
            this.fillBuffer(i);
            if (this.currentPosition[i] < this.maxPosition[i]) continue;
            return false;
        }
        return true;
    }

    public DefaultDataSet getNext() {
        DefaultDataSet result = new DefaultDataSet(this.positionArray.length);
        int i = 0;
        while (i < this.dataIOArray.length) {
            DataSet ds = this.dataIOArray[i].getData()[this.currentPosition[i]];
            DataValue[] values = ds.getData();
            result.setData(i, values[this.positionArray[i]]);
            int n = i++;
            this.currentPosition[n] = this.currentPosition[n] + 1;
        }
        return result;
    }

    public void close() {
        for (DataReader io : this.dataIOSet) {
            io.cleanup();
        }
    }

    public void setWorkspace(Workspace ws) throws IOException {
        this.ws = ws;
        for (DataReader io : this.dataIOSet) {
            io.setWorkspace(ws);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
    }

    private void writeObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

