/*
 * Decompiled with CFR 0.152.
 */
package jams.tools;

import java.util.Locale;
import java.util.StringTokenizer;

public class StringTools {
    public static final Locale STANDARD_LOCALE = Locale.US;

    public static boolean isEmptyString(String theString) {
        if (theString == null) {
            return true;
        }
        return (theString = theString.trim()).length() == 0;
    }

    public static boolean parseToBoolean(String theString) {
        if (StringTools.isEmptyString(theString)) {
            return false;
        }
        return theString.equals("1") || theString.equalsIgnoreCase("true") || theString.equalsIgnoreCase("on") || theString.equalsIgnoreCase("yes") || theString.equalsIgnoreCase("ja");
    }

    public static String getStackTraceString(StackTraceElement[] stea) {
        String result = "";
        for (StackTraceElement ste : stea) {
            result = result + "        at " + ste.toString() + "\n";
        }
        return result;
    }

    public static String[] toArray(String str) {
        return StringTools.toArray(str, null);
    }

    public static String[] toArray(String str, String delim) {
        if (str == null) {
            return null;
        }
        if (delim == null) {
            delim = "[\\s]+";
        }
        return str.split(delim);
    }

    public static String getPartOfToken(String theToken, int thePart, String delimiter) {
        String result = null;
        StringTokenizer tokenizer = new StringTokenizer(theToken, delimiter);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken();
            if (++i == thePart) {
                return result;
            }
            result = null;
        }
        return result;
    }

    public static String getGetterName(String attribName) {
        return "get" + attribName.substring(0, 1).toUpperCase(STANDARD_LOCALE) + attribName.substring(1);
    }

    public static String getSetterName(String attribName) {
        return "set" + attribName.substring(0, 1).toUpperCase(STANDARD_LOCALE) + attribName.substring(1);
    }

    public static boolean isDouble(String aString) {
        boolean isDouble = false;
        try {
            Double.parseDouble(aString);
            isDouble = true;
        }
        catch (NumberFormatException e) {
            System.out.println("could not parse " + aString + " to double.");
        }
        return isDouble;
    }
}

